/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.locking.AbstractLockStrategy;
import org.apache.ojb.odmg.locking.LockEntry;
import org.apache.ojb.odmg.locking.LockMap;
import org.apache.ojb.odmg.locking.LockStrategyFactory;

public class PersistentLockMapImpl
implements LockMap {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$locking$PersistentLockMapImpl == null ? (class$org$apache$ojb$odmg$locking$PersistentLockMapImpl = PersistentLockMapImpl.class$("org.apache.ojb.odmg.locking.PersistentLockMapImpl")) : class$org$apache$ojb$odmg$locking$PersistentLockMapImpl);
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$PersistentLockMapImpl;
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$LockEntry;

    private PersistenceBroker getBroker() {
        return TxManagerFactory.instance().getCurrentTransaction().getBroker();
    }

    private void unCache(LockEntry entry) {
        if (entry != null) {
            try {
                this.getBroker().removeFromCache(entry);
            }
            catch (PersistenceBrokerException e) {
                this.log.error("Could not remove entry from cache " + entry, (Throwable)((Object)e));
            }
        }
    }

    private void unCache(Collection col) {
        Iterator i = col.iterator();
        while (i.hasNext()) {
            try {
                this.getBroker().removeFromCache(i.next());
            }
            catch (PersistenceBrokerException e) {
                this.log.error("Could not remove entry from cache", (Throwable)((Object)e));
            }
        }
    }

    public LockEntry getWriter(Object obj) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        PersistenceBroker broker = this.getBroker();
        Identity oid = new Identity(obj, broker);
        Criteria criteria = new Criteria();
        criteria.addEqualTo("oidString", oid.toString());
        criteria.addEqualTo("lockType", new Integer(LockEntry.LOCK_WRITE));
        QueryByCriteria q = QueryFactory.newQuery(class$org$apache$ojb$odmg$locking$LockEntry == null ? (class$org$apache$ojb$odmg$locking$LockEntry = PersistentLockMapImpl.class$("org.apache.ojb.odmg.locking.LockEntry")) : class$org$apache$ojb$odmg$locking$LockEntry, criteria);
        LockEntry result = null;
        try {
            result = (LockEntry)this.getBroker().getObjectByQuery(q);
        }
        catch (PersistenceBrokerException e) {
            this.log.error((Object)e);
        }
        this.unCache(result);
        return result;
    }

    public Collection getReaders(Object obj) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        Identity oid = new Identity(obj, this.getBroker());
        Criteria criteria = new Criteria();
        criteria.addEqualTo("oidString", oid.toString());
        criteria.addEqualTo("lockType", new Integer(LockEntry.LOCK_READ));
        QueryByCriteria q = QueryFactory.newQuery(class$org$apache$ojb$odmg$locking$LockEntry == null ? (class$org$apache$ojb$odmg$locking$LockEntry = PersistentLockMapImpl.class$("org.apache.ojb.odmg.locking.LockEntry")) : class$org$apache$ojb$odmg$locking$LockEntry, criteria);
        try {
            Collection result = this.getBroker().getCollectionByQuery(q);
            this.unCache(result);
            return result;
        }
        catch (PersistenceBrokerException e) {
            this.log.error("Cannot obtain collection of LockEntries, query was " + q, (Throwable)((Object)e));
            return new Vector();
        }
    }

    public boolean addReader(TransactionImpl tx, Object obj) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        try {
            LockEntry lock = new LockEntry(new Identity(obj, this.getBroker()).toString(), tx.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(obj), LockEntry.LOCK_READ);
            this.getBroker().store(lock);
            this.unCache(lock);
            return true;
        }
        catch (PersistenceBrokerException e) {
            this.log.error("Cannot store LockEntry for object " + obj + " in transaction " + tx);
            return false;
        }
    }

    public void removeReader(TransactionImpl tx, Object obj) {
        try {
            LockEntry lock = new LockEntry(new Identity(obj, this.getBroker()).toString(), tx.getGUID());
            this.getBroker().delete(lock);
            this.unCache(lock);
        }
        catch (PersistenceBrokerException e) {
            this.log.error("Cannot remove LockEntry for object " + obj + " in transaction " + tx);
        }
    }

    public void removeWriter(LockEntry writer) {
        try {
            this.getBroker().delete(writer);
            this.unCache(writer);
        }
        catch (PersistenceBrokerException e) {
            this.log.error("Cannot remove LockEntry", (Throwable)((Object)e));
        }
    }

    public boolean upgradeLock(LockEntry reader) {
        reader.setLockType(LockEntry.LOCK_WRITE);
        try {
            this.getBroker().store(reader);
            this.unCache(reader);
            return true;
        }
        catch (PersistenceBrokerException e) {
            this.log.error("Cannot upgrade LockEntry " + reader, (Throwable)((Object)e));
            return false;
        }
    }

    public boolean setWriter(TransactionImpl tx, Object obj) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        try {
            LockEntry lock = new LockEntry(new Identity(obj, this.getBroker()).toString(), tx.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(obj), LockEntry.LOCK_WRITE);
            this.getBroker().store(lock);
            this.unCache(lock);
            return true;
        }
        catch (PersistenceBrokerException e) {
            this.log.error("Cannot set LockEntry for object " + obj + " in transaction " + tx);
            return false;
        }
    }

    public boolean hasReadLock(TransactionImpl tx, Object obj) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        try {
            LockEntry lock = new LockEntry(new Identity(obj, this.getBroker()).toString(), tx.getGUID());
            Identity oid = new Identity(lock, this.getBroker());
            LockEntry result = (LockEntry)this.getBroker().getObjectByIdentity(oid);
            this.unCache(result);
            return result != null;
        }
        catch (PersistenceBrokerException e) {
            this.log.error("Cannot check read lock for object " + obj + " in transaction " + tx, (Throwable)((Object)e));
            return false;
        }
    }

    protected void removeTimedOutLocks(long timeout) {
        int count = 0;
        long maxAge = System.currentTimeMillis() - timeout;
        Criteria criteria = new Criteria();
        criteria.addLessThan("timestamp", new Long(maxAge));
        QueryByCriteria q = QueryFactory.newQuery(class$org$apache$ojb$odmg$locking$LockEntry == null ? (class$org$apache$ojb$odmg$locking$LockEntry = PersistentLockMapImpl.class$("org.apache.ojb.odmg.locking.LockEntry")) : class$org$apache$ojb$odmg$locking$LockEntry, criteria);
        Iterator i = this.getBroker().getIteratorByQuery(q);
        while (i.hasNext()) {
            try {
                this.getBroker().delete(i.next());
                ++count;
            }
            catch (PersistenceBrokerException e) {
                this.log.error("Removing timed out lock failed", (Throwable)((Object)e));
            }
        }
        if (count > 0 && this.log.isDebugEnabled()) {
            this.log.debug("Removed " + count + " timedout locks");
        }
    }

    public void configure(Configuration pConfig) throws ConfigurationException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

