/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.otm.OTMKit;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.lock.LockListener;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.lock.wait.LockWaitStrategy;

public class ObjectLock {
    private Identity _oid;
    private LockEntry _writer;
    private HashMap _readers = new HashMap();

    public ObjectLock(Identity oid) {
        this._oid = oid;
    }

    public Identity getTargetIdentity() {
        return this._oid;
    }

    public Transaction getWriter() {
        return this._writer == null ? null : this._writer.getTx();
    }

    public boolean isReader(Transaction tx) {
        return this._readers.containsKey(tx);
    }

    public boolean doesReaderExists() {
        return this._readers.size() > 0;
    }

    public Collection getReaders() {
        return Collections.unmodifiableCollection(this._readers.keySet());
    }

    public void readLock(Transaction tx) {
        if (!this.isReader(tx)) {
            new LockEntry(tx);
        }
    }

    public void writeLock(Transaction tx) throws LockingException {
        if (this.getWriter() != tx) {
            LockEntry lock = (LockEntry)this._readers.get(tx);
            if (lock == null) {
                lock = new LockEntry(tx);
            }
            lock.writeLock();
        }
    }

    public void releaseLock(Transaction tx) {
        LockEntry lock = (LockEntry)this._readers.get(tx);
        if (lock != null) {
            lock.release();
        }
    }

    public void waitForTx(Transaction tx) throws LockingException {
        OTMKit kit = tx.getKit();
        LockWaitStrategy waitStrategy = kit.getLockWaitStrategy();
        waitStrategy.waitForLock(this, tx);
    }

    public boolean isFree() {
        return this._writer == null && this._readers.isEmpty();
    }

    private class LockEntry {
        public Transaction _tx;
        public ArrayList _listeners;

        public LockEntry(Transaction tx) {
            this._tx = tx;
            this._listeners = null;
            ObjectLock.this._readers.put(this._tx, this);
        }

        public ArrayList getListeners() {
            return this._listeners;
        }

        public Transaction getTx() {
            return this._tx;
        }

        public void addListener(LockListener listener) {
            if (listener != null) {
                if (this._listeners == null) {
                    this._listeners = new ArrayList();
                }
                this._listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeLock() throws LockingException {
            while (true) {
                if (ObjectLock.this._writer != null && ((ObjectLock)ObjectLock.this)._writer._tx != this._tx) {
                    ObjectLock.this.waitForTx(this._tx);
                }
                ObjectLock objectLock = ObjectLock.this;
                synchronized (objectLock) {
                    if (ObjectLock.this._writer == null || ((ObjectLock)ObjectLock.this)._writer._tx == this._tx) {
                        ObjectLock.this._writer = this;
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            ObjectLock objectLock = ObjectLock.this;
            synchronized (objectLock) {
                if (ObjectLock.this._writer == this) {
                    ObjectLock.this._writer = null;
                }
            }
            ObjectLock.this._readers.remove(this._tx);
            if (this._listeners != null) {
                Iterator iterator = this._listeners.iterator();
                while (iterator.hasNext()) {
                    LockListener listener = (LockListener)iterator.next();
                    listener.lockReleased(this._tx, ObjectLock.this._oid);
                }
            }
        }
    }
}

