/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.lock.isolation;

import java.util.Collection;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.lock.ObjectLock;
import org.apache.ojb.otm.lock.isolation.AbstractIsolation;

public class SerializableIsolation
extends AbstractIsolation {
    public void readLock(Transaction tx, ObjectLock lock) throws LockingException {
        Collection readers = lock.getReaders();
        if (readers.isEmpty()) {
            lock.readLock(tx);
            readers = lock.getReaders();
            if (readers.size() > 1) {
                lock.releaseLock(tx);
                this.readLock(tx, lock);
            }
        } else {
            Transaction reader = (Transaction)readers.iterator().next();
            if (reader != tx) {
                lock.waitForTx(reader);
            }
        }
    }

    public void writeLock(Transaction tx, ObjectLock lock) throws LockingException {
        Collection readers = lock.getReaders();
        if (readers.isEmpty()) {
            this.readLock(tx, lock);
            this.writeLock(tx, lock);
        } else {
            Transaction reader = (Transaction)readers.iterator().next();
            if (reader == tx) {
                lock.writeLock(tx);
            } else {
                lock.waitForTx(reader);
                this.writeLock(tx, lock);
            }
        }
    }
}

