/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.lock.wait;

import java.util.HashMap;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.lock.ObjectLock;
import org.apache.ojb.otm.lock.wait.ConcurrentModificationException;
import org.apache.ojb.otm.lock.wait.DeadlockException;
import org.apache.ojb.otm.lock.wait.LockWaitStrategy;

public class TimeoutStrategy
implements LockWaitStrategy {
    private static HashMap _waitsFor = new HashMap();
    private long _timeout;

    public TimeoutStrategy(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Illegal timeout value: " + timeout);
        }
        this._timeout = timeout;
    }

    public TimeoutStrategy() {
        this(30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLock(ObjectLock lock, Transaction tx) throws LockingException {
        ObjectLock writerWaitsForLock;
        Transaction writerTx = lock.getWriter();
        while (writerTx != null && (writerWaitsForLock = (ObjectLock)_waitsFor.get(writerTx)) != null && (writerTx = writerWaitsForLock.getWriter()) != null) {
            if (writerTx != tx) continue;
            StringBuffer sb = new StringBuffer();
            writerTx = lock.getWriter();
            sb.append(lock.getTargetIdentity());
            while (writerTx != tx) {
                writerWaitsForLock = (ObjectLock)_waitsFor.get(writerTx);
                sb.append(" -> ");
                sb.append(writerWaitsForLock.getTargetIdentity());
                writerTx = writerWaitsForLock.getWriter();
            }
            throw new DeadlockException(sb.toString());
        }
        _waitsFor.put(tx, lock);
        try {
            long now = System.currentTimeMillis();
            long deadline = System.currentTimeMillis() + this._timeout;
            do {
                if (lock.getWriter() == null) {
                    return;
                }
                try {
                    long toSleep = Math.min(deadline - now, 1000L);
                    Thread.sleep(toSleep);
                    now += toSleep;
                }
                catch (InterruptedException ex) {
                    now = System.currentTimeMillis();
                }
            } while (now < deadline);
            writerTx = lock.getWriter();
            if (writerTx != null) {
                throw new ConcurrentModificationException("Object [id: " + lock.getTargetIdentity() + "] locked by Transaction " + writerTx);
            }
        }
        finally {
            _waitsFor.remove(tx);
        }
    }
}

