/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.administration;

import java.util.Vector;

/**
 * Id: Attribute.java,v 1.0 3 mai 2005
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: Attribute
 * Original Author: Yohan Colmant
 * This class represents an attribute of SERVER and/or SPACE
 */
public class Attribute {

	public static String URL = "url";
	public static String UNAUTHENTICATED_SERVER_URL = "unauthenticatedServerUrl";
	public static String INJAC_PREVIEW_URL = "injacPreviewUrl";
	public static String SERVER_TYPE = "serverType";
	public static String SERVER_TYPE_WEBDAV = "webdav";
	public static String SERVER_TYPE_CIFS = "cifs";
	public static String AUTHENTICATION_MODE = "authenticationMode";
	public static String AUTHENTICATION_MODE_ASKED = "asked";
	public static String AUTHENTICATION_MODE_TRUSTED = "trusted";
	public static String LOGIN = "initialLoginFromTheConfigurationFile";
	public static String PASSWORD = "password";
	public static String MANAGE_ACL = "manageAcl";
	public static String MANAGE_ACL_TRUE = "true";
	public static String MANAGE_ACL_FALSE = "false";
	public static String ACL_NAMESPACE = "aclNamespace";
	public static String ACL_USER_PREFIX = "aclUserPrefix";
	public static String ACL_GROUP_PREFIX = "aclGroupPrefix";
	public static String ACL_UPORTAL_GROUP = "aclUportalGroup";
	public static String ACL_SECURITY = "aclSecurity";
	public static String CIFS_DOMAIN = "cifsDomain";
	public static String CIFS_RESOLVE_ORDER = "cifsResolveOrder";
	public static String CIFS_DISABLE_PLAIN_TEXT_PASSWORD = "cifsDisablePlainTextPassword";
	public static String CIFS_DISABLE_PLAIN_TEXT_PASSWORD_TRUE = "true";
	public static String CIFS_DISABLE_PLAIN_TEXT_PASSWORD_FALSE = "false";
	public static String CIFS_USE_UNICODE = "cifsUseUnicode";
	public static String CIFS_USE_UNICODE_TRUE = "true";
	public static String CIFS_USE_UNICODE_FALSE = "false";
	public static String CIFS_ENCODING = "cifsEncoding";
	
	public static String LABEL = "label";
	public static String PATH = "path";
	public static String PATH_REGEXP = "pathRegexp";
	public static String PATH_REGEXP_SEPARATOR = "pathRegexpSeparator";
	public static String ACTION_TYPE = "actionType";
	public static String ACTION_TYPE_CLASSIC = "classic";
	public static String ACTION_TYPE_INJAC = "injac";
	public static String SHARING = "sharing";
	public static String SHARING_TRUE = "true";
	public static String SHARING_FALSE = "false";
	
	
	/**
	 * This attribute's name
	 */
	private String name;
	
	/**
	 * This attribute's value
	 */
	private String value;
	
	/**
	 * If this attribute is obliged
	 */
	private boolean obliged;
	
	/**
	 * If this attribute is in good format
	 */
	private boolean modifiable;
	
	/**
	 * If this attribute is invisible or not
	 */
	private boolean invisible;
	
	/**
	 * If this attribute can have only values in this list
	 */
	private Vector availableValues;
	
	
	
	
	
	
	
	/**
	 * Constructor
	 * @param name the name to set to the attribute
	 */
	public Attribute(String name) {
		this.name = name;
		this.modifiable = true;
	}
	
	
	
	/**
	 * @return Returns the availableValues.
	 */
	public Vector getAvailableValues() {
		return availableValues;
	}
	/**
	 * @param availableValues The availableValues to set.
	 */
	public void setAvailableValues(Vector availableValues) {
		this.availableValues = availableValues;
	}
	/**
	 * @return Returns the goodFormat.
	 */
	public boolean isGoodFormat() {
		return !(isObliged() && (value==null || value.trim().equals("")) && !isInvisible());
	}
	/**
	 * @return Returns the modifiable.
	 */
	public boolean isModifiable() {
		return modifiable;
	}
	/**
	 * @param modifiable The modifiable to set.
	 */
	public void setModifiable(boolean modifiable) {
		this.modifiable = modifiable;
	}
	/**
	 * @return Returns the invisible.
	 */
	public boolean isInvisible() {
		return invisible;
	}
	/**
	 * @param invisible The invisible to set.
	 */
	public void setInvisible(boolean invisible) {
		this.invisible = invisible;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the obliged.
	 */
	public boolean isObliged() {
		return obliged;
	}
	/**
	 * @param obliged The obliged to set.
	 */
	public void setObliged(boolean obliged) {
		this.obliged = obliged;
	}
	/**
	 * @return Returns the value.
	 */
	public String getValue() {
		return value;
	}
	/**
	 * @param value The value to set.
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	
	
	/**
	 * Check if this is equals to another object
	 * @param o the object to check
	 * @return true if equals, false else
	 */
	public boolean equals(Object o) {
		Attribute a = (Attribute)o;
		if (a.getName().equals(this.getName())) {
			return true;
		}
		else return false;
	}
	
	
	
}
