/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.channelAction;

import java.io.InputStream;
import java.util.Vector;

import org.esupportail.portal.channels.CStockage.config.Space;
import org.esupportail.portal.channels.CStockage.provider.SortedChannelResource;

/**
 * Id: BufferAction.java,v 1.0 24 sept. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: BufferAction
 * Original Author: Yohan Colmant
 * The buffer used in different actions like the copy or move action
 */
public class BufferAction {

	/**
	 * The space from wich one we want to copy or move resource 
	 */
	private Space clipboardSpace;
	
	/**
	 * Files/directories to copy or move
	 */
	private Vector clipboard;
	
	/**
	 * The path where are the resource to copy or move
	 */
	private String clipboardPath;
	
	/**
	 * Param used to set if the selected target is to copy or to move
	 */
	private String clipboardParameter;
	
	/**
	 * the type of the selected resources
	 */
	private Vector types;
	
	/**
	 * Files/directories to delete
	 */
	private String[] filesToDelete;
	
	/**
	 * File/directory to rename
	 */
	private String fileToRename;
	

	

	/**
	 * The current and default sort type for the resources
	 */
	private String currentSortType = SortedChannelResource.SORT_TYPE;
	
	/**
	 * Used when we upload a document
	 */
	private InputStream inputStream;
	
	
	
	/**
	 * Default constructor
	 *
	 */
	public BufferAction() {		
	}
	
	

	
	
	/**
	 * @return Returns the inputStream.
	 */
	public InputStream getInputStream() {
		return inputStream;
	}
	/**
	 * @param inputStream The inputStream to set.
	 */
	public void setInputStream(InputStream inputStream) {
		this.inputStream = inputStream;
	}
	
	
	/**
	 * @return Returns the currentSortType.
	 */
	public String getCurrentSortType() {
		return currentSortType;
	}
	
	/**
	 * @param currentSortType The currentSortType to set.
	 */
	public void setCurrentSortType(String currentSortType) {
		this.currentSortType = currentSortType;
	}
	
	
	
	
	/**
	 * @return Returns the types.
	 */
	public Vector getTypes() {
		return types;
	}
	/**
	 * @param types The types to set.
	 */
	public void setTypes(Vector types) {
		this.types = types;
	}
	
	
	
	/**
	 * Returns the clipboardSpace
	 * @return Returns the clipboardSpace
	 */
	public Space getClipboardSpace() {
		return clipboardSpace;
	}
	
	/**
	 * Set the clipboard space
	 * @param clipboardSpace The clipboardSpaceAccess to set.
	 */
	public void setClipboardSpace(Space clipboardSpace) {
		this.clipboardSpace = clipboardSpace;
	}
	
	/**
	 * Return the clipboard
	 * @return Returns the clipboard.
	 */
	public Vector getClipboard() {
		return clipboard;
	}
	
	/**
	 * Set the clipboard
	 * @param clipboard The clipboard to set.
	 */
	public void setClipboard(Vector clipboard) {
		this.clipboard = clipboard;
	}
	
	/**
	 * Returns the clipboardParameter
	 * @return Returns the clipboardParameter.
	 */
	public String getClipboardParameter() {
		return clipboardParameter;
	}
	
	/**
	 * Set the clipboardParameter
	 * @param clipboardParameter The clipboardParameter to set.
	 */
	public void setClipboardParameter(String clipboardParameter) {
		this.clipboardParameter = clipboardParameter;
	}
	
	/**
	 * Return the clipboard path
	 * @return Returns the clipboardPath.
	 */
	public String getClipboardPath() {
		return clipboardPath;
	}
	
	/**
	 * Set the clipboard path
	 * @param clipboardPath The clipboardPath to set.
	 */
	public void setClipboardPath(String clipboardPath) {
		this.clipboardPath = clipboardPath;
	}
	
	/**
	 * Return the files to delete
	 * @return Returns the filesToDelete.
	 */
	public String[] getFilesToDelete() {
		return filesToDelete;
	}
	
	/**
	 * Set the files to delete
	 * @param filesToDelete The filesToDelete to set.
	 */
	public void setFilesToDelete(String[] filesToDelete) {
		this.filesToDelete = filesToDelete;
	}
	
	/**
	 * Return the file to rename
	 * @return Returns the fileToRename.
	 */
	public String getFileToRename() {
		return fileToRename;
	}
	
	/**
	 * Set the file rename
	 * @param fileToRename The fileToRename to set.
	 */
	public void setFileToRename(String fileToRename) {
		this.fileToRename = fileToRename;
	}
	
	
	
}
