/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.spacesPersonalization.target;


import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.exception.ServerException;
import org.esupportail.portal.channels.CStockage.userManagement.Group;
import org.jasig.portal.groups.EntityGroupImpl;

/**
 * Id: GroupForPersonalization.java,v 1.0 7 oct. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: GroupForPersonalization
 * Original Author: Yohan Colmant
 * Represents a group for the management during the personalization
 */
public class GroupForPersonalization extends Group {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(GroupForPersonalization.class);
	
	

	/**
	 * Object used for the personalization
	 */
	private Personalization personalization;

	
	
	
	
	/**
	 * Default constructor
	 */
	public GroupForPersonalization() {
		personalization = new Personalization();
	}
	
	
	
	/**
	 * Constructor
	 * @param key the group key
	 * @param displayName The displayed group name
	 * @throws ServerException
	 */
	public GroupForPersonalization(String key, String displayName) throws ServerException {
		super(key, displayName);
		personalization = new Personalization();
	}
	
	/**
	 * Constructor
	 * @param group this portal group value
	 * @throws ServerException
	 */
	public GroupForPersonalization(EntityGroupImpl group) throws ServerException {
		super(group);	
		personalization = new Personalization();
	}
	
	/**
	 * Constructor
	 * @param hierarchy this portal group hierarchy in this form: G1/G2/G3 where G1 is the root
	 * @throws ServerException
	 */
	public GroupForPersonalization(String hierarchy) throws ServerException {
		super(hierarchy);
		personalization = new Personalization();
	}

	
	
	

	/**
	 * @return Returns the personalization.
	 */
	public Personalization getPersonalization() {
		return personalization;
	}
	
	
	

	/**
	 * Clone this object to another similary one
	 * @return this cloned object
	 */
	public Object clone() {
		GroupForPersonalization clone = new GroupForPersonalization();
		clone.setKey(this.getKey());
		clone.setDisplayName(this.getDisplayName());
		if (this.getGroupHierarchy()!=null) {
			clone.setGroupHierarchy((Vector)this.getGroupHierarchy().clone());
		}
		else {
			clone.setGroupHierarchy(null);
		}
		clone.personalization = (Personalization)this.personalization.clone();
		return clone;
	}
	
	/**
	 * Compare this object to another one
	 */
	public boolean equals(Object o) {
		GroupForPersonalization comp = (GroupForPersonalization)o;
		
		return comp.key.equals(this.key) && comp.getPersonalization().equals(this.getPersonalization());
	}
	
	
	
	

	/**
	 * Return a String from this user
	 * @return a String from this user
	 */
	public String toString() {
		return super.toString()+" "+personalization.toString();
	}
}
