<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no"/>


<!--<xsl:variable name="baseActionURL"><xsl:value-of select="ROOT/baseActionURL" /></xsl:variable>-->
<xsl:param name="baseActionURL"/>

<xsl:template name="_navigation">




<script language="javascript">
	<![CDATA[

		function changeSpace(form) {		
			if (form.options[form.selectedIndex].value == '_management_') {
				document.manageSpaces.submit();
			}
			else {
				document.formulaireWebDav.submit();
			}
		}
		
	]]>
</script>
		
		
		


<table width="100%" border="0" cellspacing="5" cellpadding="0">
			<tr>

<xsl:if test="/ROOT/@spaces_personalization='true'">
	<td>
		<a class="uportal-navigation-channel" href="javascript:document.manageSpaces.submit();"><img src="media/org/esupportail/portal/channels/CStockage/sharing_settings_20px.gif" title="Gestion de mes espaces" border="0"/></a>
	</td>
	<td align="center">
		<img src="media/org/esupportail/portal/channels/CStockage/separator_small.jpg" border="0"/>
	</td>
</xsl:if>





<td>

<xsl:if test="((count(//ROOT/SPACES/DEFAULT_SPACE)+count(//ROOT/SPACES/PERSONAL_SPACE))>1) or (/ROOT/@spaces_personalization='true')">
<select name="space" onchange="changeSpace(this);" class="uportal-input-text">
	<optgroup class="uportal-input-text" label="Espaces par dfaut">
		<xsl:for-each select="/ROOT/SPACES/DEFAULT_SPACE">		
			<xsl:choose>
				<xsl:when test="@current='true'">
					<option class="uportal-input-text" value="{@key}" selected="true"><xsl:value-of select="@label"/></option>
				</xsl:when>
				<xsl:otherwise>
		 			<option class="uportal-input-text" value="{@key}"><xsl:value-of select="@label"/></option>
				</xsl:otherwise>
			</xsl:choose>		
		</xsl:for-each>
	</optgroup>
	
	<xsl:if test="/ROOT/SPACES/PERSONAL_SPACE/@key!=''">
	<optgroup class="uportal-input-text" label="Espaces prfrs">
		<xsl:for-each select="/ROOT/SPACES/PERSONAL_SPACE">		
			<xsl:choose>
				<xsl:when test="@current='true'">
					<xsl:choose>
						<xsl:when test="@from='administrated_server'">
							<option class="uportal-input-text" value="{@key}" selected="true"><xsl:value-of select="@label"/></option>
						</xsl:when>
						<xsl:otherwise>
							<option class="uportal-input-text" value="{@key}" selected="true"><xsl:value-of select="@label"/> (<xsl:value-of select="@from"/>)</option>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="@from='administrated_server'">
							<option class="uportal-input-text" value="{@key}"><xsl:value-of select="@label"/></option>
						</xsl:when>
						<xsl:otherwise>
							<option class="uportal-input-text" value="{@key}"><xsl:value-of select="@label"/> (<xsl:value-of select="@from"/>)</option>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>		
		</xsl:for-each>
		
	</optgroup>
	</xsl:if>

	<optgroup class="uportal-input-text" label="Personnalisation">
		<xsl:if test="/ROOT/@spaces_personalization='true'">
			<option class="uportal-channel-table-header" value="_management_">Gestion de mes espaces...</option>
		</xsl:if>
	</optgroup>
	
</select>	
</xsl:if>

</td>


<td width="100%">
<xsl:for-each select="/ROOT/NAVIGATION/DIR">	
	<xsl:if test="@link!='0'">
		&#160;&#62;&#160;	
	</xsl:if>
	<a class="uportal-navigation-channel" href="{$baseActionURL}?link={@link}"><xsl:value-of select="@label"/></a>
</xsl:for-each>
</td>



			</tr>
</table>

</xsl:template>



<!-- xsl:template match="/">
	
</xsl:template -->

</xsl:stylesheet>