<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no"/>

<xsl:template name="_quota">

		
		<style>
/* Rounded corners */
.smallroundedmodule{padding:0 4px;}
.smallroundedmodule div{border-style:solid;border-width:1px;margin:-2px -4px;height:1em;}
html>body .smallroundedmodule div{height:auto;}
.smallroundedmodule div div{border-style:none;border-width:0;margin:0 4px;}
.smallroundedmodule .first, .smallroundedmodule .last{position:relative;height:4px;margin:0;}			
.smallroundedmodule .first{border-width:1px 0 0 0;}
.smallroundedmodule .last{border-width:0 0 1px 0;}
.smallroundedmodule .first .first, .smallroundedmodule .first .last{margin-top:-1px;}
.smallroundedmodule .last .first, .smallroundedmodule .last .last{margin-bottom:-1px;}
.smallroundedmodule .first .first, .smallroundedmodule .first .last, .smallroundedmodule .last .first, .smallroundedmodule .last .last{border:0;position:absolute;z-index:1;width:4px;background-repeat:no-repeat;}
.smallroundedmodule .first .first, .smallroundedmodule .last .first{margin-left:-4px;}
.smallroundedmodule .first .last, .smallroundedmodule .last .last{right:0px;margin-right:-4px;}

/* Common elements */
#quotausagebar{position:relative;display:block;border-style:solid;border-width:1px;margin:2px 4px;height:1em;}
#quotausagebar span.first{position:absolute;height:100%;}
#quotausagebar span.last{width:100%;text-align:center;font:bold 78% verdana;}
html>body #quotausagebar span.last{display:block;width:auto;}

/* Common elements */
div#quotameter div{border-color:#d6deec;background-color:#FFF;}
#quotausagebar{border-color:#E6E6E6;}
div.lowquota span#quotausagebar span.first{background:#DBEBC1 url(media/org/esupportail/portal/channels/CStockage/classic/quota_green.gif) repeat-x center left;}
div.mediumquota span#quotausagebar span.first{background:#F9E9B5 url(media/org/esupportail/portal/channels/CStockage/classic/quota_orange.gif) repeat-x center left;}
div.highquota span#quotausagebar span.first{background:#FFC1C1 url(media/org/esupportail/portal/channels/CStockage/classic/quota_red.gif) repeat-x center left;}
div.basicquota span#quotausagebar span.first{background:#CCCCCC url(media/org/esupportail/portal/channels/CStockage/classic/quota_gray.gif) repeat-x center left;}
	</style>


<xsl:choose>
	<xsl:when test="/ROOT/quota/@level='low'">
		<div id="quotameter" class="smallroundedmodule lowquota">
			<xsl:call-template name="quotas"/>
		</div>
	</xsl:when>
	<xsl:otherwise>
		<xsl:choose>
			<xsl:when test="/ROOT/quota/@level='medium'">
				<div id="quotameter" class="smallroundedmodule mediumquota">
					<xsl:call-template name="quotas"/>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="/ROOT/quota/@level='high'">
						<div id="quotameter" class="smallroundedmodule highquota">
							<xsl:call-template name="quotas"/>
						</div>
					</xsl:when>
					<xsl:otherwise>
						<div id="quotameter" class="smallroundedmodule basicquota">
							<xsl:call-template name="quotas"/>
						</div>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:otherwise>
</xsl:choose>
		
</xsl:template>



<xsl:template name="quotas">
	<div class="first">
		<span class="first"></span>
		<span class="last"></span>
	</div>
	<div>
		<span id="quotausagebar">
			<xsl:choose>
				<xsl:when test="/ROOT/quota/use=''">
					<span class="first" style="width: 100%;"></span>
					<span class="last"><xsl:value-of select="/ROOT/quota/available"/> disponibles</span>
				</xsl:when>
				<xsl:otherwise>
					<span class="first" style="width: {/ROOT/quota/use}%;"></span>
					<span class="last"><xsl:value-of select="/ROOT/quota/use"/> % utiliss sur <xsl:value-of select="/ROOT/quota/total"/>&#160;&#160;</span>
				</xsl:otherwise>
			</xsl:choose>
		</span>
	</div>
	<div class="last">
		<span class="first"></span>
		<span class="last"></span>
	</div>
</xsl:template>

</xsl:stylesheet>