<?xml version='1.0' encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no" />
<xsl:param name="baseActionURL"/>

<xsl:template name="_users_groups">

	

<br/>
<table border="0" width="80%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption">Utilisateurs</td>
	</tr>
		
	
	<tr valign="top">
		<td width="90%">		
			<table border="0" width="100%" cellpadding="2" cellspacing="5">
				<tr >
					<td>&#160;</td>
					
					<td class="uportal-background-med" nowrap="true" align="left" colspan="2" width="90%">
						<div class="uportal-channel-table-header">
							Nom
						</div>
					</td>
					
					<td class="uportal-background-med" nowrap="true" align="center" width="10%">
						<div class="uportal-channel-table-header">
							Obligatoire
						</div>
					</td>				
				</tr>
				
				<xsl:for-each select="/ROOT/space/users/user">
					<tr>
						<td>
							<input type="checkbox" name="usersList" value="{@key}"/>							
						</td>
						<td class="uportal-channel-text" valign="center" align="left">
							<img src="media/org/esupportail/portal/channels/CStockage/user_20px.gif" border="0" />
						</td>
						<td class="uportal-channel-text" valign="center" align="left" width="100%">
							<xsl:value-of select="./@name" />
						</td>
						
						<td align="center">
							<xsl:choose>
								<xsl:when test="@obliged='true'">
									<input type="checkbox" name="obligedUserList" checked="true" value="{@key}"/>
								</xsl:when>
								<xsl:otherwise>
									<input type="checkbox" name="obligedUserList" value="{@key}"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>							
				<tr>				
					<td/>
					<td colspan="3">
						<input class="uportal-button" type="submit" value="Ajouter" name="add_user" />
						<input class="uportal-button" type="submit" value="Supprimer" name="delete_user" />
					</td>
				</tr>
			</table>
			<br/>
		</td>
		
		
	</tr>
	
</table>
<br/>





<table border="0" width="80%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption">Groupes</td>
	</tr>
		
	
	<tr valign="top">
		<td width="90%">		
			<table border="0" width="100%" cellpadding="2" cellspacing="5">
				<tr >
					<td>&#160;</td>
					
					<td class="uportal-background-med" nowrap="true" align="left" colspan="2" width="90%">
						<div class="uportal-channel-table-header">
							Nom
						</div>
					</td>
					
					<td class="uportal-background-med" nowrap="true" align="center" width="10%">
						<div class="uportal-channel-table-header">
							Obligatoire
						</div>
					</td>					
				</tr>
				
				<xsl:for-each select="/ROOT/space/groups/group">
					<tr>
						<td>
							<input type="checkbox" name="groupsList" value="{@key}"/>							
						</td>
						<td class="uportal-channel-text" valign="center" align="left">
							<img src="media/org/esupportail/portal/channels/CStockage/group_20px.gif" border="0" />
						</td>
						<td class="uportal-channel-text" valign="center" align="left" width="100%">
							<xsl:value-of select="./@name" />
						</td>
						
						<td align="center">
							<xsl:choose>
								<xsl:when test="@obliged='true'">
									<input type="checkbox" name="obligedGroupList" checked="true" value="{@key}"/>
								</xsl:when>
								<xsl:otherwise>
									<input type="checkbox" name="obligedGroupList" value="{@key}"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>
				<tr>				
					<td/>
					<td colspan="3">
						<input class="uportal-button" type="submit" value="Ajouter" name="add_group" />
						<input class="uportal-button" type="submit" value="Supprimer" name="delete_group" />
					</td>
				</tr>						
			</table>
				
			<br/>
		</td>
		
		
	</tr>
	
</table>




</xsl:template>
</xsl:stylesheet>