<?xml version='1.0' encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no" />
<xsl:param name="baseActionURL"/>

<xsl:template match="/">

	
	<script language="javascript">
		<![CDATA[

			// we check than there is a label set
			function checkLabel() {	
				if (document.form.label.value == "")
				 	alert ('Vous devez entrer un libell');
				else {
					document.form.mode.value = 'valid';
					document.form.submit();
				}
			}
			
			
			// we set that we change the value of using inheritance
			function changeInheritance() {	
				document.form.mode.value = 'change_inheritance';
				document.form.submit();
			}
			
			
			// we set that we change the value of public directory
			function changePublic() {	
				document.form.mode.value = 'change_public';
				document.form.submit();
			}

		]]>
	</script>
		

<form name="form" action="{$baseActionURL}?modeDav=share_directory_mode&amp;uP_root=root" method="post">

<input type="hidden" name="mode" value=""/>

<table border="0" width="100%" cellspacing="0" cellpadding="5">
	<tr class="uportal-background-light">				
		<td class="uportal-channel-table-header" nowrap="true">Partage de "<xsl:value-of select="/ROOT/directory/@name"/>"</td>
		<td width="100%">&#160;</td>		
		<td align="center">
			<a class="uportal-navigation-channel" href="javascript:checkLabel();">		
				<img src="media/org/esupportail/portal/channels/CStockage/valid_24px.gif" alt="Valider" border="0" />
				<br/>Valider
			</a>
		</td>
		<td align="center">
			<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=share_directory_mode&amp;mode=cancel&amp;uP_root=root">				
				<img src="media/org/esupportail/portal/channels/CStockage/cancel_24px.gif" alt="Annuler" border="0" />
				<br/>Annuler
			</a>
		</td>
		<xsl:if test="/ROOT/space_root/@value='false'">
			<td align="center">
				<img src="media/org/esupportail/portal/channels/CStockage/separator.jpg" border="0"/>
			</td>
			<td align="center">
				<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=confirm_delete_privileges_mode&amp;uP_root=root">				
					<img src="media/org/esupportail/portal/channels/CStockage/delete_24px.gif" alt="Supprimer tous les droits" border="0" />
					<br/><nobr>Supprimer tout</nobr>
				</a>
			</td>
		</xsl:if>
	</tr>
</table>


<!--div class="uportal-channel-table-caption" align="center">
<img src="media/org/esupportail/portal/channels/CStockage/classic/warning.gif" border="0" />   ATTENTION   <img src="media/org/esupportail/portal/channels/CStockage/classic/warning.gif" border="0" />
</div>
<div class="uportal-channel-strong" align="center">
Les droits positionns sur le rpertoire pre sont hrits par ce rpertoire mais non affichs ici
</div-->




<table border="0" width="100%" cellpadding="5" cellspacing="0">
<tr>
<td valign="top" align="center" width="50%">
	<table border="0" width="100%" cellpadding="5" cellspacing="0">
		<tr class="uportal-background-highlight">
			<td class="uportal-channel-table-caption">Libell</td>
		</tr>
		
		<tr>
			<td align="center">
				<input type="text" name="label" size="40" class="uportal-input-text" value="{/ROOT/label}"/>
			</td>
		</tr>
		
	</table>
</td>
<td valign="top" align="center" width="50%">
	<table border="0" width="100%" cellpadding="5" cellspacing="0">
		<tr class="uportal-background-highlight">
			<td class="uportal-channel-table-caption">Rpertoire public en lecture</td>
		</tr>
		
		<tr>
			<td align="center" valign="center">
				<!--input type="checkbox" name="useInherited" value="true"/><text class="uportal-text">  Utilisation des droits hrits</text-->
				<table border="0">
				<tr>
				<td>
				<xsl:choose>
					<xsl:when test="/ROOT/isPublic/@value='true'">
						<input type="radio" name="isPublic" value="true" checked="true" onClick="javascript:changePublic();"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="radio" name="isPublic" value="true" onClick="javascript:changePublic();"/>
					</xsl:otherwise>
				</xsl:choose>	
				</td>
				<td class="uportal-channel-text">
				<text>  OUI</text>
				</td>
				</tr>
				<tr>
				<td>
				<xsl:choose>
					<xsl:when test="/ROOT/isPublic/@value='true'">
						<input type="radio" name="isPublic" value="false" onClick="javascript:changePublic();"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="radio" name="isPublic" value="false" checked="true" onClick="javascript:changePublic();"/>
					</xsl:otherwise>
				</xsl:choose>
				</td>
				<td class="uportal-channel-text">
				<text>  NON</text>
				</td>
				</tr>
				</table>
			</td>
		</tr>
		
		<xsl:if test="(/ROOT/isPublic/@url!='') and (/ROOT/isPublic/@value='true')">
			<tr>
				<td align="center">
					<text class="uportal-channel-strong">Lien direct: </text>
					<a target="_blank" class="uportal-navigation-channel" href="{/ROOT/isPublic/@url}"><xsl:value-of select="/ROOT/isPublic/@url"/></a>
				</td>
			</tr>
		</xsl:if>
		
	</table>
</td>
</tr>


<tr>
<td colspan="2">
	<hr/>
</td>
</tr>


<tr>
<td valign="top" align="center">

<xsl:for-each select="/ROOT/users">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption">Utilisateurs</td>
	</tr>
		
	
	<tr valign="top">
		<td width="90%">		
			
	
			<table border="0" width="100%" cellpadding="2" cellspacing="5">
				<tr >
					<td>&#160;</td>
					
					<td class="uportal-background-med" nowrap="true" align="left" colspan="2" width="70%">
						<div class="uportal-channel-table-header">
							Nom
						</div>
					</td>
					
					<td class="uportal-background-med" nowrap="true" align="center" width="10%">
						<div class="uportal-channel-table-header">
							Lecture
						</div>
					</td>		
					<td class="uportal-background-med" nowrap="true" align="center" width="10%">
						<div class="uportal-channel-table-header">
							Ecriture
						</div>
					</td>
					<td class="uportal-background-med" nowrap="true" align="center" width="10%">
						<div class="uportal-channel-table-header">
							Partage
						</div>
					</td>
							
				</tr>
				
				<xsl:for-each select="user">
					<tr>
						<td>
							<xsl:choose>
								<xsl:when test="@modifiable='false'">
									<input type="checkbox" name="usersList" value="{@key}" disabled="true"/>
								</xsl:when>
								<xsl:otherwise>
									<input type="checkbox" name="usersList" value="{@key}"/>
								</xsl:otherwise>
							</xsl:choose>						
						</td>
						<td class="uportal-channel-text" valign="center" align="left">
							<img src="media/org/esupportail/portal/channels/CStockage/user_20px.gif" border="0" />
						</td>
						<td class="uportal-channel-text" valign="center" align="left" width="100%">
							<xsl:value-of select="./@name" />
							<xsl:if test="@inherited='true'">
								<text class="uportal-crumbtrail">
									&#160;(propos par dfaut)
								</text>
							</xsl:if>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@modifiable='false'">
									<xsl:choose>
										<xsl:when test="@read='1'">
											<input type="checkbox" name="readUserList" checked="true" value="{@key}" disabled="true"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="readUserList" value="{@key}" disabled="true"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@read='1'">
											<input type="checkbox" name="readUserList" checked="true" value="{@key}"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="readUserList" value="{@key}"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@modifiable='false'">
									<xsl:choose>
										<xsl:when test="@write='1'">
											<input type="checkbox" name="writeUserList" checked="true" value="{@key}" disabled="true"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="writeUserList" value="{@key}" disabled="true"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@write='1'">
											<input type="checkbox" name="writeUserList" checked="true" value="{@key}"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="writeUserList" value="{@key}"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@modifiable='false'">
									<xsl:choose>
										<xsl:when test="@manage='1'">
											<input type="checkbox" name="manageUserList" checked="true" value="{@key}" disabled="true"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="manageUserList" value="{@key}" disabled="true"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@manage='1'">
											<input type="checkbox" name="manageUserList" checked="true" value="{@key}"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="manageUserList" value="{@key}"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>							
				
			
			<tr>
					<td/>
					<td colspan="3">
						<input class="uportal-button" type="submit" value="Ajouter" name="add_user" />
						<input class="uportal-button" type="submit" value="Supprimer" name="delete_user" />
					</td>
			</tr>
			
			</table>
			
			
		</td>
		
		
	</tr>
	
</table>
</xsl:for-each>

</td>




<td valign="top" align="center">
<xsl:for-each select="/ROOT/groups">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption">Groupes</td>
	</tr>
		
	
	<tr valign="top">
		<td width="90%">		
			<table border="0" width="100%" cellpadding="2" cellspacing="5">
				<tr >
					<td>&#160;</td>
					
					<td class="uportal-background-med" nowrap="true" align="left" colspan="2" width="70%">
						<div class="uportal-channel-table-header">
							Nom
						</div>
					</td>
					
					<td class="uportal-background-med" nowrap="true" align="center" width="10%">
						<div class="uportal-channel-table-header">
							Lecture
						</div>
					</td>		
					<td class="uportal-background-med" nowrap="true" align="center" width="10%">
						<div class="uportal-channel-table-header">
							Ecriture
						</div>
					</td>
					<td class="uportal-background-med" nowrap="true" align="center" width="10%">
						<div class="uportal-channel-table-header">
							Partage
						</div>
					</td>	
						
				</tr>
				
				<xsl:for-each select="group">
					<tr>
						<td>
							<xsl:choose>
								<xsl:when test="@modifiable='false'">
									<input type="checkbox" name="groupsList" value="{@key}" disabled="true"/>
								</xsl:when>
								<xsl:otherwise>
									<input type="checkbox" name="groupsList" value="{@key}"/>
								</xsl:otherwise>
							</xsl:choose>							
						</td>
						<td class="uportal-channel-text" valign="center" align="left">
							<img src="media/org/esupportail/portal/channels/CStockage/group_20px.gif" border="0" />
						</td>
						<td class="uportal-channel-text" valign="center" align="left" width="100%">
							<xsl:value-of select="./@name" />
							<xsl:if test="@inherited='true'">
								&#160;(propos par dfaut)
							</xsl:if>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@modifiable='false'">
									<xsl:choose>
										<xsl:when test="@read='1'">
											<input type="checkbox" name="readGroupList" checked="true" value="{@key}" disabled="true"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="readGroupList" value="{@key}" disabled="true"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@read='1'">
											<input type="checkbox" name="readGroupList" checked="true" value="{@key}"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="readGroupList" value="{@key}"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@modifiable='false'">
									<xsl:choose>
										<xsl:when test="@write='1'">
											<input type="checkbox" name="writeGroupList" checked="true" value="{@key}" disabled="true"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="writeGroupList" value="{@key}" disabled="true"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@write='1'">
											<input type="checkbox" name="writeGroupList" checked="true" value="{@key}"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="writeGroupList" value="{@key}"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@modifiable='false'">
									<xsl:choose>
										<xsl:when test="@manage='1'">
											<input type="checkbox" name="manageGroupList" checked="true" value="{@key}" disabled="true"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="manageGroupList" value="{@key}" disabled="true"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@manage='1'">
											<input type="checkbox" name="manageGroupList" checked="true" value="{@key}"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="manageGroupList" value="{@key}"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>
				<tr>				
					<td/>
					<td colspan="3">
						<input class="uportal-button" type="submit" value="Ajouter" name="add_group" />
						<input class="uportal-button" type="submit" value="Supprimer" name="delete_group" />
					</td>
				</tr>						
			</table>
			
		</td>
		
		
	</tr>
	
</table>
</xsl:for-each>

</td>
</tr>

<!-- tr>
<td colspan="2" valign="top" align="center">
<xsl:for-each select="/ROOT/others">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption">Autres destinataires</td>
	</tr>
		
	
	<tr valign="top">
		<td width="90%">		
			
	
			<table border="0" width="100%" cellpadding="2" cellspacing="5">
				<tr >
					<td>&#160;</td>
					
					<td class="uportal-background-med" nowrap="true" align="left" colspan="2" width="70%">
						<div class="uportal-channel-table-header">
							Nom
						</div>
					</td>
					
					<td class="uportal-background-med" nowrap="true" align="center" width="10%">
						<div class="uportal-channel-table-header">
							Lecture
						</div>
					</td>		
					<td class="uportal-background-med" nowrap="true" align="center" width="10%">
						<div class="uportal-channel-table-header">
							Ecriture
						</div>
					</td>
					<td class="uportal-background-med" nowrap="true" align="center" width="10%">
						<div class="uportal-channel-table-header">
							Partage
						</div>
					</td>
							
				</tr>
				
				<xsl:for-each select="other">
					<tr>
						<td>
							<xsl:choose>
								<xsl:when test="@modifiable='false'">
									<input type="checkbox" name="othersList" value="{@key}" disabled="true"/>
								</xsl:when>
								<xsl:otherwise>
									<input type="checkbox" name="othersList" value="{@key}"/>
								</xsl:otherwise>
							</xsl:choose>						
						</td>
						<td class="uportal-channel-text" valign="center" align="left">
							<img src="media/org/esupportail/portal/channels/CStockage/other_20px.gif" border="0" />
						</td>
						<td class="uportal-channel-text" valign="center" align="left" width="100%">
							<xsl:value-of select="./@name" />
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@modifiable='false'">
									<xsl:choose>
										<xsl:when test="@read='1'">
											<input type="checkbox" name="readOtherList" checked="true" value="{@key}" disabled="true"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="readOtherList" value="{@key}" disabled="true"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@read='1'">
											<input type="checkbox" name="readOtherList" checked="true" value="{@key}"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="readOtherList" value="{@key}"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@modifiable='false'">
									<xsl:choose>
										<xsl:when test="@write='1'">
											<input type="checkbox" name="writeOtherList" checked="true" value="{@key}" disabled="true"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="writeOtherList" value="{@key}" disabled="true"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@write='1'">
											<input type="checkbox" name="writeOtherList" checked="true" value="{@key}"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="writeOtherList" value="{@key}"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@modifiable='false'">
									<xsl:choose>
										<xsl:when test="@manage='1'">
											<input type="checkbox" name="manageOtherList" checked="true" value="{@key}" disabled="true"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="manageOtherList" value="{@key}" disabled="true"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@manage='1'">
											<input type="checkbox" name="manageOtherList" checked="true" value="{@key}"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="manageOtherList" value="{@key}"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						
					</tr>
				</xsl:for-each>							
				
			
			
			</table>
			
			
			
			
			
			
		</td>
		
		
	</tr>
	
</table>
</xsl:for-each>
</td>
</tr-->




<tr>
<td colspan="2">
	<hr/>
</td>
</tr>





<tr>

<td valign="top" align="center" width="50%">
	<table border="0" width="100%" cellpadding="5" cellspacing="0">
		<tr class="uportal-background-highlight">
			<td class="uportal-channel-table-caption">Utilisation des droits hrits</td>
		</tr>
		<xsl:choose>
		<xsl:when test="/ROOT/space_root/@value='false'">
		<tr>
			<td align="center" valign="center">
				<!--input type="checkbox" name="useInherited" value="true"/><text class="uportal-text">  Utilisation des droits hrits</text-->
				<table border="0">
				<tr>
				<td>
				<xsl:choose>
					<xsl:when test="/ROOT/useInherited/@value='true'">
						<input type="radio" name="useInherited" value="true" checked="true" onClick="javascript:changeInheritance();"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="radio" name="useInherited" value="true" onClick="javascript:changeInheritance();"/>
					</xsl:otherwise>
				</xsl:choose>	
				</td>
				<td class="uportal-channel-text">
				<text>  OUI</text>
				</td>
				</tr>
				<tr>
				<td>
				<xsl:choose>
					<xsl:when test="/ROOT/useInherited/@value='true'">
						<input type="radio" name="useInherited" value="false" onClick="javascript:changeInheritance();"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="radio" name="useInherited" value="false" checked="true" onClick="javascript:changeInheritance();"/>
					</xsl:otherwise>
				</xsl:choose>
				</td>
				<td class="uportal-channel-text">
				<text>  NON</text>
				</td>
				</tr>
				</table>
			</td>
		</tr>
		</xsl:when>
		<xsl:otherwise>
			<tr>
			<xsl:choose>
				<xsl:when test="/ROOT/useInherited/@value='true'">
					<td class="uportal-channel-text" align="center">
						<text>  OUI</text>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td class="uportal-channel-text" align="center">
						<text>  NON</text>
					</td>
				</xsl:otherwise>
			</xsl:choose>
			</tr>
		</xsl:otherwise>
		</xsl:choose>
	</table>
</td>

<td valign="top" align="center">

<xsl:if test="/ROOT/useInherited/@value='true'">
<xsl:for-each select="/ROOT/inherited">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-channel-table-caption">
		<td style="text-align: center; background-color: rgb(229, 229, 229); color: rgb(51, 51, 51);">Droits hrits</td>
	</tr>
		
	
	<tr valign="top">
		<td width="90%">				
			<table border="0" width="100%" cellpadding="2" cellspacing="5">
				<tr >
					<td>&#160;</td>
					
					<td style="background-color: rgb(185, 185, 185);" class="uportal-channel-table-header" nowrap="true" align="center" width="35%">
						<div style="text-align: left; color: rgb(51, 51, 51);"  >
							Nom
						</div>
					</td>
					
					<td style="background-color: rgb(185, 185, 185);" class="uportal-channel-table-header" nowrap="true" align="center" width="35%">
						<div style="text-align: left; color: rgb(51, 51, 51);"  >
							Source
						</div>
					</td>
					
					<td style="background-color: rgb(185, 185, 185);" class="uportal-channel-table-header" nowrap="true" align="center" width="10%">
						<div style="text-align: center; color: rgb(51, 51, 51);"  >
							Lecture
						</div>
					</td>		
					<td style="background-color: rgb(185, 185, 185);" class="uportal-channel-table-header" nowrap="true" align="center" width="10%">
						<div style="text-align: center; color: rgb(51, 51, 51);"  >
							Ecriture
						</div>
					</td>
					<td style="background-color: rgb(185, 185, 185);" class="uportal-channel-table-header" nowrap="true" align="center" width="10%">
						<div style="text-align: center; color: rgb(51, 51, 51);"  >
							Partage
						</div>
					</td>
							
				</tr>
				
				<xsl:apply-templates/>	
			
			</table>
			
			
		</td>
		
		
	</tr>
	
</table>
</xsl:for-each>
</xsl:if>

</td>
</tr>







</table>




</form>



</xsl:template>



<xsl:template match="user">
						<tr>
						<td class="uportal-channel-text" valign="center" align="left">
							<img src="media/org/esupportail/portal/channels/CStockage/user_gray_20px.gif" border="0" />
						</td>
						<td class="uportal-channel-text" valign="center" align="left" width="100%">
							<xsl:value-of select="./@name" />
						</td>
						<td class="uportal-crumbtrail" valign="center" align="left" width="100%">
							<xsl:value-of select="./@inheritedFrom" />
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@read='-1'">
									<img src="media/org/esupportail/portal/channels/CStockage/classic/deny_16px.gif" border="0" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@read='0'">
											-
										</xsl:when>
										<xsl:otherwise>
											<img src="media/org/esupportail/portal/channels/CStockage/classic/grant_16px.gif" border="0" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@write='-1'">
									<img src="media/org/esupportail/portal/channels/CStockage/classic/deny_16px.gif" border="0" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@write='0'">
											-
										</xsl:when>
										<xsl:otherwise>
											<img src="media/org/esupportail/portal/channels/CStockage/classic/grant_16px.gif" border="0" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@manage='-1'">
									<img src="media/org/esupportail/portal/channels/CStockage/classic/deny_16px.gif" border="0" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@manage='0'">
											-
										</xsl:when>
										<xsl:otherwise>
											<img src="media/org/esupportail/portal/channels/CStockage/classic/grant_16px.gif" border="0" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
</xsl:template>

<xsl:template match="group">
						<tr>
						<td class="uportal-channel-text" valign="center" align="left">
							<img src="media/org/esupportail/portal/channels/CStockage/group_gray_20px.gif" border="0" />
						</td>
						<td class="uportal-channel-text" valign="center" align="left" width="100%">
							<xsl:value-of select="./@name" />
						</td>
						<td class="uportal-crumbtrail" valign="center" align="left" width="100%">
							<xsl:value-of select="./@inheritedFrom" />
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@read='-1'">
									<img src="media/org/esupportail/portal/channels/CStockage/classic/deny_16px.gif" border="0" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@read='0'">
											-
										</xsl:when>
										<xsl:otherwise>
											<img src="media/org/esupportail/portal/channels/CStockage/classic/grant_16px.gif" border="0" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@write='-1'">
									<img src="media/org/esupportail/portal/channels/CStockage/classic/deny_16px.gif" border="0" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@write='0'">
											-
										</xsl:when>
										<xsl:otherwise>
											<img src="media/org/esupportail/portal/channels/CStockage/classic/grant_16px.gif" border="0" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@manage='-1'">
									<img src="media/org/esupportail/portal/channels/CStockage/classic/deny_16px.gif" border="0" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@manage='0'">
											-
										</xsl:when>
										<xsl:otherwise>
											<img src="media/org/esupportail/portal/channels/CStockage/classic/grant_16px.gif" border="0" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
</xsl:template>

<xsl:template match="other">
						<tr>
						<td class="uportal-channel-text" valign="center" align="left">
							<img src="media/org/esupportail/portal/channels/CStockage/other_gray_20px.gif" border="0" />
						</td>
						<td class="uportal-channel-text" valign="center" align="left" width="100%">
							<xsl:value-of select="./@name" />
						</td>
						<td class="uportal-crumbtrail" valign="center" align="left" width="100%">
							<xsl:value-of select="./@inheritedFrom" />
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@read='-1'">
									<img src="media/org/esupportail/portal/channels/CStockage/classic/deny_16px.gif" border="0" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@read='0'">
											-
										</xsl:when>
										<xsl:otherwise>
											<img src="media/org/esupportail/portal/channels/CStockage/classic/grant_16px.gif" border="0" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@write='-1'">
									<img src="media/org/esupportail/portal/channels/CStockage/classic/deny_16px.gif" border="0" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@write='0'">
											-
										</xsl:when>
										<xsl:otherwise>
											<img src="media/org/esupportail/portal/channels/CStockage/classic/grant_16px.gif" border="0" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@manage='-1'">
									<img src="media/org/esupportail/portal/channels/CStockage/classic/deny_16px.gif" border="0" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@manage='0'">
											-
										</xsl:when>
										<xsl:otherwise>
											<img src="media/org/esupportail/portal/channels/CStockage/classic/grant_16px.gif" border="0" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
</xsl:template>


</xsl:stylesheet>