<?xml version='1.0' encoding='ISO-8859-1' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no"/>


<!--<xsl:variable name="baseActionURL"><xsl:value-of select="ROOT/baseActionURL" /></xsl:variable>-->
<xsl:param name="baseActionURL"/>
<xsl:param name="clipboardParameter" />


<xsl:template match="/">

<table border="1" cellspacing="0" cellpadding="0" width="90%" bordercolor="#002863" align="center">  
  <tr> 
    <td> 
    <form action="{$baseActionURL}" method="post">
    <input type="hidden" name="modeDav" value="paste_mode"/>
      <table width="100%" border="0" cellspacing="5" cellpadding="5">
		<xsl:choose>
	   		<xsl:when test="$clipboardParameter='copy_mode'">
    		  	<tr class="uportal-background-light"> 
        			<td class="uportal-channel-table-header" colspan="2">             						
			            <div align="center"><b>Confirmation de copie</b></div>
    		        </td>
		        </tr>
        		<tr> 
					<td colspan="2" class="uportal-text"> 
			            <div align="center">Etes-vous sr de vouloir copier les lments suivants :</div>			
		            </td>
        		</tr>
            </xsl:when>
 			<xsl:when test="$clipboardParameter='move_mode'">
 				<tr class="uportal-background-light"> 
        			<td class="uportal-channel-table-header" colspan="2">             						
			            <div align="center"><b>Confirmation de dplacement</b></div>
    		        </td>
		        </tr>				 	
				<tr> 
					<td colspan="2" class="uportal-text"> 
			            <div align="center">Etes-vous sr de vouloir dplacer les lments suivants :</div> 			    
					</td>
        		</tr>              
			</xsl:when>
		</xsl:choose>
       
        <xsl:if test = "count(/ROOT/DIR)>0">
	        <tr> 
	          <td width="50%" class="uportal-text"> 
	            <div align="right">Rpertoire(s) : </div>
	            <div align="center"></div>
	          </td>
	          <td width="50%" class="uportal-channel-strong">
	            
	            
	            <xsl:for-each select = "/ROOT/DIR">
	      				<xsl:value-of select="@name" />
	      				<xsl:if test = "@empty='false'"> (non vide)</xsl:if><br/>
	      		</xsl:for-each>
	      				
	            
	            </td>
	        </tr>
        </xsl:if>
        
        <xsl:if test = "count(/ROOT/FILE)>0">
	        <tr> 
	          <td width="50%" class="uportal-text"> 
	            <div align="right">Fichier(s) :</div>
	          </td>
	          <td width="50%" class="uportal-channel-strong">
	          		<xsl:for-each select = "/ROOT/FILE">
	      				<xsl:value-of select="@name" /><br/>
	      			</xsl:for-each>          
	          </td>
	        </tr>
        </xsl:if>
        
        
        <tr> 
          <td colspan="2"> 
            <div align="center"> 
              <input class="uportal-button" type="submit" name="Submit" value="Valider"/>
              <input class="uportal-button" type="submit" name="Cancel" value="Annuler"/>
            </div>
          </td>
        </tr>
       
      </table>
      </form>
      
    </td>
  </tr>
</table>
</xsl:template>
</xsl:stylesheet>