<?xml version='1.0' encoding='ISO-8859-1' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no"/>
<xsl:param name="baseActionURL"/>
<xsl:param name="mediaPath" />

<xsl:template match="/">




		<script language="javascript">
<![CDATA[



// action when we submit the form
function submitForm() {		
	document.formulaire.submit();	 	
}


// action when we valid
function valid() {		
	document.formulaire.adminAction.value = 'valid';
	submitForm();	
}




// action when we change the check box for public viewing
function changePublicReader() {
	if (document.formulaire.change_public.value == 'true') {
		document.formulaire.change_public.value = 'false';	
	}
	else {
		document.formulaire.change_public.value = 'true';	
	}
}
	

]]>
		</script>







<table border="0" width="100%" cellspacing="0" cellpadding="5">
	<tr class="uportal-background-light">				
		<td class="uportal-channel-table-header" nowrap="true">Administration de "<xsl:value-of select="/ROOT/space/@name"/>"</td>
		<td width="100%">&#160;</td>		
		<td align="center">
			<a class="uportal-navigation-channel" href="javascript:valid();">			
				<img src="media/org/esupportail/portal/channels/CStockage/valid_24px.gif" alt="Valider" border="0" />
				<br/>Valider
			</a>
		</td>
		<td align="center">
			<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=admin_space_mode&amp;adminAction=cancel&amp;uP_root=root">				
				<img src="media/org/esupportail/portal/channels/CStockage/cancel_24px.gif" alt="Annuler" border="0" />
				<br/>Annuler
			</a>
		</td>
	</tr>
</table>
<br/>









<form name="formulaire" action="{$baseActionURL}?modeDav=admin_space_mode&amp;uP_root=root" method="post">

<input type="hidden" name="adminAction" value=""/>

<table border="0" width="100%" cellpadding="5" cellspacing="0">

	<tr>
		<td valign="top" width="50%">
			<!-- TITLE -->
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-highlight">
					<td class="uportal-channel-table-caption" colspan="3">Titre</td>		
				</tr>
				
				<tr>		
					<td align="center" width="90%">
						<xsl:variable name = "titleValue" select = "/ROOT/title" />
						<input class="uportal-input-text" type="text" size="25" name="title" value="{$titleValue}"/>		
					</td>
				</tr>
			</table>
		</td>
		
		<td valign="top" width="50%">
			<!-- DESCRIPTION -->
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-highlight">
					<td class="uportal-channel-table-caption" colspan="3">Description</td>		
				</tr>
				
				<tr>
					<td width="20%">&#160;</td>		
					<td align="center" width="60%">			
						<textarea name="description" rows="3" cols="40" class="uportal-input-text"><xsl:value-of select="/ROOT/description"/></textarea>			
					</td>
					<td width="20%">&#160;</td>						
				</tr>	
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top">
			<!-- META METADATA -->
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-highlight">
					<td class="uportal-channel-table-caption" colspan="2">Mta-donnes  saisir par les utilisateurs</td>		
				</tr>
				
				<tr valign="top">
					<td width="100%" colspan="2" align="center">
						<SELECT NAME="metadataFile" SIZE="1">      			
							<xsl:for-each select="/ROOT/metadata/md">
								<xsl:choose>						
									<xsl:when test="@default='true'">
										<xsl:variable name="val"><xsl:value-of select="@name"/></xsl:variable>						
										<OPTION SELECTED="true" VALUE="{$val}"><xsl:value-of select="@label"/></OPTION>
									</xsl:when>
									<xsl:otherwise>
										<xsl:variable name="val"><xsl:value-of select="@name"/></xsl:variable>						
										<OPTION VALUE="{$val}"><xsl:value-of select="@label"/></OPTION>
									</xsl:otherwise>
								</xsl:choose>					
							</xsl:for-each>
						</SELECT>	
					</td>		
				</tr>
			</table>
		</td>
		
		<td valign="top">
			<!-- RENDER -->
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-highlight">
					<td class="uportal-channel-table-caption" colspan="2">Type de rendu des documents publis</td>		
				</tr>
				
				<tr valign="top">
					<td width="100%" colspan="2" align="center">
						
						<SELECT NAME="renderingType" SIZE="1">      			
							<xsl:for-each select="/ROOT/renderingType/render">
								<xsl:choose>						
									<xsl:when test="@default='true'">
										<xsl:variable name="val"><xsl:value-of select="@name"/></xsl:variable>						
										<OPTION SELECTED="true" VALUE="{$val}"><xsl:value-of select="@label"/></OPTION>
									</xsl:when>
									<xsl:otherwise>
										<xsl:variable name="val"><xsl:value-of select="@name"/></xsl:variable>						
										<OPTION VALUE="{$val}"><xsl:value-of select="@label"/></OPTION>
									</xsl:otherwise>
								</xsl:choose>					
							</xsl:for-each>
						</SELECT>	
				    	
					</td>		
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top">
			<!-- MANAGER -->
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-highlight">
					<td class="uportal-channel-table-caption" colspan="2">Gestionnaires</td>
				</tr>
					
				<tr valign="top">
					<td width="50%">
						<table border="0" width="100%" cellpadding="5" cellspacing="0">
							<tr class="uportal-background-med">
								<td>&#160;</td>
								<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Utilisateurs</td>
							</tr>
							
							<xsl:for-each select="/ROOT/manager/users/user">
							<tr>
								<td><input type="checkbox" name="manager_user_list" value="{@key}"/></td>
								<td><img src="media/org/esupportail/portal/channels/CStockage/user_20px.gif" border="0" /></td>
								<td class="uportal-channel-text" nowrap="true" align="left" width="100%"><xsl:value-of select="./@name" /></td>
							</tr>
							</xsl:for-each>
						</table>
						
							<input class="uportal-button" type="submit" value="Ajouter" name="add_manager_user" />
							<input class="uportal-button" type="submit" value="Supprimer" name="delete_manager_user" />
						<br/>
					</td>
					
					<td width="50%">
						<table border="0" width="100%" cellpadding="5" cellspacing="0">
							<tr class="uportal-background-med">
								<td>&#160;</td>
								<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Groupes</td>					
							</tr>
							
							<xsl:for-each select="/ROOT/manager/groups/group">
							<tr>
								<td><input type="checkbox" name="manager_group_list" value="{@key}"/></td>
								<td><img src="media/org/esupportail/portal/channels/CStockage/group_20px.gif" border="0" /></td>
								<td class="uportal-channel-text" nowrap="true" align="left" width="100%"><xsl:value-of select="./@name" /></td>
							</tr>
							</xsl:for-each>
						</table>
						
							<input class="uportal-button" type="submit" value="Ajouter" name="add_manager_group" />
							<input class="uportal-button" type="submit" value="Supprimer" name="delete_manager_group" />
						<br/>
					</td>
				</tr>
			</table>
		</td>
	
		<td valign="top">
			<!-- WRITERS -->
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-highlight">
					<td class="uportal-channel-table-caption" colspan="2">Rdacteurs</td>		
				</tr>
					
				<tr valign="top">
					<td width="50%">
						<table border="0" width="100%" cellpadding="5" cellspacing="0">
							<tr class="uportal-background-med">
								<td>&#160;</td>
								<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Utilisateurs</td>
							</tr>
							
							<xsl:for-each select="/ROOT/writer/users/user">
							<tr>
								<td><input type="checkbox" name="writer_user_list" value="{@key}"/></td>
								<td><img src="media/org/esupportail/portal/channels/CStockage/user_20px.gif" border="0" /></td>
								<td class="uportal-channel-text" nowrap="true" align="left" width="100%"><xsl:value-of select="./@name" /></td>
							</tr>
							</xsl:for-each>
						</table>
									
							<input class="uportal-button" type="submit" value="Ajouter" name="add_writer_user" />
							<input class="uportal-button" type="submit" value="Supprimer" name="delete_writer_user" />
						<br/>
					</td>
					
					<td width="50%">
						<table border="0" width="100%" cellpadding="5" cellspacing="0">
							<tr class="uportal-background-med">
								<td>&#160;</td>
								<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Groupes</td>					
							</tr>
							
							<xsl:for-each select="/ROOT/writer/groups/group">
							<tr>
								<td><input type="checkbox" name="writer_group_list" value="{@key}"/></td>
								<td><img src="media/org/esupportail/portal/channels/CStockage/group_20px.gif" border="0" /></td>
								<td class="uportal-channel-text" nowrap="true" align="left" width="100%"><xsl:value-of select="./@name" /></td>
							</tr>
							</xsl:for-each>					
						</table>
									
							<input class="uportal-button" type="submit" value="Ajouter" name="add_writer_group" />
							<input class="uportal-button" type="submit" value="Supprimer" name="delete_writer_group" />
						<br/>
					</td>
				</tr>
			</table>
		</td>
	</tr>



	<tr>
		<td valign="top">
			<!-- EDITORS -->
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-highlight">
					<td class="uportal-channel-table-caption" colspan="2">Editeurs</td>
				</tr>
					
				<tr valign="top">		
					<td width="50%">
						<table border="0" width="100%" cellpadding="5" cellspacing="0">
							<tr class="uportal-background-med">
								<td>&#160;</td>
								<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Utilisateurs</td>
							</tr>
							
							<xsl:for-each select="/ROOT/editor/users/user">
							<tr>
								<td><input type="checkbox" name="editor_user_list" value="{@key}"/></td>
								<td><img src="media/org/esupportail/portal/channels/CStockage/user_20px.gif" border="0" /></td>
								<td class="uportal-channel-text" nowrap="true" align="left" width="100%"><xsl:value-of select="./@name" /></td>
							</tr>
							</xsl:for-each>
						</table>
									
							<input class="uportal-button" type="submit" value="Ajouter" name="add_editor_user" />
							<input class="uportal-button" type="submit" value="Supprimer" name="delete_editor_user" />
						<br/>
					</td>
					
					<td width="50%">
						<table border="0" width="100%" cellpadding="5" cellspacing="0">
							<tr class="uportal-background-med">
								<td>&#160;</td>
								<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Groupes</td>					
							</tr>
							
							<xsl:for-each select="/ROOT/editor/groups/group">
							<tr>
								<td><input type="checkbox" name="editor_group_list" value="{@key}"/></td>
								<td><img src="media/org/esupportail/portal/channels/CStockage/group_20px.gif" border="0" /></td>
								<td class="uportal-channel-text" nowrap="true" align="left" width="100%"><xsl:value-of select="./@name" /></td>
							</tr>
							</xsl:for-each>
						</table>				
						
							<input class="uportal-button" type="submit" value="Ajouter" name="add_editor_group" />
							<input class="uportal-button" type="submit" value="Supprimer" name="delete_editor_group" />
						<br/>
					</td>
				</tr>
			</table>
		</td>
	
		<td valign="top">
			<!-- READER -->
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-highlight">		
					<td class="uportal-channel-table-caption" colspan="4">Lecteurs</td>		
				</tr>
				
				<tr>		
					<td class="uportal-channel-table-caption" width="30%">&#160;</td>
					<td class="uportal-channel-table-caption" width="40%" colspan="2" align="center">
						
						<table border="0" width="100%" cellpadding="0" cellspacing="0">
							
							<input type="hidden" name="change_public" value="false"/>
				
							<tr class="uportal-background-med">
								<td width="50%">&#160;</td>
								<td class="uportal-channel-table-header">
									<xsl:choose>
										<xsl:when test="/ROOT/reader/@public!='true'">
											<input type="checkbox" name="public_reading" value="{/ROOT/reader/@public}" onChange="changePublicReader()"/>
										</xsl:when>
										<xsl:otherwise>
				 							<input type="checkbox" checked="true" name="public_reading" value="{/ROOT/reader/@public}" onChange="changePublicReader()"/>
										</xsl:otherwise>
									</xsl:choose>						
								</td>
								<td class="uportal-channel-table-header" nowrap="true" align="center" >Public</td>
								<td width="50%">&#160;</td>
							</tr>
						</table>
						
					</td>
					<td class="uportal-channel-table-caption" width="30%">&#160;</td>		
				</tr>
					
				
				<tr valign="top">
					<td width="50%" colspan="2">
						
						<table border="0" width="100%" cellpadding="5" cellspacing="0">
							<tr class="uportal-background-med">
								<td>&#160;</td>
								<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Utilisateurs</td>
							</tr>
							
							<xsl:for-each select="/ROOT/reader/users/user">
							<tr>
								<xsl:choose>
									<xsl:when test="@modifiable='false'">
										<td><input type="checkbox" name="reader_user_list" value="{@key}" disabled="true"/></td>
										<td><img src="media/org/esupportail/portal/channels/CStockage/user_gray_20px.gif" border="0" /></td>
										<td class="uportal-crumbtrail" nowrap="true" align="left" width="100%">
											<xsl:value-of select="./@name" />
											<xsl:if test="@inherited='true'">
												<text class="uportal-crumbtrail">
													&#160;(propos par dfaut)
												</text>
											</xsl:if>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td><input type="checkbox" name="reader_user_list" value="{@key}"/></td>
										<td><img src="media/org/esupportail/portal/channels/CStockage/user_20px.gif" border="0" /></td>
										<td class="uportal-channel-text" nowrap="true" align="left" width="100%">
											<xsl:value-of select="./@name" />
											<xsl:if test="@inherited='true'">
												<text class="uportal-crumbtrail">
													&#160;(propos par dfaut)
												</text>
											</xsl:if>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</tr>
							</xsl:for-each>
						</table>
						
						
							<input class="uportal-button" type="submit" value="Ajouter" name="add_reader_user" />
							<input class="uportal-button" type="submit" value="Supprimer" name="delete_reader_user" />
						
						<br/>
					</td>
					
					<td width="50%" colspan="2">
									
						<table border="0" width="100%" cellpadding="5" cellspacing="0">
							<tr class="uportal-background-med">
								<td>&#160;</td>
								<td class="uportal-channel-table-header" nowrap="true" colspan="2" align="left" width="100%">Groupes</td>					
							</tr>
							
							<xsl:for-each select="/ROOT/reader/groups/group">
							<tr>
								<td>
									<xsl:choose>
										<xsl:when test="@modifiable='false'">
											<input type="checkbox" name="reader_group_list" value="{@key}" disabled="true"/>
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox" name="reader_group_list" value="{@key}"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td><img src="media/org/esupportail/portal/channels/CStockage/group_20px.gif" border="0" /></td>
								<td class="uportal-channel-text" nowrap="true" align="left" width="100%">
									<xsl:value-of select="./@name" />
									<xsl:if test="@inherited='true'">
										<text class="uportal-crumbtrail">
											&#160;(propos par dfaut)
										</text>
									</xsl:if>
								</td>
							</tr>
							</xsl:for-each>
							<xsl:for-each select="./others/other">
							<tr>
								<td>
									<input type="checkbox" name="reader_other_list" value="{@key}" disabled="true"/>
								</td>
								<td><img src="media/org/esupportail/portal/channels/CStockage/other_gray_20px.gif" border="0" /></td>
								<td class="uportal-crumbtrail" nowrap="true" align="left" width="100%">
									<xsl:value-of select="./@name" />
									<xsl:if test="@inherited='true'">
										<text class="uportal-crumbtrail">
											&#160;(propos par dfaut)
										</text>
									</xsl:if>
								</td>
							</tr>
							</xsl:for-each>
						</table>
						
							<input class="uportal-button" type="submit" value="Ajouter" name="add_reader_group" />
							<input class="uportal-button" type="submit" value="Supprimer" name="delete_reader_group" />
						<br/>
					</td>
				</tr>
				
			</table>
		</td>
	</tr>



</table>




</form>




</xsl:template>





<!-- xsl:template match="group">
	<tr>
		<td><input type="checkbox" name="groupsList" value="{@key}"/></td>
		<td><img src="media/org/esupportail/portal/channels/CStockage/group_20px.gif" border="0" /></td>
		<td class="uportal-channel-text" nowrap="true" align="left" width="100%"><xsl:value-of select="./@name" /></td>
	</tr>
</xsl:template>




<xsl:template match="user">
	<tr>
		<td><input type="checkbox" name="usersList" value="{@key}"/></td>
		<td><img src="media/org/esupportail/portal/channels/CStockage/user_20px.gif" border="0" /></td>
		<td class="uportal-channel-text" nowrap="true" align="left" width="100%"><xsl:value-of select="./@name" /></td>
	</tr>
</xsl:template -->

</xsl:stylesheet>