/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdori.sql;

import com.sun.jdori.Connector;
import com.sun.jdori.FieldManager;
import com.sun.jdori.PersistenceManagerInternal;
import com.sun.jdori.StateManagerInternal;
import com.sun.jdori.StoreManager;
import com.sun.jdori.common.query.BasicQueryResult;
import com.sun.jdori.model.jdo.JDOClass;
import com.sun.jdori.query.QueryResult;
import com.sun.jdori.query.QueryResultHelper;
import java.util.BitSet;
import java.util.Iterator;
import javax.jdo.Extent;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.PersistenceCapable;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.util.ObjectModificationDefaultImpl;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.jdori.sql.Helper;
import org.apache.ojb.jdori.sql.OjbExtent;
import org.apache.ojb.jdori.sql.OjbFieldManager;
import org.apache.ojb.jdori.sql.OjbStoreConnector;
import org.apache.ojb.jdori.sql.OjbStoreFatalInternalException;
import org.apache.ojb.jdori.sql.OjbStorePMF;

class OjbStoreManager
implements StoreManager {
    private final OjbStorePMF pmf;
    private final OjbStoreConnector connector;
    private boolean optimistic;
    private Logger logger = LoggerFactory.getLogger("JDO");

    OjbStoreManager(OjbStorePMF pmf) {
        this.pmf = pmf;
        this.connector = new OjbStoreConnector(pmf);
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Connector getConnector(String userid, String password) {
        throw new JDOUserException("Not implemented");
    }

    public synchronized int insert(BitSet loadedFields, BitSet dirtyFields, StateManagerInternal sm) {
        try {
            this.logger.debug("OjbStoreManager.insert");
            PersistenceBroker broker = this.connector.getBroker();
            PersistenceCapable instance = sm.getObject();
            broker.store(instance, ObjectModificationDefaultImpl.INSERT);
        }
        catch (Exception ex) {
            throw new OjbStoreFatalInternalException(this.getClass(), "insert", ex);
        }
        dirtyFields.xor(dirtyFields);
        return 1;
    }

    public synchronized int update(BitSet loadedFields, BitSet dirtyFields, StateManagerInternal sm) {
        try {
            this.logger.debug("OjbStoreManager.update");
            PersistenceBroker broker = this.connector.getBroker();
            this.fetch(sm, null);
            PersistenceCapable instance = sm.getObject();
            broker.store(instance, ObjectModificationDefaultImpl.UPDATE);
        }
        catch (Exception ex) {
            throw new OjbStoreFatalInternalException(this.getClass(), "update", ex);
        }
        dirtyFields.xor(dirtyFields);
        return 1;
    }

    public synchronized int verifyFields(BitSet ignoredFields, BitSet fieldsToVerify, StateManagerInternal sm) {
        fieldsToVerify.xor(fieldsToVerify);
        return 1;
    }

    public synchronized int delete(BitSet loadedFields, BitSet dirtyFields, StateManagerInternal sm) {
        Identity oid = (Identity)sm.getInternalObjectId();
        this.logger.debug("OjbStoreManager.delete(" + oid + ")");
        try {
            this.fetch(sm, null);
            this.connector.getBroker().delete(sm.getObject());
        }
        catch (Exception ex) {
            throw new OjbStoreFatalInternalException(this.getClass(), "delete", ex);
        }
        dirtyFields.xor(dirtyFields);
        return 1;
    }

    public synchronized void fetch(StateManagerInternal sm, int[] fieldNums) {
        PersistenceBroker broker = this.connector.getBroker();
        try {
            PersistenceCapable instance = sm.getObject();
            Identity oid = (Identity)sm.getInternalObjectId();
            if (oid == null) {
                oid = new Identity(instance, broker);
            }
            broker.removeFromCache(instance);
            PersistenceCapable pc = (PersistenceCapable)broker.getObjectByIdentity(oid);
            JDOClass jdoClass = Helper.getJDOClass(pc.getClass());
            if (fieldNums == null) {
                fieldNums = jdoClass.getManagedFieldNumbers();
            }
            OjbFieldManager fm = new OjbFieldManager(pc, broker);
            sm.replaceFields(fieldNums, (FieldManager)fm);
            this.getConnector().flush();
        }
        catch (Exception ex) {
            throw new OjbStoreFatalInternalException(this.getClass(), "fetch", ex);
        }
    }

    public synchronized Extent getExtent(Class pcClass, boolean subclasses, PersistenceManagerInternal pm) {
        PersistenceBroker broker = this.connector.getBroker();
        return new OjbExtent(pcClass, broker, pm);
    }

    public synchronized Object createObjectId(StateManagerInternal sm, PersistenceManagerInternal pm) {
        PersistenceCapable obj = sm.getObject();
        Identity oid = new Identity(obj, this.connector.getBroker());
        return oid;
    }

    public synchronized Object createInternalObjectId(StateManagerInternal sm, PersistenceCapable pc, Object oid, Class cls, PersistenceManagerInternal pm) {
        return new Identity(pc, this.connector.getBroker());
    }

    public synchronized Object getExternalObjectId(Object objectId, PersistenceCapable pc) {
        return new Identity(pc, this.connector.getBroker());
    }

    public void copyKeyFieldsFromObjectId(StateManagerInternal sm, Class pcClass) {
        new Identity(sm.getObject(), this.connector.getBroker());
    }

    public boolean hasActualPCClass(Object objectId) {
        boolean rc = true;
        return rc;
    }

    public synchronized Object getInternalObjectId(Object objectId, PersistenceManagerInternal pm) {
        return objectId;
    }

    public synchronized Class getPCClassForOid(Object objectId, PersistenceManagerInternal pm) {
        return ((Identity)objectId).getObjectsTopLevelClass();
    }

    public Object newObjectIdInstance(Class pcClass, String str) {
        return Identity.fromByteArray(str.getBytes());
    }

    public void flush(Iterator it, PersistenceManagerInternal pm) {
        this.optimistic = pm.currentTransaction().getOptimistic();
        boolean err = false;
        while (it.hasNext()) {
            StateManagerInternal sm = (StateManagerInternal)it.next();
            this.logger.debug("OjbStoreManager.flush: " + sm.getInternalObjectId() + ", " + Helper.getLCState(sm));
            sm.preStore();
            sm.replaceSCOFields();
            sm.flush((StoreManager)this);
            if (sm.isFlushed()) continue;
            err = true;
            break;
        }
        this.logger.debug("OjbStoreManager.flush: end, err=" + err);
        if (err) {
            throw new JDOFatalInternalException("Error in flush");
        }
    }

    public QueryResult newQueryResult(QueryResultHelper queryResultHelper) {
        return new BasicQueryResult(queryResultHelper);
    }
}

