/*
 * Created on 18 oct. 06
 */
package org.esupportail.portal.channels.CStockage.channelAction.groupManager;

import java.util.TreeSet;

/**
 * Id: GroupTreeEntry.java,v 1.0 18 oct. 06
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: GroupTreeEntry
 * Original Author: Yohan Colmant
 * 
 */
public class GroupTreeEntry implements Comparable {

	/**
	 * the id of this entry in the tree
	 */
	private String id;
	

	/**
	 * The name of the group
	 */
	private String name;
	
	/**
	 * The key of the group
	 */
	private String key;
	
	/**
	 * The display name of the group
	 */
	private String displayName;
	
	/**
	 * The path of this entry
	 */
	private String path;
	
	/**
	 * The children of the group
	 */
	private TreeSet children;
	
	
	
	
	/**
	 * Constructor
	 * @param name the name of the group
	 * @param displayName the display name of the group
	 */
	protected GroupTreeEntry(String name, String displayName, String id, String path, String key) {
		this.name = name;
		this.displayName = displayName;
		this.id = id;
		this.path = path;
		this.key = key;
	}


	/**
	 * Add an entry child
	 * @param entry the child to add
	 */
	protected void addChild(GroupTreeEntry entry) {
		this.children.add(entry);
	}
	
	/**
	 * init the children
	 * @param entry the child to add
	 */
	public void initChildren() {
		this.children = new TreeSet();
	}
	
	/**
	 * @return true if children are initialized
	 */
	public boolean isChildrenInitialized() {
		return children!=null;
	}

	/**
	 * @return the children
	 */
	public TreeSet getChildren() {
		return children;
	}


	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	
	/**
	 * @return the displayName
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @return the key
	 */
	public String getKey() {
		return key;
	}


	/**
	 * @return the key
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the path
	 */
	public String getPath() {
		return path;
	}


	/**
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object arg0) {
		
		GroupTreeEntry gte = (GroupTreeEntry)arg0;
		if (this.id.equals(gte.id))
			return 0;
		
		int comp = this.displayName.compareTo(gte.displayName);
		if (comp!=0)
			return comp;
		else return 1;
	}
	
	
	
	public String toString() {
		return "name="+name+
		", displayName="+displayName+
		", id="+id+
		", path="+path+
		", key="+key;
	}
	
}
