<?xml version='1.0' encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no" />
<xsl:param name="baseActionURL"/>

<xsl:template match="/ROOT">

	
	<script language="javascript">
		<![CDATA[


		
		function setPointer(theRow, theAction, thePointerStyle, theDefaultStyle) {
		    if (typeof(theRow.className) == 'undefined') {
				return false;
		    }

		    var newStyle = null;

			if(theAction == 'over') {
				newStyle = thePointerStyle;
			}
			if(theAction == 'out') {
				newStyle = theDefaultStyle;
			}

		    if (newStyle) {
		       theRow.className = newStyle;
			}
		    else {
				return false;
		    }
		    return true;
		}


		]]>
	</script>
	
		

<form name="form" action="{$baseActionURL}?modeDav=manage_shared_spaces" method="post">
	
	<input type="hidden" name="actionForm" value=""/>
	
	<input type="hidden" name="add" value=""/>
	<input type="hidden" name="delete" value=""/>
	

	<table border="0" width="100%" cellspacing="0" cellpadding="5">
		<tr class="uportal-background-light">				
			<td class="uportal-channel-table-header" nowrap="true">Gestion de mes espaces</td>
			<td width="100%">&#160;</td>		
			<td align="center">
				<a class="uportal-navigation-channel" href="javascript:document.form.actionForm.value='valid';document.form.submit();">
					<img src="media/org/esupportail/portal/channels/CStockage/valid_24px.gif" alt="Valider" border="0" />
					<br/>Valider
				</a>
			</td>
			<td align="center">
				<a class="uportal-navigation-channel" href="javascript:document.form.actionForm.value='cancel';document.form.submit();">				
					<img src="media/org/esupportail/portal/channels/CStockage/cancel_24px.gif" alt="Annuler" border="0" />
					<br/>Annuler
				</a>
			</td>
		</tr>
	</table>
	<br/>
	
	
	
	
	<table width="100%" border="0" cellspacing="2" cellpadding="1">
			
			<!-- Title line -->
			<tr class="uportal-background-med"> 
			
				<td width="1" class="uportal-channel-table-header" align="center">
						<nobr><span>&#160;Chemin d'accs&#160;</span></nobr>		
				</td>
				
				<td width="1" class="uportal-channel-table-header" align="center">
						<nobr><span>&#160;De la part de&#160;</span></nobr>		
				</td>
				
				<td width="1" class="uportal-channel-table-header" align="center">
						<nobr><span>&#160;Etat&#160;</span></nobr>		
				</td>
				
				<td width="1" class="uportal-channel-table-header" align="center">
						<nobr><span>&#160;Libell&#160;</span></nobr>
				</td>
				
			</tr>
			
			
			<xsl:for-each select="spaces">
				
				<xsl:if test="@label!='' or count(/ROOT/spaces)>1">
					<tr> 
				
						<td colspan="4" class="uportal-channel-strong" align="left">
							<xsl:if test="count(/ROOT/spaces)>1">
								<br/>
							</xsl:if>
							<xsl:if test="@label!=''">
								<nobr><span><xsl:value-of select="@label"/></span></nobr>
							</xsl:if>
						</td>
						
					</tr>
				</xsl:if>
				
				<!-- Resource line -->
				<xsl:apply-templates select="space"/>
				
			
			</xsl:for-each>
	</table>
	
</form>

</xsl:template>








<xsl:template match="space">
	
	<xsl:choose>
		<xsl:when test="@used='true'">
			<tr bgColor="#CBFFBC" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');" onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');"> 
				<xsl:call-template name="trspace">
				</xsl:call-template>
			</tr>
		</xsl:when>
		<xsl:otherwise>
			<tr bgColor="#F8F8F8" onmouseout="setPointer(this, 'out', 'uportal-background-highlight', 'BODY');" onmouseover="setPointer(this, 'over', 'uportal-background-highlight', 'BODY');"> 
				<xsl:call-template name="trspace">
				</xsl:call-template>
			</tr>
		</xsl:otherwise>
	</xsl:choose>
	
	
	
	<xsl:apply-templates select="space"/>

</xsl:template>



<xsl:template name="dot">
	<xsl:param name="size" select="10"/>
	<xsl:param name="index" select="0"/>
	
	<xsl:if test="$size > $index">
		<td background="media/org/esupportail/portal/channels/CStockage/group_manager_dot.gif">
			<img src="media/org/esupportail/portal/channels/CStockage/group_manager_transparent.gif" height="5" width="16"/>
		</td>
		
		<xsl:call-template name="dot">
			<xsl:with-param name="size" select="$size"/>
			<xsl:with-param name="index" select="$index + 1"/>
		</xsl:call-template>
	</xsl:if>
</xsl:template> 



<xsl:template name="trspace">
	
	<!-- The path -->
	<td align="left" class="uportal-text">					
		<table border="0" cellpadding="0" cellspacing="0" width="100%">
			<tr>
				<td>
					<img src="media/org/esupportail/portal/channels/CStockage/group_manager_transparent.gif" border="0" height="2" hspace="0" vspace="0" width="20"/>
				</td>
				<xsl:call-template name="dot">
    				<xsl:with-param name="size" select="@index"/>
  				</xsl:call-template>
				<td colspan="({@childs}+1)" width="100%" align="left" class="uportal-text">
					<nobr><xsl:value-of select="@displayName"/></nobr>
				</td>
			</tr>
		</table>
	</td>
	
	<!-- From -->
	<td align="left" class="uportal-text">					
		<xsl:choose>
			<xsl:when test="@from!='administrated_server'">
				<nobr><xsl:value-of select="@from"/></nobr>
			</xsl:when>
			<xsl:otherwise>
				Administrateur
			</xsl:otherwise>
		</xsl:choose>
			
	</td>
	
	<!-- State -->
	<td align="center">					
		<xsl:choose>
			<xsl:when test="@used='true'">
				<a class="uportal-navigation-channel" href="javascript:document.form.delete.value='{@key}';document.form.submit();">
					<img src="media/org/esupportail/portal/channels/CStockage/used_space_32px.gif" border="0" height="15" width="15"/>			
				</a>
			</xsl:when>
			<xsl:otherwise>
				<a class="uportal-navigation-channel" href="javascript:document.form.add.value='{@key}';document.form.submit();">
					<img src="media/org/esupportail/portal/channels/CStockage/available_space_32px.gif" border="0" height="15" width="15"/>			
				</a>
			</xsl:otherwise>
		</xsl:choose>
	</td>
	
	<!-- The label -->
	<td width="200px" align="left">					
		<xsl:if test="@used='true'">
			<input class="uportal-input-text" size="30" type="text" name="label_{@key}" value="{@label}"/>			
		</xsl:if>
	</td>

</xsl:template>



</xsl:stylesheet>