


import java.util.ArrayList;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * Id: Server.java,v 1.0 14 avril 2005<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: Server<br/>
 * Original Author: Yohan Colmant<br/>
 * This represents a server in the configuration file<br/>
 */
public class OldServer {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(OldServer.class);
	



	/**
	 * CAS authentication
	 */
	private static final String AUTH_CAS = "cas";
	
	/**
	 * TRUSTED authentication
	 */
	private static final String AUTH_TRUSTED = "trusted";
	
	/**
	 * ASKED authentication
	 */
	private static final String AUTH_ASKED = "asked";
	
	
	/**
	 * The spaces list into this server
	 */
	private ArrayList spaces = new ArrayList();
	
	/**
	 * The name of the server
	 */
	private String name;
	
	/**
	 * The server id
	 */
	private String id;
	
	/**
	 * The server url
	 */
	private String url;
	
	/**
	 * The server type
	 */
	private String serverType;

	/**
	 * The authentication mode. "cas" or "trusted"
	 */
	private String authenticationMode;
	
	/**
	 * The login if trusted authentication
	 */
	private String login;

	/**
	 * The login if trusted authentication
	 */
	private String initialLoginFromTheConfigurationFile;
	
	/**
	 * If the login is from the configuration file
	 */
	private boolean loginIsFromConfigurationFile = false;
	
	
	/**
	 * The password if trusted authentication, or is asked authentication
	 */
	private String password;

	/**
	 * The ACL namespace
	 */
	private String aclNamespace;
	
	/**
	 * The user prefix for the ACL
	 */
	private String aclUserPrefix;
	
	/**
	 * The group prefix for the ACL
	 */
	private String aclGroupPrefix;

	/**
	 * The uPortal group node for the ACL
	 */
	private String aclUportalGroup;
	
	/**
	 * The group for the acl security
	 */
	private String aclSecurity;
	
	
	
	
	/**
	 * The cifs domain
	 */
	private String cifsDomain;
	
	/**
	 * The Cifs resolve order
	 */
	private String cifsResolveOrder;
	
	/**
	 * The cifs disable plain text password
	 */
	private String cifsDisablePlainTextPassword;
	
	/**
	 * The Cifs use unicode
	 */
	private String cifsUseUnicode;
	
	/**
	 * The Cifs encoding
	 */
	private String cifsEncoding;
	
	/**
	 * The NFS Uid Number
	 */
	public String nfsUidNumber;
	/**
	 * The NFS Gid Number
	 */
	private String nfsGidNumber;
	
	/**
	 * The URL to access the server in public mode
	 */
	private String unauthenticatedServerUrl;
	
	/**
	 * The URL to access the injac preview
	 */
	private String injacPreviewUrl;
	
	/**
	 * The URL to access final URL
	 */
	private String injacFinalUrl;
	
	

	/**
	 * The class name used to manage the actions
	 */
	private String serverAccessClass;

	

	
	
	
	
	/**
	 * @return Returns the spaces.
	 */
	public ArrayList getSpaces() {
		return spaces;
	}
	/**
	 * @param space The space to set.
	 */
	public void addSpace(OldSpace space) {
		spaces.add(space);
	}
	/*public void initSpaces() {
		spaces = null;
	}*/
	/**
	 * @param spaces The spaces to set.
	 */
	public void setSpaces(ArrayList spaces) {
		this.spaces = spaces;
	}
	
	
	
	

	/**
	 * @return Returns the aclSecurity.
	 */
	public String getAclSecurity() {
		
		if (aclSecurity==null) {
			if (log.isDebugEnabled()) {
				log.debug("getAclSecurity"+" :: getAclSecurity is null");
			}
		}
		return aclSecurity;
	}
	/**
	 * @param aclSecurity The aclSecurity to set.
	 */
	public void setAclSecurity(String aclSecurity) {
		this.aclSecurity = aclSecurity;
	}
	
	/**
	 * @return Returns the injacPreviewUrl.
	 */
	public String getInjacPreviewUrl() {
		return injacPreviewUrl;
	}
	/**
	 * @param injacPreviewUrl The injacPreviewUrl to set.
	 */
	public void setInjacPreviewUrl(String injacPreviewUrl) {
		this.injacPreviewUrl = injacPreviewUrl;
		if (this.injacPreviewUrl.endsWith("/")) {
			this.injacPreviewUrl = this.injacPreviewUrl.substring(0, this.injacPreviewUrl.length()-1);
		}
	}
	
	
	
	public String getInjacFinalUrl() {
		return injacFinalUrl;
	}
	public void setInjacFinalUrl(String injacFinalUrl) {
		this.injacFinalUrl = injacFinalUrl;
		if (this.injacFinalUrl.endsWith("/")) {
			this.injacFinalUrl = this.injacFinalUrl.substring(0, this.injacFinalUrl.length()-1);
		}
	}
	
	/**
	 * @return Returns the unauthenticatedServerUrl.
	 */
	public String getUnauthenticatedServerUrl() {
		return unauthenticatedServerUrl;
	}
	/**
	 * @param unauthenticatedServerUrl The unauthenticatedServerUrl to set.
	 */
	public void setUnauthenticatedServerUrl(String unauthenticatedServerUrl) {
		this.unauthenticatedServerUrl = unauthenticatedServerUrl;
		if (this.unauthenticatedServerUrl.endsWith("/")) {
			this.unauthenticatedServerUrl = this.unauthenticatedServerUrl.substring(0, this.unauthenticatedServerUrl.length()-1);
		}
	}
	
	
	/**
	 * @return Returns the manageAcl.
	 */
	public boolean managesAcl() {		
		boolean parametersSet = hasAclParameterSet() && manageAcl.equals("true");
		if (!parametersSet) {
			log.debug("managesAcl :: there is no acl access parameters set for space "+getId());
			return false;
		}
		return parametersSet;
	}
	
	
	
	String manageAcl = "true";
	
	public String getManageAcl() {		
		return managesAcl()+"";
	}
	
	public void setManageAcl(String manageAcl) {		
		this.manageAcl = manageAcl;
	}
	
	

	/**
	 * @return check if the server allow the personalization
	 */
	protected boolean allowsPersonalization() throws Exception {
		boolean managesAcl = managesAcl();
		if (!managesAcl) {
			log.debug("allowPersonalization :: there is no acl access parameters set for space "+getId());
			return false;
		}
		return managesAcl;
	}
	
	
	
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the cifsDisablePlainTextPassword.
	 */
	public String getCifsDisablePlainTextPassword() {
		return cifsDisablePlainTextPassword;
	}
	/**
	 * @param cifsDisablePlainTextPassword The cifsDisablePlainTextPassword to set.
	 */
	public void setCifsDisablePlainTextPassword(
			String cifsDisablePlainTextPassword) {
		this.cifsDisablePlainTextPassword = cifsDisablePlainTextPassword;
	}
	/**
	 * @return Returns the cifsDomain.
	 */
	public String getCifsDomain() {
		return cifsDomain;
	}
	
	
	
	
	/**
	 * @param cifsDomain The cifsDomain to set.
	 */
	public void setCifsDomain(String cifsDomain) {
		this.cifsDomain = cifsDomain;
	}
	/**
	 * @return Returns the cifsResolveOrder.
	 */
	public String getCifsResolveOrder() {
		return cifsResolveOrder;
	}
	/**
	 * @param cifsResolveOrder The cifsResolveOrder to set.
	 */
	public void setCifsResolveOrder(String cifsResolveOrder) {
		this.cifsResolveOrder = cifsResolveOrder;
	}
	
	/**
	 * @return Returns the cifsEncoding.
	 */
	public String getCifsEncoding() {
		return cifsEncoding;
	}
	/**
	 * @param cifsEncoding The cifsEncoding to set.
	 */
	public void setCifsEncoding(String cifsEncoding) {
		this.cifsEncoding = cifsEncoding;
	}
	/**
	 * @return Returns the cifsUseUnicode.
	 */
	public String getCifsUseUnicode() {
		return cifsUseUnicode;
	}
	/**
	 * @param cifsUseUnicode The cifsUseUnicode to set.
	 */
	public void setCifsUseUnicode(String cifsUseUnicode) {
		this.cifsUseUnicode = cifsUseUnicode;
	}
	/**
	 * @return Returns the serverType.
	 */
	public String getServerType() {
		return serverType;
	}
	/**
	 * @param serverType The serverType to set.
	 */
	public void setServerType(String serverType) {
		this.serverType = serverType;
	}
	/**
	 * @return Returns the aclUportalGroup.
	 */
	public String getAclUportalGroup() {
		return aclUportalGroup;
	}
	/**
	 * @param aclUportalGroup The aclUportalGroup to set.
	 */
	public void setAclUportalGroup(String aclUportalGroup) {
		this.aclUportalGroup = aclUportalGroup;
	}
	/**
	 * @return Returns the aclGroupPrefix.
	 */
	public String getAclGroupPrefix() {
		return aclGroupPrefix;
	}
	/**
	 * @param aclGroupPrefix The aclGroupPrefix to set.
	 */
	public void setAclGroupPrefix(String aclGroupPrefix) {
		this.aclGroupPrefix = aclGroupPrefix;
	}
	/**
	 * @return Returns the aclNamespace.
	 */
	public String getAclNamespace() {
		return aclNamespace;
	}
	/**
	 * @param aclNamespace The aclNamespace to set.
	 */
	public void setAclNamespace(String aclNamespace) {
		this.aclNamespace = aclNamespace;
	}
	/**
	 * @return Returns the supportAcl.
	 */
	public boolean hasAclParameterSet() {
		if (aclNamespace==null || aclUserPrefix == null || aclGroupPrefix == null || aclUportalGroup == null)
			return false;				
		else return true;			
	}
	
	/**
	 * @return Returns the aclUserPrefix.
	 */
	public String getAclUserPrefix() {
		return aclUserPrefix;
	}
	/**
	 * @param aclUserPrefix The aclUserPrefix to set.
	 */
	public void setAclUserPrefix(String aclUserPrefix) {
		this.aclUserPrefix = aclUserPrefix;
	}
	
	/**
	 * If the selected authentication is CAS
	 * @return trus is cas is selected
	 */
	public boolean isCasAuthentication() throws Exception {
		if (authenticationMode==null) {
			log.error("isCasAuthentication :: there is no authentication mode set for space "+getId());
			throw new Exception();
		}
		return authenticationMode.equals(AUTH_CAS);
	}
	/**
	 * If the selected authentication is TRUSTED
	 * @return true if trusted is selected
	 */
	public boolean isTrustedAuthentication() throws Exception {
		if (authenticationMode==null) {
			log.error("isTrustedAuthentication :: there is no authentication mode set for space "+getId());
			throw new Exception();
		}
		return authenticationMode.equals(AUTH_TRUSTED);
	}
	/**
	 * If the selected authentication is ASKED
	 * @return true if asked is selected
	 */
	public boolean isAskedAuthentication() throws Exception {
		if (authenticationMode==null) {
			log.error("isAskedAuthentication :: there is no authentication mode set for space "+getId());
			throw new Exception();
		}
		return authenticationMode.equals(AUTH_ASKED);
	}
	

	/**
	 * @return Returns the login.
	 */
	public String getLogin() {
		return login;
	}
	/**
	 * @param login The login to set.
	 */
	public void setLogin(String login) {
		this.login = login;
	}
	/**
	 * @param initialLoginFromTheConfigurationFile The login to set.
	 */
	public void setInitialLoginFromTheConfigurationFile(String initialLoginFromTheConfigurationFile) {
		this.login = initialLoginFromTheConfigurationFile;
		this.initialLoginFromTheConfigurationFile = new String(initialLoginFromTheConfigurationFile);
		this.loginIsFromConfigurationFile = true;
	}
	
	
	/**
	 * @return Returns the loginIsFromConfigurationFile.
	 */
	public boolean isLoginIsFromConfigurationFile() {
		return loginIsFromConfigurationFile;
	}
	
	/**
	 * @return Returns the initialLoginFromTheConfigurationFile.
	 */
	public String getInitialLoginFromTheConfigurationFile() {
		return initialLoginFromTheConfigurationFile;
	}
	/**
	 * @param loginIsFromConfigurationFile The loginIsFromConfigurationFile to set.
	 */
	/*public void setLoginIsFromConfigurationFile(
			boolean loginIsFromConfigurationFile) {
		this.loginIsFromConfigurationFile = loginIsFromConfigurationFile;
	}*/
	/**
	 * @return Returns the login used with this space.
	 */
	/*public String getUsedLogin() {
		if (trustedLogin!=null)
			return trustedLogin;
		else return usedLogin;
	}*/	
	/**
	 * @param usedLogin The usedLogin to set.
	 */
	/*public void setUsedLogin(String usedLogin) {
		this.usedLogin = usedLogin;
	}*/
	
	
	
	/**
	 * @return Returns the trustedLogin.
	 */
	/*public String getTrustedLogin() {
		return trustedLogin;
	}*/
	/**
	 * @param trustedLogin The trustedLogin to set.
	 */
	/*public void setTrustedLogin(String trustedLogin) {
		this.trustedLogin = trustedLogin;
	}*/
	
	
	
	/**
	 * @return Returns the password.
	 */
	public String getPassword() throws Exception {
		if (isTrustedAuthentication() && password==null) {
			log.error("getPassword :: there is no password set for trusted authentication for space "+getId());
			throw new Exception();
		}
		return password;
	}
	/**
	 * @param password The trustedPassword to set.
	 */
	public void setPassword(String password) {
		this.password = password;
	}
	/**
	 * @return Returns the url.
	 */
	public String getUrl() throws Exception {
		if (url==null) {
			log.error("getUrl :: there is no URL set for space "+getId());
			throw new Exception();
		}
		return url;
	}
	/**
	 * @param url The url to set.
	 */
	public void setUrl(String url) {
		this.url = url;
	}
	/**
	 * @param authenticationMode The authenticationMode to set.
	 */
	public void setAuthenticationMode(String authenticationMode) {
		this.authenticationMode = authenticationMode;
	}
	/**
	 * @return Returns the authenticationMode.
	 */
	public String getAuthenticationMode() {
		return authenticationMode;
	}
	
	/**
	 * @return Returns the serverAccessClass.
	 */
	public String getServerAccessClass() {
		return serverAccessClass;
	}
	/**
	 * @param serverAccessClass The serverAccessClass to set.
	 */
	public void setServerAccessClass(String serverAccessClass) {
		this.serverAccessClass = serverAccessClass;
	}
	
	
	
	
	/**
	 * @return Returns the id.
	 */
	public String getId() {
		return id;
	}
	
	/**
	 * @param id The id to set.
	 */
	public void setId(String id) {
		this.id = id;
	}
	
	
	
	
	
	
	
		

	/**
	 * @return Returns the nfsGidNumber.
	 */
	public String getNfsGidNumber() {
		return nfsGidNumber;
	}
	/**
	 * @param nfsGidNumber The nfsGidNumber to set.
	 */
	public void setNfsGidNumber(String nfsGidNumber) {
		this.nfsGidNumber = nfsGidNumber;
	}
	/**
	 * @return Returns the nfsUidNumber.
	 */
	public String getNfsUidNumber() {
		return nfsUidNumber;
	}
	/**
	 * @param nfsUidNumber The nfsUidNumber to set.
	 */
	public void setNfsUidNumber(String nfsUidNumber) {
		this.nfsUidNumber = nfsUidNumber;
	}
	
	

	
	
	
	/**
	 * Compare this to another object
	 * @param o object to compare
	 */
	public boolean equals(Object o) {
		
		OldServer server = (OldServer)o;
		
		if ( ( (server.url==null) && (server.url!=this.url) ) || ( (server.url!=null) && (!server.url.equals(this.url)) ) )
			return false;
		
		if ( ( (server.serverType==null) && (server.serverType!=this.serverType) ) || ( (server.serverType!=null) && (!server.serverType.equals(this.serverType)) ) )
			return false;
		
		if ( ( (server.serverAccessClass==null) && (server.serverAccessClass!=this.serverAccessClass) ) || ( (server.serverAccessClass!=null) && (!server.serverAccessClass.equals(this.serverAccessClass)) ) )
			return false;
		
		if ( ( (server.authenticationMode==null) && (server.authenticationMode!=this.authenticationMode) ) || ( (server.authenticationMode!=null) && (!server.authenticationMode.equals(this.authenticationMode)) ) )
			return false;
		
		if ( ( (server.login==null) && (server.login!=this.login) ) || ( (server.login!=null) && (!server.login.equals(this.login)) ) )
			return false;
		
		if (server.loginIsFromConfigurationFile != this.loginIsFromConfigurationFile)
			return false;
		
		if ( ( (server.initialLoginFromTheConfigurationFile==null) && (server.initialLoginFromTheConfigurationFile!=this.initialLoginFromTheConfigurationFile) ) || ( (server.initialLoginFromTheConfigurationFile!=null) && (!server.initialLoginFromTheConfigurationFile.equals(this.initialLoginFromTheConfigurationFile)) ) )
			return false;
		
		if ( ( (server.password==null) && (server.password!=this.password) ) || ( (server.password!=null) && (!server.password.equals(this.password)) ) )
			return false;
		
		if ( ( (server.aclNamespace==null) && (server.aclNamespace!=this.aclNamespace) ) || ( (server.aclNamespace!=null) && (!server.aclNamespace.equals(this.aclNamespace)) ) )
			return false;
		
		if ( ( (server.aclUserPrefix==null) && (server.aclUserPrefix!=this.aclUserPrefix) ) || ( (server.aclUserPrefix!=null) && (!server.aclUserPrefix.equals(this.aclUserPrefix)) ) )
			return false;
		
		if ( ( (server.aclGroupPrefix==null) && (server.aclGroupPrefix!=this.aclGroupPrefix) ) || ( (server.aclGroupPrefix!=null) && (!server.aclGroupPrefix.equals(this.aclGroupPrefix)) ) )
			return false;
		
		if ( ( (server.aclUportalGroup==null) && (server.aclUportalGroup!=this.aclUportalGroup) ) || ( (server.aclUportalGroup!=null) && (!server.aclUportalGroup.equals(this.aclUportalGroup)) ) )
			return false;
		
		if ( ( (server.cifsDomain==null) && (server.cifsDomain!=this.cifsDomain) ) || ( (server.cifsDomain!=null) && (!server.cifsDomain.equals(this.cifsDomain)) ) )
			return false;
		
		if ( ( (server.cifsResolveOrder==null) && (server.cifsResolveOrder!=this.cifsResolveOrder) ) || ( (server.cifsResolveOrder!=null) && (!server.cifsResolveOrder.equals(this.cifsResolveOrder)) ) )
			return false;
		
		if ( ( (server.cifsDisablePlainTextPassword==null) && (server.cifsDisablePlainTextPassword!=this.cifsDisablePlainTextPassword) ) || ( (server.cifsDisablePlainTextPassword!=null) && (!server.cifsDisablePlainTextPassword.equals(this.cifsDisablePlainTextPassword)) ) )
			return false;
		
		if ( ( (server.nfsUidNumber==null) && (server.nfsUidNumber!=this.nfsUidNumber) ) || ( (server.nfsUidNumber!=null) && (!server.nfsUidNumber.equals(this.nfsUidNumber)) ) )
			return false;
		
		if ( ( (server.nfsGidNumber==null) && (server.nfsGidNumber!=this.nfsGidNumber) ) || ( (server.nfsGidNumber!=null) && (!server.nfsGidNumber.equals(this.nfsGidNumber)) ) )
			return false;
		
		return true;
	}
	
	
	
	

	
	/**
	 * Return a String representation of this space
	 */
	public String toString() {
		return 
		"id: "+id+"\n"+
		"url: "+url;
	}
	
	
	
	
	/**
	 * Clone this object
	 * @return a clone of this object
	 */
	public Object clone() {
		OldServer server = new OldServer();
		
		if (spaces!=null) {
			ArrayList spacesClone = new ArrayList(spaces.size());
			for (int i=0; i<spaces.size(); i++) {
				OldSpace spaceClone = (OldSpace)((OldSpace)spaces.get(i)).cloneWithoutServer();
				spaceClone.setServer(server);
				spacesClone.add(spaceClone);
			}
			server.spaces = spacesClone;
		}
		
		
		server.name = this.name;
		
		server.id = this.id;
		server.url = this.url;
		server.unauthenticatedServerUrl = this.unauthenticatedServerUrl;
		server.injacPreviewUrl = this.injacPreviewUrl;
		server.injacFinalUrl = this.injacFinalUrl;
		server.serverType = this.serverType;
		server.serverAccessClass = this.serverAccessClass;
		server.authenticationMode = this.authenticationMode;
		server.login = this.login;
		server.loginIsFromConfigurationFile = this.loginIsFromConfigurationFile;
		server.initialLoginFromTheConfigurationFile = this.initialLoginFromTheConfigurationFile;
		server.password = this.password;
		
		server.aclNamespace = this.aclNamespace;
		server.aclUserPrefix = this.aclUserPrefix;
		server.aclGroupPrefix = this.aclGroupPrefix;
		server.aclUportalGroup = this.aclUportalGroup;
		server.aclSecurity = this.aclSecurity;
		
		server.cifsDomain = this.cifsDomain;
		server.cifsResolveOrder = this.cifsResolveOrder;
		server.cifsDisablePlainTextPassword = this.cifsDisablePlainTextPassword;
		server.cifsUseUnicode = this.cifsUseUnicode;
		server.cifsEncoding = this.cifsEncoding;
		
		server.nfsUidNumber = this.nfsUidNumber;
		server.nfsGidNumber = this.nfsGidNumber;
		
		return server;
	}
	
	
	

	/**
	 * Get the xml in the configuration file style
	 * @return the xml in the configuration file style
	 */
	public StringBuffer getLocalXmlBegin() {
		
		StringBuffer xmlServer = new StringBuffer();		
		xmlServer.append("<SERVER");
		
		// url
		try {
			String url = this.getUrl();
			if (url!=null && !url.trim().equals(""))
				xmlServer.append(" url=\""+url+"\"\n");
		}
		catch(Exception e) {
			if (log.isDebugEnabled())
				log.error("getXml :: " + e.toString());
		}

		// serverType
		String serverType = this.getServerType();
		if (serverType!=null && !serverType.trim().equals(""))
			xmlServer.append(" serverType=\""+serverType+"\"\n");

		// authenticationMode
		String authenticationMode = this.getAuthenticationMode();
		if (authenticationMode!=null && !authenticationMode.trim().equals(""))
			xmlServer.append(" authenticationMode=\""+authenticationMode+"\"\n");

		// login
		try {
			if (this.isTrustedAuthentication() || this.isAskedAuthentication()) {

				if (this.isLoginIsFromConfigurationFile()) {
					String login = this.getInitialLoginFromTheConfigurationFile();
					if (login!=null && !login.trim().equals(""))
						xmlServer.append(" login=\""+login+"\"\n");
				}
				
			}
		}
		catch(Exception e) {
			if (log.isDebugEnabled())
				log.error("getXml :: " + e.toString());
		}
		
		// password
		try {
			if (this.isTrustedAuthentication()) {
				try {				
					String trustedPassword = this.getPassword();
					if (trustedPassword!=null && !trustedPassword.trim().equals(""))
						xmlServer.append(" password=\""+trustedPassword+"\"\n");
				}
				catch(Exception e) {
					if (log.isDebugEnabled())
						log.error("getXml :: " + e.toString());
				}
			}
		}
		catch(Exception e) {
			if (log.isDebugEnabled())
				log.error("getXml :: " + e.toString());
		}
		
		xmlServer.append(" >\n");

		// aclNamespace
		String aclNamespace = this.getAclNamespace();
		if (aclNamespace!=null && !aclNamespace.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"aclNamespace\" value=\""+aclNamespace+"\"/>\n");

		// aclUserPrefix
		String aclUserPrefix = this.getAclUserPrefix();
		if (aclUserPrefix!=null && !aclUserPrefix.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"aclUserPrefix\" value=\""+aclUserPrefix+"\"/>\n");

		// aclGroupPrefix
		String aclGroupPrefix = this.getAclGroupPrefix();
		if (aclGroupPrefix!=null && !aclGroupPrefix.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"aclGroupPrefix\" value=\""+aclGroupPrefix+"\"/>\n");
		
		// aclUportalGroup
		String aclUportalGroup = this.getAclUportalGroup();
		if (aclUportalGroup!=null && !aclUportalGroup.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"aclUportalGroup\" value=\""+aclUportalGroup+"\"/>\n");

		// aclSecurityGroup
		String aclSecurity = this.getAclSecurity();
		if (aclSecurity!=null && !aclSecurity.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"aclSecurity\" value=\""+aclSecurity+"\"/>\n");
		
		// cifsDomain
		String cifsDomain = this.getCifsDomain();
		if (cifsDomain!=null && !cifsDomain.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"cifsDomain\" value=\""+cifsDomain+"\"/>\n");

		// cifsResolveOrder
		String cifsResolveOrder = this.getCifsResolveOrder();
		if (cifsResolveOrder!=null && !cifsResolveOrder.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"cifsResolveOrder\" value=\""+cifsResolveOrder+"\"/>\n");

		// cifsDisablePlainTextPassword
		String cifsDisablePlainTextPassword = this.getCifsDisablePlainTextPassword();
		if (cifsDisablePlainTextPassword!=null && !cifsDisablePlainTextPassword.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"cifsDisablePlainTextPassword\" value=\""+cifsDisablePlainTextPassword+"\"/>\n");

		// cifsEncoding
		String cifsEncoding = this.getCifsEncoding();
		if (cifsEncoding!=null && !cifsEncoding.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"cifsEncoding\" value=\""+cifsEncoding+"\"/>\n");

		// cifsUseUnicode
		String cifsUseUnicode = this.getCifsUseUnicode();
		if (cifsUseUnicode!=null && !cifsUseUnicode.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"cifsUseUnicode\" value=\""+cifsUseUnicode+"\"/>\n");
		
		// nfsUidNumber
		String nfsUidNumber = this.getNfsUidNumber();
		if (nfsUidNumber!=null && !nfsUidNumber.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"nfsUidNumber\" value=\""+nfsUidNumber+"\"/>\n");

		// nfsGidNumber
		String nfsGidNumber = this.getNfsGidNumber();
		if (nfsGidNumber!=null && !nfsGidNumber.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"nfsGidNumber\" value=\""+nfsGidNumber+"\"/>\n");

		// unauthenticatedServerUrl
		String unauthenticatedServerUrl = this.getUnauthenticatedServerUrl();
		if (unauthenticatedServerUrl!=null && !unauthenticatedServerUrl.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"unauthenticatedServerUrl\" value=\""+unauthenticatedServerUrl+"\"/>\n");

		// injacPreviewUrl
		String injacPreviewUrl = this.getInjacPreviewUrl();
		if (injacPreviewUrl!=null && !injacPreviewUrl.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"injacPreviewUrl\" value=\""+injacPreviewUrl+"\"/>\n");

		// injacFinalUrl
		String injacFinalUrl = this.getInjacFinalUrl();
		if (injacFinalUrl!=null && !injacFinalUrl.trim().equals(""))
			xmlServer.append(" <PARAMETER name=\"injacFinalUrl\" value=\""+injacFinalUrl+"\"/>\n");
		
		
		return xmlServer;
		
	}
	
	
	
	

	/**
	 * Get the xml in the configuration file style
	 * @return the xml in the configuration file style
	 */
	public StringBuffer getLocalXmlEnd() {
		return new StringBuffer("</SERVER>\n");
		
	}
	
	

	/**
	 * Get the xml in the configuration file style
	 * @return the xml in the configuration file style
	 */
	public String getXml() {
		
		StringBuffer xml = new StringBuffer();
		
		xml.append(getLocalXmlBegin());
		
		for (int i=0; i<this.spaces.size(); i++) {
			OldSpace s = (OldSpace)spaces.get(i);
			xml.append(s.getLocalXml());
		}
		
		xml.append(getLocalXmlEnd());
		
		return xml.toString();
	}
	
}
