/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class TorqueRepositoryGeneratorTask
extends Task {
    private String inputFile;
    private String outputFile;
    private String database;
    private Reference classpathRef = null;
    private Path classpath = null;
    private String indexTablespace = "";
    private boolean useNativeIncrement = true;

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setIndexTablespace(String indexTablespace) {
        this.indexTablespace = indexTablespace;
    }

    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    public void setUseNativeIncrement(String useNativeIncrement) {
        this.useNativeIncrement = "yes".equalsIgnoreCase(useNativeIncrement);
    }

    public String getUseNativeIncrement() {
        if (this.useNativeIncrement) {
            return "yes";
        }
        return "no";
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public Reference getClasspathRef() {
        return this.classpathRef;
    }

    public void setClasspathRef(Reference classpathRef) {
        this.classpathRef = classpathRef;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        Java javaTask = (Java)this.project.createTask("java");
        javaTask.createArg().setLine(this.inputFile + " " + this.outputFile + " " + this.database + " " + this.indexTablespace + " " + this.useNativeIncrement);
        javaTask.setFork(true);
        javaTask.setClassname("org.apache.ojb.broker.metadata.torque.TorqueRepositoryGenerator");
        if (this.classpathRef != null) {
            javaTask.setClasspathRef(this.classpathRef);
        }
        if (this.classpath != null) {
            javaTask.setClasspath(this.classpath);
        }
        javaTask.execute();
    }

    protected boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    protected void checkParameters() throws BuildException {
        StringBuffer errorMessageBuffer = new StringBuffer();
        if (this.isEmpty(this.database)) {
            errorMessageBuffer.append("Database property not set.\n");
        }
        if (this.isEmpty(this.inputFile)) {
            errorMessageBuffer.append("Input file property not set.\n");
        }
        if (this.isEmpty(this.outputFile)) {
            errorMessageBuffer.append("Output file property not set.\n");
        }
        if (errorMessageBuffer.toString().length() > 0) {
            throw new BuildException(errorMessageBuffer.toString());
        }
    }
}

