/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryByIdentity;
import org.apache.ojb.broker.query.QueryByMtoNCriteria;
import org.apache.ojb.broker.query.QueryBySQL;
import org.apache.ojb.broker.query.ReportQueryByCriteria;

public final class QueryFactory {
    private static DescriptorRepository getRepository() {
        return MetadataManager.getInstance().getRepository();
    }

    public static ReportQueryByCriteria newReportQuery(Class classToSearchFrom, String[] columns, Criteria criteria, boolean distinct) {
        criteria = QueryFactory.addCriteriaForOjbConcreteClasses(QueryFactory.getRepository().getDescriptorFor(classToSearchFrom), criteria);
        return new ReportQueryByCriteria(classToSearchFrom, columns, criteria, distinct);
    }

    public static ReportQueryByCriteria newReportQuery(Class classToSearchFrom, Criteria criteria, boolean distinct) {
        criteria = QueryFactory.addCriteriaForOjbConcreteClasses(QueryFactory.getRepository().getDescriptorFor(classToSearchFrom), criteria);
        return QueryFactory.newReportQuery(classToSearchFrom, null, criteria, distinct);
    }

    public static ReportQueryByCriteria newReportQuery(Class classToSearchFrom, Criteria criteria) {
        return QueryFactory.newReportQuery(classToSearchFrom, criteria, false);
    }

    public static QueryByCriteria newQuery(Class classToSearchFrom, Criteria criteria, boolean distinct) {
        criteria = QueryFactory.addCriteriaForOjbConcreteClasses(QueryFactory.getRepository().getDescriptorFor(classToSearchFrom), criteria);
        return new QueryByCriteria(classToSearchFrom, criteria, distinct);
    }

    public static QueryByCriteria newQuery(Class classToSearchFrom, Criteria criteria) {
        return QueryFactory.newQuery(classToSearchFrom, criteria, false);
    }

    public static QueryByIdentity newQuery(Object example_or_identity) {
        return QueryFactory.newQueryByIdentity(example_or_identity);
    }

    public static QueryByIdentity newQueryByIdentity(Object example_or_identity) {
        return new QueryByIdentity(example_or_identity);
    }

    public static QueryByCriteria newQueryByExample(Object example) {
        return new QueryByCriteria(example);
    }

    public static QueryByMtoNCriteria newQuery(Class classToSearchFrom, String indirectionTable, Criteria criteria, boolean distinct) {
        criteria = QueryFactory.addCriteriaForOjbConcreteClasses(QueryFactory.getRepository().getDescriptorFor(classToSearchFrom), criteria);
        return new QueryByMtoNCriteria(classToSearchFrom, indirectionTable, criteria, distinct);
    }

    public static QueryByCriteria newQuery(Class classToSearchFrom, String indirectionTable, Criteria criteria) {
        criteria = QueryFactory.addCriteriaForOjbConcreteClasses(QueryFactory.getRepository().getDescriptorFor(classToSearchFrom), criteria);
        return new QueryByMtoNCriteria(classToSearchFrom, indirectionTable, criteria);
    }

    public static QueryBySQL newQuery(Class classToSearchFrom, String anSqlStatement) {
        return new QueryBySQL(classToSearchFrom, anSqlStatement);
    }

    private static Collection getExtentClasses(ClassDescriptor cld) {
        FieldDescriptor fd = cld.getFieldDescriptorByName("ojbConcreteClass");
        HashSet<String> classes = new HashSet<String>();
        if (fd != null) {
            classes.add(cld.getClassOfObject().getName());
        }
        if (cld.isExtent()) {
            Vector extentClasses = cld.getExtentClasses();
            for (int i = 0; i < extentClasses.size(); ++i) {
                Class ec = (Class)extentClasses.get(i);
                ClassDescriptor extCld = cld.getRepository().getDescriptorFor(ec);
                classes.addAll(QueryFactory.getExtentClasses(extCld));
            }
        }
        return classes;
    }

    private static Criteria addCriteriaForOjbConcreteClasses(ClassDescriptor cld, Criteria crit) {
        Criteria concreteClassDiscriminator = null;
        Collection classes = QueryFactory.getExtentClasses(cld);
        if (!classes.isEmpty()) {
            concreteClassDiscriminator = new Criteria();
            if (classes.size() > 1) {
                concreteClassDiscriminator = new Criteria();
                concreteClassDiscriminator.addIn("ojbConcreteClass", classes);
            } else {
                concreteClassDiscriminator.addEqualTo("ojbConcreteClass", classes.toArray()[0]);
            }
        }
        if (concreteClassDiscriminator != null) {
            if (crit == null) {
                crit = new Criteria();
            }
            crit.addAndCriteria(concreteClassDiscriminator);
        }
        return crit;
    }
}

