/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class SequenceManagerMySQLImpl
implements SequenceManager {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$sequence$SequenceManagerMySQLImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerMySQLImpl = SequenceManagerMySQLImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerMySQLImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerMySQLImpl);
    protected PersistenceBroker broker;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerMySQLImpl;

    public SequenceManagerMySQLImpl(PersistenceBroker broker) {
        this.broker = broker;
    }

    private synchronized int getNextId(FieldDescriptor field) {
        return 0;
    }

    public int getUniqueId(FieldDescriptor field) {
        return this.getNextId(field);
    }

    protected String getUniqueString(FieldDescriptor field) {
        return Integer.toString(this.getUniqueId(field));
    }

    protected long getUniqueLong(FieldDescriptor field) {
        return this.getUniqueId(field);
    }

    protected Object getUniqueObject(FieldDescriptor field) {
        return null;
    }

    public void afterStore(JdbcAccess dbAccess, ClassDescriptor cld, Object obj) throws SequenceManagerException {
        FieldDescriptor fd;
        FieldDescriptor[] fldArr = cld.getAutoIncrementFields();
        FieldDescriptor fieldDescriptor = fd = fldArr.length > 0 ? fldArr[0] : null;
        if (fd != null) {
            ResultSetAndStatement rsStmt = null;
            try {
                rsStmt = dbAccess.executeSQL("SELECT LAST_INSERT_ID() as newid FROM " + cld.getFullTableName(), cld, false);
                int newid = 0;
                if (rsStmt.m_rs.next()) {
                    newid = rsStmt.m_rs.getInt("newid");
                }
                rsStmt.m_rs.close();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("After store - newid=" + newid);
                }
                PersistentField pf = fd.getPersistentField();
                pf.set(obj, new Integer(newid));
            }
            catch (PersistenceBrokerException e) {
                throw new SequenceManagerException((Throwable)((Object)e));
            }
            catch (SQLException e) {
                throw new SequenceManagerException(e);
            }
            finally {
                rsStmt.close();
            }
        }
    }

    public void setReferenceFKs(Object obj, ClassDescriptor cld) throws SequenceManagerException {
        Vector objectReferenceDescriptors = cld.getObjectReferenceDescriptors();
        Iterator i = objectReferenceDescriptors.iterator();
        while (i.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
            Object ref = rds.getPersistentField().get(obj);
            if (ref == null) continue;
            this.assertFkAssignment(obj, cld, ref, rds);
        }
    }

    private void assertFkAssignment(Object obj, ClassDescriptor cld, Object ref, ObjectReferenceDescriptor rds) {
        Class c = ProxyHelper.getRealClass(ref);
        ClassDescriptor refCld = this.broker.getDescriptorRepository().getDescriptorFor(c);
        ClassDescriptor objCld = cld;
        FieldDescriptor[] objFkFields = rds.getForeignKeyFieldDescriptors(objCld);
        if (objFkFields != null) {
            FieldDescriptor refFld = refCld.getAutoIncrementFields()[0];
            FieldDescriptor fld = null;
            for (int i = 0; i < objFkFields.length; ++i) {
                fld = objFkFields[i];
                fld.getPersistentField().set(obj, refFld.getPersistentField().get(ref));
            }
        }
    }

    public Object getUniqueValue(FieldDescriptor field) throws SequenceManagerException {
        Object[] result = null;
        switch (field.getJdbcType().getType()) {
            case 2003: {
                Object[] arr;
                result = arr = new Object[]{this.getUniqueString(field)};
                break;
            }
            case -5: {
                result = new Long(this.getUniqueLong(field));
                break;
            }
            case -2: {
                result = this.getUniqueString(field).getBytes();
                break;
            }
            case 1: {
                result = this.getUniqueString(field);
                break;
            }
            case 91: {
                result = new Date(this.getUniqueLong(field));
                break;
            }
            case 3: {
                result = new BigDecimal((double)this.getUniqueLong(field));
                break;
            }
            case 8: {
                result = new Double(this.getUniqueLong(field));
                break;
            }
            case 6: {
                result = new Double(this.getUniqueLong(field));
                break;
            }
            case 4: {
                result = new Integer(this.getUniqueId(field));
                break;
            }
            case 2000: {
                result = this.getUniqueObject(field);
                break;
            }
            case -4: {
                result = this.getUniqueString(field).getBytes();
                break;
            }
            case -1: {
                result = this.getUniqueString(field);
                break;
            }
            case 2: {
                result = new BigDecimal((double)this.getUniqueLong(field));
                break;
            }
            case 7: {
                result = new Float(this.getUniqueLong(field));
                break;
            }
            case 5: {
                result = new Short((short)this.getUniqueId(field));
                break;
            }
            case 92: {
                result = new Time(this.getUniqueLong(field));
                break;
            }
            case 93: {
                result = new Timestamp(this.getUniqueLong(field));
                break;
            }
            case -6: {
                result = new Byte((byte)this.getUniqueId(field));
                break;
            }
            case -3: {
                result = this.getUniqueString(field).getBytes();
                break;
            }
            case 12: {
                result = this.getUniqueString(field);
                break;
            }
            default: {
                result = this.getUniqueString(field);
            }
        }
        result = field.getFieldConversion().sqlToJava(result);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

