/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.portal.utils.webdav.acl;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.Privilege;
import org.esupportail.portal.utils.webdav.acl.EsupPermission;

public class EsupPermissions {
    protected static final Log log = LogFactory.getLog(EsupPermissions.class);
    private TreeSet permissions = new TreeSet();
    private String userPrefix;
    private String groupPrefix;
    private String securityGroup;

    public EsupPermissions() {
    }

    public EsupPermissions(String userPrefix, String groupPrefix, String securityGroup) {
        this(null, userPrefix, groupPrefix, securityGroup);
    }

    public EsupPermissions(Ace[] aces, String userPrefix, String groupPrefix, String securityGroup) {
        this.userPrefix = userPrefix;
        this.groupPrefix = groupPrefix;
        this.securityGroup = securityGroup;
        if (aces != null) {
            for (int i = 0; i < aces.length; ++i) {
                Ace ace = aces[i];
                boolean negative = ace.isNegative();
                String principal = ace.getPrincipal();
                boolean inherited = ace.isInherited();
                String inheritedFrom = ace.getInheritedFrom();
                boolean protectedPermission = ace.isProtected();
                Enumeration iter = ace.enumeratePrivileges();
                while (iter.hasMoreElements()) {
                    Privilege p = (Privilege)iter.nextElement();
                    String permissionType = p.getName();
                    EsupPermission perm = new EsupPermission(negative, principal, permissionType, inherited, inheritedFrom, protectedPermission, p.getNamespace(), userPrefix, groupPrefix, securityGroup);
                    this.add(perm);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"tools::webdav::acl --> Ace[] is null, can't read ACL");
        }
    }

    public EsupPermissions(Ace[] aces, String permissionType, String userPrefix, String groupPrefix, String securityGroup) {
        this.userPrefix = userPrefix;
        this.groupPrefix = groupPrefix;
        this.securityGroup = securityGroup;
        if (aces != null) {
            for (int i = 0; i < aces.length; ++i) {
                Ace ace = aces[i];
                boolean negative = ace.isNegative();
                String principal = ace.getPrincipal();
                boolean inherited = ace.isInherited();
                String inheritedFrom = ace.getInheritedFrom();
                boolean protectedPermission = ace.isProtected();
                Enumeration iter = ace.enumeratePrivileges();
                while (iter.hasMoreElements()) {
                    Privilege p = (Privilege)iter.nextElement();
                    String localPermissionType = p.getName();
                    if (!localPermissionType.equals(permissionType)) continue;
                    EsupPermission perm = new EsupPermission(negative, principal, permissionType, inherited, inheritedFrom, protectedPermission, p.getNamespace(), userPrefix, groupPrefix, securityGroup);
                    this.add(perm);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"tools::webdav::acl --> Ace[] is null, can't read ACL");
        }
    }

    public void clone(EsupPermissions perms) {
        this.groupPrefix = perms.groupPrefix;
        this.userPrefix = perms.userPrefix;
        this.permissions = perms.permissions;
    }

    public Ace[] getSortedAceArray() {
        Vector<Ace> v = new Vector<Ace>();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            EsupPermission perm = (EsupPermission)iter.next();
            if (perm.isInherited() || perm.isProtectedPermission()) continue;
            Ace ace = new Ace(perm.getPrincipal(), !perm.isGrantPermission(), perm.isProtectedPermission(), perm.isInherited(), perm.getInheritedFrom());
            ace.addPrivilege(new Privilege(perm.getNamespace(), perm.getPermissionType(), null));
            v.addElement(ace);
        }
        Ace[] aces = new Ace[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            aces[i] = (Ace)v.elementAt(i);
        }
        return aces;
    }

    public boolean add(EsupPermission perm) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"tools::webdav::acl --> new permission added");
        }
        return this.permissions.add(perm);
    }

    public Vector contains(EsupPermission perm) {
        Vector<EsupPermission> perms = new Vector<EsupPermission>();
        for (EsupPermission iterPerm : this.permissions) {
            if (!iterPerm.equals(perm)) continue;
            perms.add(iterPerm);
        }
        if (perms.size() == 0) {
            return null;
        }
        return perms;
    }

    public boolean isEmpty() {
        return this.permissions.isEmpty();
    }

    public Iterator iterator() {
        return this.permissions.iterator();
    }

    public boolean remove(boolean negative, String principal, String permissionType) {
        TreeSet<EsupPermission> newTree = new TreeSet<EsupPermission>();
        EsupPermission perm = new EsupPermission(negative, principal, permissionType, false, null, false, "DAV:", this.userPrefix, this.groupPrefix, this.securityGroup);
        boolean deleted = false;
        for (EsupPermission iterPerm : this.permissions) {
            boolean equals = iterPerm.equals(perm);
            if (!equals) {
                newTree.add(iterPerm);
                continue;
            }
            deleted = true;
        }
        this.permissions = newTree;
        return deleted;
    }

    public int size() {
        return this.permissions.size();
    }

    public String toString() {
        String s = "";
        Iterator iter = this.iterator();
        String lastInheritedFrom = "";
        while (iter.hasNext()) {
            EsupPermission perm = (EsupPermission)iter.next();
            String inh2 = perm.getInheritedFrom();
            if (inh2 == null) {
                inh2 = "";
            }
            if (!lastInheritedFrom.equals(inh2)) {
                s = s + "\n";
                lastInheritedFrom = inh2;
            }
            s = s + " *** " + perm + "\n";
        }
        return s;
    }
}

