



/**
 * Id: AuthorizationSpaceParameter.java,v 1.0 9 juil. 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: AuthorizationSpaceParameter<br/>
 * Original Author: Yohan Colmant<br/>
 * This represents an attribute and a value a user has to have to access the specified space<br/>
 */
public class OldAuthorizationSpaceParameter {
	
	/**
	 * The attribute name
	 */
	private String attribute;
	
	/**
	 * The attribute value
	 */
	private String value;
	
	
	
	
	/**
	 * @return Returns the attribute.
	 */
	public String getAttribute() {
		return attribute;
	}
	/**
	 * @param attribute The attribute to set.
	 */
	public void setAttribute(String attribute) {
		this.attribute = attribute;
	}
	/**
	 * @return Returns the value.
	 */
	public String getValue() {
		return value;
	}
	/**
	 * @param value The value to set.
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	
	/**
	 * Clone the object
	 */
	public Object clone() {
		OldAuthorizationSpaceParameter asp = new OldAuthorizationSpaceParameter();
		asp.attribute = this.attribute;
		asp.value = this.value;
		return asp;
	}
	
	
	/**
	 * Get the xml in the configuration file style
	 * @return the xml in the configuration file style
	 */
	public String getXml() {
		return "<ALLOWED attribute=\""+attribute+"\" value=\""+value+"\"/>";
	}
}
