/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.util.configuration.Configurator;
import org.apache.ojb.odmg.locking.InMemoryLockMapImpl;
import org.apache.ojb.odmg.locking.LockMap;
import org.apache.ojb.odmg.locking.LockingConfiguration;

public class LockMapFactory {
    private static LockMap LOCKMAP = null;

    public static synchronized LockMap getLockMap() {
        if (LOCKMAP == null) {
            LOCKMAP = LockMapFactory.createNewLockMap();
        }
        return LOCKMAP;
    }

    private static LockMap createNewLockMap() {
        try {
            Configurator configurator = PersistenceBrokerFactory.getConfigurator();
            LockingConfiguration config = (LockingConfiguration)((Object)configurator.getConfigurationFor(null));
            Class clazz = config.getLockMapClass();
            LockMap map = (LockMap)clazz.newInstance();
            configurator.configure(map);
            return map;
        }
        catch (Exception e) {
            return new InMemoryLockMapImpl();
        }
    }
}

