/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.transaction;

import java.util.HashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryException;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryFactory;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.core.BaseConnection;
import org.apache.ojb.otm.core.TransactionException;
import org.apache.ojb.otm.transaction.TransactionFactory;
import org.apache.ojb.otm.transaction.TransactionFactoryException;

public abstract class ManagedTransactionFactory
implements TransactionFactory {
    private HashMap _transactionMap = new HashMap();
    private TransactionManager tm;

    public org.apache.ojb.otm.core.Transaction getTransactionForConnection(OTMConnection connection) {
        if (!(connection instanceof BaseConnection)) {
            throw new TransactionFactoryException("Unknown connection type");
        }
        BaseConnection baseConnection = (BaseConnection)connection;
        Transaction jtaTx = this.getJTATransaction();
        if (jtaTx == null) {
            throw new TransactionFactoryException("Unable to get the JTA Transaction");
        }
        org.apache.ojb.otm.core.Transaction tx = (org.apache.ojb.otm.core.Transaction)this._transactionMap.get(jtaTx);
        if (tx == null) {
            tx = new org.apache.ojb.otm.core.Transaction();
            this._transactionMap.put(jtaTx, tx);
        }
        tx.registerConnection(baseConnection);
        return tx;
    }

    public OTMConnection acquireConnection(PBKey pbKey) {
        return new ManagedConnection(pbKey);
    }

    public Transaction getJTATransaction() {
        if (this.tm == null) {
            try {
                this.tm = TransactionManagerFactoryFactory.instance().getTransactionManager();
            }
            catch (TransactionManagerFactoryException e) {
                throw new TransactionFactoryException("Can't instantiate TransactionManagerFactory", (Throwable)((Object)e));
            }
        }
        try {
            return this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw new TransactionFactoryException("Error acquiring JTA Transaction", e);
        }
    }

    private static class ManagedConnection
    extends BaseConnection {
        public ManagedConnection(PBKey pbKey) {
            super(pbKey);
        }

        public void transactionBegin() throws TransactionException {
        }

        public void transactionPrepare() throws TransactionException {
        }

        public void transactionCommit() throws TransactionException {
        }

        public void transactionRollback() throws TransactionException {
        }
    }
}

