/*
 * Created on 18 oct. 06
 */
package org.esupportail.portal.channels.CStockage.channelAction.groupManager;

import java.util.Hashtable;

/**
 * Id: GroupTree.java,v 1.0 18 oct. 06
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: GroupTree
 * Original Author: Yohan Colmant
 * 
 */
public class GroupTree {

	private static int lastId = 0;

	private static Hashtable groupTreeEntries = new Hashtable(); 
	
	
	
	/**
	 * @return the lastId
	 */
	private static synchronized String getNewId() {
		lastId++;
		return (lastId-1)+"";
	}
	
	
	
	/**
	 * @return true if the root group entry is initialized
	 */
	private static boolean isRootGroupEntryInitialized(String spaceKey) {
		return groupTreeEntries.containsKey(spaceKey);
	}
	
	
	/**
	 * init and return the root group entry
	 * @return the root group entry initialized
	 */
	public static synchronized GroupTreeEntry initRootGroupEntry(String spaceKey, String path) {
		GroupTreeEntry groupTreeEntry = null;
		if (!isRootGroupEntryInitialized(spaceKey)) {
			groupTreeEntry = new GroupTreeEntry("root", "root", getNewId(), path, "root");
			groupTreeEntries.put(spaceKey, groupTreeEntry);
		}
		else {
			groupTreeEntry = (GroupTreeEntry)groupTreeEntries.get(spaceKey);
		}
		return groupTreeEntry;
	}
	
	
	/**
	 * @return the root group entry
	 */
	public static synchronized GroupTreeEntry getRootGroupEntry(String spaceKey) {
		return (GroupTreeEntry)groupTreeEntries.get(spaceKey);
	}
	
	

	/**
	 * @return the root group entry
	 */
	public static synchronized void addChild(GroupTreeEntry entry, String name, String displayName, String key) {
		String parentPath = entry.getPath();
		String childPath = parentPath;
		if (!childPath.endsWith("/")) {
			childPath += "/";
		}
		childPath += name+"/";
		GroupTreeEntry newEntry = new GroupTreeEntry(name, displayName, getNewId(), childPath, key);
		entry.addChild(newEntry);
	}
	
	
	
	
	
}
