/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.config;

import java.util.ArrayList;



/**
 * Id: AuthorizationSpace.java,v 1.0 8 nov. 2006<br/>
 * Copyright (c) 2006 Esup Portail (www.esup-portail.org)<br/>
 * Classes: AuthorizationSpace<br/>
 * Original Author: Yohan Colmant<br/>
 * This represents an attribute and a value a user has to have to access the specified space<br/>
 */
public class AuthorizationSpace {
	
	
	/**
	 * The operator
	 */
	private String operator = OR;
	

	/**
	 * The authorization list for this space
	 */
	private ArrayList authorizations = new ArrayList();
	
	
	public static final String AND="and";
	public static final String OR="or";

	
	
	/**
	 * return the authorization list
	 * @return the authorization list
	 */
	public ArrayList getAuthorizations() {			
		return authorizations;
	}

	/**
	 * add a new authorization to the list
	 * @param authorization the authorization to add
	 */
	public void setAuthorization(AuthorizationSpaceParameter authorization) {		
		// add this authorization
		authorizations.add(authorization);
	}
	
	
	
	
	
	
	
	/**
	 * @return the operator
	 */
	public String getOperator() {
		return operator;
	}

	/**
	 * @param operator the operator to set
	 */
	public void setOperator(String operator) {
		this.operator = operator.toLowerCase();
	}

	
	
	/**
	 * Clone the object
	 */
	public Object clone() {
		AuthorizationSpace clone = new AuthorizationSpace();
		clone.operator = this.operator;


		clone.authorizations = new ArrayList();
		for (int i=0; i<this.authorizations.size(); i++) {
			clone.authorizations.add(((AuthorizationSpaceParameter)this.authorizations.get(i)).clone());
		}
		
		return clone;
	}
	
}
