<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no"/>

<xsl:param name="baseActionURL"/>


<xsl:template name="_server">

	
	<script language="javascript">
		<![CDATA[
		
		
		
		function getLabel(name) {
			
			if (name=="url") {
				document.write('Url');
			}
			else if (name=="unauthenticatedServerUrl") {
				document.write('Url publique du serveur');
			}
			else if (name=="injacPreviewUrl") {
				document.write('Url de prvisualisation du rendu inJAC');
			}
			else if (name=="serverType") {
				document.write('Type de serveur');
			}
			else if (name=="authenticationMode") {
				document.write("Mode d'authentification");
			}
			else if (name=="initialLoginFromTheConfigurationFile") {
				document.write('Login');
			}
			else if (name=="password") {
				document.write('Mot de passe');
			}
			else if (name=="manageAcl") {
				document.write('Supporte les ACL');
			}
			else if (name=="aclNamespace") {
				document.write('ACL: Namespace');
			}
			else if (name=="aclUserPrefix") {
				document.write('ACL: prfixe des utilisateurs');
			}
			else if (name=="aclGroupPrefix") {
				document.write('ACL: prfixe des groupes');
			}
			else if (name=="aclUportalGroup") {
				document.write('ACL: uri des groupes uPortal');
			}
			else if (name=="aclSecurity") {
				document.write('ACL: groupe de scurit');
			}
			else if (name=="cifsDomain") {
				document.write('CIFS: domaine');
			}
			else if (name=="cifsResolveOrder") {
				document.write('CIFS: resolveOrder');
			}
			else if (name=="cifsDisablePlainTextPassword") {
				document.write('CIFS: disablePlainTextPassword');
			}
			else if (name=="cifsUseUnicode") {
				document.write('CIFS: useUnicode');
			}
			else if (name=="cifsEncoding") {
				document.write('CIFS: encoding');
			}
			else {
				document.write(name);
			}
			
		}
		
		
		
		
		
		function getComment(name) {
			
			if (name=="url") {
				document.write('Exemple: "http://serveur:8080" (webdav) ou "smb:\\\\serveur" (cifs)');
			}
			else if (name=="unauthenticatedServerUrl") {
				document.write('Exemple: "http://serveur_pub:8080"');
			}
			else if (name=="injacPreviewUrl") {
				document.write('Exemple: "http://serveur/injac/preview"');
			}
			else if (name=="serverType") {
				document.write('');
			}
			else if (name=="authenticationMode") {
				document.write("");
			}
			else if (name=="initialLoginFromTheConfigurationFile") {
				document.write('');
			}
			else if (name=="password") {
				document.write('');
			}
			else if (name=="manageAcl") {
				document.write('Utilis pour la position des droits (uniquement avec un serveur Slide)');
			}
			else if (name=="aclNamespace") {
				document.write('Exemple: "DAV:"');
			}
			else if (name=="aclUserPrefix") {
				document.write('Exemple: "/slide/users/"');
			}
			else if (name=="aclGroupPrefix") {
				document.write('Exemple: "/slide/roles/"');
			}
			else if (name=="aclUportalGroup") {
				document.write('Exemple: "uPortal"');
			}
			else if (name=="aclSecurity") {
				document.write('Exemple: "/slide/roles/local/root"');
			}
			else if (name=="cifsDomain") {
				document.write('Exemple: "univ.fr"');
			}
			else if (name=="cifsResolveOrder") {
				document.write('Exemple: "DNS,BCAST"');
			}
			else if (name=="cifsDisablePlainTextPassword") {
				document.write('');
			}
			else if (name=="cifsUseUnicode") {
				document.write('');
			}
			else if (name=="cifsEncoding") {
				document.write('Exemple: "UTF8"');
			}
			else {
				document.write('');
			}
			
		}
		
		
		]]>
	</script>
	
	
	
	

	  <table width="10%" align="center" border="0" cellspacing="5" cellpadding="5">
        
         
	<xsl:for-each select="/ROOT/server/attributes/attribute">
		<tr align="center">
		
			<xsl:choose>
				<xsl:when test="@goodFormat='true'">						
					<td class="uportal-text" nowrap="true" align="right">
						<nobr>
						<script language="javascript">
							<!--xsl:comment-->
								getLabel("<xsl:value-of select="@name"/>");
							<!--/xsl:comment-->
						</script>
						<xsl:if test="@obliged='true'">
							&#160;*
						</xsl:if>
						</nobr>
					</td>							
				</xsl:when>
	  
				<xsl:otherwise>
			 		<td class="uportal-channel-strong" style="color: red;" align="right">								
						<nobr>
						<script language="javascript">
							<!--xsl:comment-->
								getLabel("<xsl:value-of select="@name"/>");
							<!--/xsl:comment-->
						</script>
						<xsl:if test="@obliged='true'">
							&#160;*
						</xsl:if>
						</nobr>
					</td>
				</xsl:otherwise>
			</xsl:choose>
			
			
			<td class="uportal-text" nowrap="true" align="left">
				<nobr>
				<xsl:if test="@input='text'">
					<xsl:choose>
						<xsl:when test="@modifiable='true'">
							<input type="text" name="{@name}" size="30" class="uportal-input-text" value="{@value}" /> 
						</xsl:when>
						<xsl:otherwise>
							<input type="text" name="{@name}" size="30" class="uportal-input-text" value="{@value}" readonly="true"/> 
						</xsl:otherwise>
					</xsl:choose>					
				</xsl:if>
				
				<xsl:if test="@input='select'">					
					<xsl:variable name="default"><xsl:value-of select="@value"/></xsl:variable>
					<select class="uportal-input-text" name="{@name}" size="1" onChange="this.form.submit();">											
						<xsl:for-each select="choice">						
							<xsl:choose>						
								<xsl:when test="@value=$default">																											
									<option class="uportal-input-text" selected="true" value="{@value}"><xsl:value-of select="@value"/></option>
								</xsl:when>
								<xsl:otherwise>									
									<option class="uportal-input-text" value="{@value}"><xsl:value-of select="@value"/></option>
								</xsl:otherwise>
							</xsl:choose>					
						</xsl:for-each>
					</select>					
				</xsl:if>
				
				&#160;
				<script language="javascript">
					<!--xsl:comment-->
						getComment("<xsl:value-of select="@name"/>");
					<!--/xsl:comment-->
				</script>
				</nobr>		
			</td>
		
		</tr>
	</xsl:for-each>
	
	<tr>
		<td class="uportal-text" colspan="2" align="right">
			(*) obligatoire
		</td>
	</tr>
	    
	  
      </table>
			
	
	
</xsl:template>
</xsl:stylesheet>