/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

package org.esupportail.portal.channels.CStockage.config;


/**
 * Id: Config.java,v 1.0<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: Config<br/>
 * Original Author: Sbastien GAUDIN<br/>
 * This class parse the CStockage.xml config file to return all parameters<br/>
 */



import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.channelAction.classic.sharing.SharedSpaceProperties;
import org.esupportail.portal.channels.CStockage.exception.PropertiesException;
import org.esupportail.portal.channels.CStockage.spacesPersonalization.PersonalizationTool;
import org.esupportail.portal.utils.database.Database;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;



public class ChannelConfiguration { 
	

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(ChannelConfiguration.class);
	
	
	/*spaces*/
	private String spacesPersonalization;	
	private Hashtable serverAccess = new Hashtable();
	private Hashtable sharingMapping = new Hashtable();
	private Hashtable channelActions = new Hashtable();
	private ArrayList checkedAttributes = new ArrayList();
	
	private int count = 0;
	private ArrayList servers = new ArrayList();
	

	
	
	/*Ldap access*/
	private String ldapServerUrl;
	private String ldapPeople;
	private String ldapBindDn;
	private String ldapBindPassword;
	private String ldapUserKeyAttribute;
	private String ldapUserDisplayNameAttribute;

	

	/*Database access*/
	/*private String dataBaseDriver;
	private String dataBaseURL;
	private String dataBaseLogin;
	private String dataBasePassword;*/
	private Database pool;


	/*Accessible directories list*/
	private String directoriesList;
	
	
	/*Authentication*/
	private String usernameAttribute;
	private boolean httpsRedirection;

	
	/*Interface options*/
	private boolean confirmDel = true;
	private boolean allowDelNonEmptyFolder = true;
		
	/*Regular expression for "invisibles" files*/
	private Vector invisibleRegexp = new Vector();
	
	/*Regular expression for "allowed" documents*/
	private String allowedRegexp;
	

	/*path of the config file*/
	private static String configFilePath ="/properties/channels/org_esup/CStockage/CStockage.xml";
	private static long configFileLastModified;
	
	
	/**
	 * The instance of the channel configuration
	 */
	private static ChannelConfiguration config = null;
	
	
	
	
	/**
	 * Get an instance of the channel configuration
	 * @return an instance of the channel configuration
	 * @throws PropertiesException
	 */
	/*public static ChannelConfiguration getInstance_without_date_checking() throws PropertiesException {
		if (config == null) {
			config = new ChannelConfiguration();
		}
		return config;
	}*/
	public static ChannelConfiguration getInstance() throws PropertiesException {
		if (config == null) {
			config = new ChannelConfiguration();
		}
		
		else {
			URL url = ChannelConfiguration.class.getResource(configFilePath);
			File configFile = new File(url.getFile());
			
			long newDate = configFile.lastModified();
			if (configFileLastModified < newDate) {
				log.debug("getInstance :: "+"Configuration reloaded");
				configFileLastModified = newDate;
				config = new ChannelConfiguration();
		  }
			
		}
		             
		return config;
	}
	
	
	
	/**
	 * Constructor
	 * @throws PropertiesException
	 */
	private ChannelConfiguration() throws PropertiesException {

		Digester digester = new Digester();
		digester.setValidating(false);
		digester.push(this);
		
		/*
		 * The server access
		 */
		digester.addObjectCreate("CHANNEL_CONFIGURATION/SERVER_ACCESS_CLASS/ACCESS",ServerAccessClass.class);		
		
		digester.addSetProperties("CHANNEL_CONFIGURATION/SERVER_ACCESS_CLASS/ACCESS","serverType","serverType");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SERVER_ACCESS_CLASS/ACCESS","class", "accessClass");
		
		digester.addSetNext("CHANNEL_CONFIGURATION/SERVER_ACCESS_CLASS/ACCESS", "setServerAccess");
		
		

		/*
		 * The channel action
		 */
		digester.addObjectCreate("CHANNEL_CONFIGURATION/CHANNEL_ACTION_CLASS/ACTION",ChannelActionClass.class);		
		
		digester.addSetProperties("CHANNEL_CONFIGURATION/CHANNEL_ACTION_CLASS/ACTION","serverType","actionType");
		digester.addSetProperties("CHANNEL_CONFIGURATION/CHANNEL_ACTION_CLASS/ACTION","class", "actionClass");
		
		digester.addSetNext("CHANNEL_CONFIGURATION/CHANNEL_ACTION_CLASS/ACTION", "setChannelActions");
		

		
		/*
		 * The attributes we want to check
		 */
		digester.addObjectCreate("CHANNEL_CONFIGURATION/SPACE_ATTRIBUTES_CHECKED/ATTRIBUTE",CheckedAttribute.class);		
		
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACE_ATTRIBUTES_CHECKED/ATTRIBUTE","name","name");
		
		digester.addSetNext("CHANNEL_CONFIGURATION/SPACE_ATTRIBUTES_CHECKED/ATTRIBUTE", "setCheckedAttributes");
		
			
		
			
		
		/*
		 * The spaces
		 */
		digester.addSetProperties("*/SPACES");
		digester.addCallMethod("*/SPACES", "setSpacesPersonalization", 1);
		digester.addCallParam("*/SPACES", 0, "personalization");
		
		setDigesterConfigurationForServer(digester);

		

		/*
		 * The sharing mapping
		 */
		digester.addObjectCreate("CHANNEL_CONFIGURATION/SHARING/SERVER",SharingMapping.class);		
		
		digester.addSetProperties("CHANNEL_CONFIGURATION/SHARING/SERVER","url","url");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SHARING/SERVER","mapping", "mapping");
		
		digester.addSetNext("CHANNEL_CONFIGURATION/SHARING/SERVER", "setSharingMapping");
		
		
		
		/*
		 * The ldap access
		 */		
		digester.addSetProperties("CHANNEL_CONFIGURATION/LDAP_ACCESS");
		digester.addCallMethod("CHANNEL_CONFIGURATION/LDAP_ACCESS", "setLdapServerUrl", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/LDAP_ACCESS", 0, "serverUrl");
		digester.addCallMethod("CHANNEL_CONFIGURATION/LDAP_ACCESS", "setLdapBindDn", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/LDAP_ACCESS", 0, "bindDn");
		digester.addCallMethod("CHANNEL_CONFIGURATION/LDAP_ACCESS", "setLdapBindPassword", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/LDAP_ACCESS", 0, "bindPassword");
		digester.addCallMethod("CHANNEL_CONFIGURATION/LDAP_ACCESS", "setLdapPeople", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/LDAP_ACCESS", 0, "people");
		digester.addCallMethod("CHANNEL_CONFIGURATION/LDAP_ACCESS", "setLdapUserKeyAttribute", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/LDAP_ACCESS", 0, "userKeyAttribute");
		digester.addCallMethod("CHANNEL_CONFIGURATION/LDAP_ACCESS", "setLdapUserDisplayNameAttribute", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/LDAP_ACCESS", 0, "userDisplayNameAttribute");
		



		/*
		 * The database access
		 */		
		digester.addObjectCreate("CHANNEL_CONFIGURATION/DATABASE_ACCESS",Database.class);		
		
		//digester.addSetProperties("CHANNEL_CONFIGURATION/DATABASE_ACCESS","name","name");
		digester.addSetProperties("CHANNEL_CONFIGURATION/DATABASE_ACCESS","type","type");
		digester.addSetProperties("CHANNEL_CONFIGURATION/DATABASE_ACCESS","url","url");
		digester.addSetProperties("CHANNEL_CONFIGURATION/DATABASE_ACCESS","driverClassName","driverClassName");
		digester.addSetProperties("CHANNEL_CONFIGURATION/DATABASE_ACCESS","username","username");
		digester.addSetProperties("CHANNEL_CONFIGURATION/DATABASE_ACCESS","password","password");
		
		digester.addSetNext("CHANNEL_CONFIGURATION/DATABASE_ACCESS", "setPool");


		/*
		 * The directories list
		 */		
		digester.addSetProperties("CHANNEL_CONFIGURATION/DIRECTORIES");
		digester.addCallMethod("CHANNEL_CONFIGURATION/DIRECTORIES", "setDirectoriesList", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/DIRECTORIES", 0, "list");
		
		


		/*
		 * The authentication
		 * Add username_attribute,trusted_password and classAuth
		 */		
		digester.addSetProperties("CHANNEL_CONFIGURATION/AUTHENTICATION");
		digester.addCallMethod("CHANNEL_CONFIGURATION/AUTHENTICATION", "setUsernameAttribute", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/AUTHENTICATION", 0, "usernameAttribute");
		digester.addCallMethod("CHANNEL_CONFIGURATION/AUTHENTICATION", "setHttpsRedirection", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/AUTHENTICATION", 0, "httpsRedirection");
		
		
		/*
		 * Interface options
		 * Add confirmDel and allowDelNonEmptyFolder
		 */		
		digester.addCallMethod("CHANNEL_CONFIGURATION/DEFAULT_OPTIONS_INTERFACE", "setConfirmDel", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/DEFAULT_OPTIONS_INTERFACE", 0, "confirmDel");
		digester.addCallMethod("CHANNEL_CONFIGURATION/DEFAULT_OPTIONS_INTERFACE", "setAllowDelNonEmptyFolder", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/DEFAULT_OPTIONS_INTERFACE", 0, "allowDelNonEmptyFolder");
		  
		/*
		 * Invisibles files
		 * Add every  regular Expression
		 */		
		digester.addCallMethod("CHANNEL_CONFIGURATION/INVISIBLE_FILES/REG_EXP", "addInvisibleRegexp", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/INVISIBLE_FILES/REG_EXP", 0, "pattern");

		

		/*
		 * The allowed documents
		 */
		digester.addSetProperties("CHANNEL_CONFIGURATION/ALLOWED_DOCUMENTS");
		digester.addCallMethod("CHANNEL_CONFIGURATION/ALLOWED_DOCUMENTS", "setAllowedRegexp", 1);
		digester.addCallParam("CHANNEL_CONFIGURATION/ALLOWED_DOCUMENTS", 0, "regexp");
		
		
		
		
		URL url = ChannelConfiguration.class.getResource(configFilePath);	
		
		if (url != null) {

			InputSource inSource = new InputSource(url.toExternalForm());
			
			// get the file date
			File configFile = new File(url.getFile());
			configFileLastModified = configFile.lastModified();
             
			try {
				//parse config file
				digester.parse(inSource);							
			}
			catch (IOException e) {				
				log.error("ChannelConfiguration :: Unable to open config file" + configFilePath	+" "+ e.toString());
				throw new PropertiesException();
			}
			catch (SAXException e) {
				e.printStackTrace();
				log.error("ChannelConfiguration :: " + e.toString());
				throw new PropertiesException();
			}
		}
		else { 
			log.error("ChannelConfiguration :: "	+ configFilePath + " does not exist.\n");
			throw new PropertiesException();
		}
	}
	
	
	/**
	 * Set the configuration for SERVER tag
	 * @param digester the object to set
	 */
	public static void setDigesterConfigurationForServer(Digester digester) {

		// SERVER
		digester.addObjectCreate("*/SERVER",Server.class);		
		
		digester.addSetProperties("*/SERVER","url", "url");
		digester.addSetProperties("*/SERVER","serverType", "serverType");
		digester.addSetProperties("*/SERVER","authenticationMode", "authenticationMode");
		digester.addSetProperties("*/SERVER","login", "initialLoginFromTheConfigurationFile");
		digester.addSetProperties("*/SERVER","password", "password");

		// PARAMETER
		digester.addObjectCreate("*/SERVER/PARAMETER",Parameter.class);
		
		digester.addSetProperties("*/SERVER/PARAMETER","name", "name");
		digester.addSetProperties("*/SERVER/PARAMETER","value", "value");
		
		// SPACE
		digester.addObjectCreate("*/SERVER/SPACE",Space.class);		
		
		digester.addSetProperties("*/SERVER/SPACE","key", "key");
		digester.addSetProperties("*/SERVER/SPACE","label", "label");
		digester.addSetProperties("*/SERVER/SPACE","path", "path");
		digester.addSetProperties("*/SERVER/SPACE","pathRegexp", "pathRegexp");
		digester.addSetProperties("*/SERVER/SPACE","pathRegexpSeparator", "pathRegexpSeparator");
		digester.addSetProperties("*/SERVER/SPACE","actionType", "actionType");
		digester.addSetProperties("*/SERVER/SPACE","sharing", "sharing");
		digester.addSetProperties("*/SERVER/SPACE","allowPublicSharing", "allowPublicSharing");
		digester.addSetProperties("*/SERVER/SPACE","obliged", "obligedSpace");
		digester.addSetProperties("*/SERVER/SPACE","showQuota", "showQuota");
		digester.addSetProperties("*/SERVER/SPACE","setSharingIntoDatabase", "setSharingIntoDatabase");
		digester.addSetProperties("*/SERVER/SPACE","browserAccessUrlVisibility", "browserAccessUrlVisibility");
		digester.addSetProperties("*/SERVER/SPACE","showOthersAcl", "editOther");
		digester.addSetProperties("*/SERVER/SPACE","manageShibUsers", "manageShib");
		
		
		
		
		
		//AUTHORIZATION
		digester.addObjectCreate("*/SERVER/SPACE/AUTHORIZATION",AuthorizationSpace.class);		
		digester.addSetProperties("*/SERVER/SPACE/AUTHORIZATION","operator","operator");
		
		
		// ALLOWED
		digester.addObjectCreate("*/SERVER/SPACE/AUTHORIZATION/ALLOWED",AuthorizationSpaceParameter.class);
		digester.addSetProperties("*/SERVER/SPACE/AUTHORIZATION/ALLOWED");		
		
		
		digester.addSetNext("*/SERVER/SPACE/AUTHORIZATION/ALLOWED", "setAuthorization");
		digester.addSetNext("*/SERVER/SPACE/AUTHORIZATION", "setAuthorizations");
		digester.addSetNext("*/SERVER/SPACE", "addSpace");
		digester.addSetNext("*/SERVER/PARAMETER", "addParameter");
		digester.addSetNext("*/SERVER", "addServer");
	}
	
	
	
	/**
	 * return the spaces list
	 * @return the spaces list
	 */
	/*public ArrayList getDefaultSpaces_old2() throws PropertiesException {
		
		if (servers.size()==0) {
			log.error("getDefaultSpaces :: there is no space set - servers is empty");
			throw new PropertiesException();
		}
		else {
			
			// clone the server list
			ArrayList cloneList = new ArrayList(); 			
			for (int i=0; i<servers.size(); i++) {
				Server server = (Server)servers.get(i);
				cloneList.add(server.clone());
			}
			
			// for each server, we get the spaces
			ArrayList spaces = new ArrayList();
			for (int i=0; i<cloneList.size(); i++) {
				Server server = (Server)cloneList.get(i);
				
				ArrayList spacesOfServer = server.getSpaces();
				for (int j=0; j<spacesOfServer.size(); j++) {
					Space space = (Space)spacesOfServer.get(j);
					space.setServer(server);
					spaces.add(space);
				}
				
				//server.initSpaces();
			}
			
			// we return the result
			if (spaces.size()==0) {
				log.error("getDefaultSpaces :: there is no space set - spaces is empty");
				throw new PropertiesException();
			}
			else {
				return spaces;
			}
		}
				
	}*/
	
	public ArrayList[] getDefaultSpaces() throws PropertiesException {
		
		if (servers.size()==0) {
			log.error("getDefaultSpaces :: there is no space set - servers is empty");
			throw new PropertiesException();
		}
		else {
			
			// clone the server list
			ArrayList cloneList = new ArrayList(); 			
			for (int i=0; i<servers.size(); i++) {
				Server server = (Server)servers.get(i);
				cloneList.add(server.clone());
			}
			
			// for each server, we get the spaces
			ArrayList spaces = new ArrayList();
			for (int i=0; i<cloneList.size(); i++) {
				Server server = (Server)cloneList.get(i);
				
				ArrayList spacesOfServer = server.getSpaces();
				for (int j=0; j<spacesOfServer.size(); j++) {
					Space space = (Space)spacesOfServer.get(j);
					space.setServer(server);
					spaces.add(space);
				}
				
				//server.initSpaces();
			}
			
			// we return the result
			if (spaces.size()==0) {
				log.error("getDefaultSpaces :: there is no space set - spaces is empty");
				throw new PropertiesException();
			}
			else {
				
				ArrayList obliged = new ArrayList();
				ArrayList notObliged = new ArrayList();
				for (int i=0; i<spaces.size(); i++) {
					Space s = (Space)spaces.get(i);
					if (s.isObliged()) {
						obliged.add(s);
					}
					else {
						s.setPersonnalSpace(true);
						SharedSpaceProperties sharedProp = new SharedSpaceProperties();
						sharedProp.setFromKey(PersonalizationTool.ADMINISTRATED_SERVER);
						s.setCurrentViewer(sharedProp);
						notObliged.add(s);
						
						s.setKey("local_"+s.getKey());
					}
				}
				ArrayList[] result = new ArrayList[2];
				result[0] = obliged;
				result[1] = notObliged;
				return result;
			}
		}
				
	}
	
	
	
	/**
	 * add a new server to the list
	 * @param server the server to add
	 */
	public void addServer(Server server) {
		
		// the server access class
		String serverType = server.getServerType();
		String serverClass = null;
		
		if (serverType!=null) {
			serverClass = (String)this.serverAccess.get(serverType);
			server.setServerAccessClass(serverClass);
		}
		
		// for each space
		ArrayList spaces = server.getSpaces();
		for (int i=0; spaces!=null && i<spaces.size(); i++) {
			
			Space space = (Space)spaces.get(i);
			
			// the channel action type
			String actionType = space.getActionType();
			String actionClass = null;
		
			if (actionType!=null) {
				actionClass = (String)this.channelActions.get(actionType);
				space.setChannelActionClass(actionClass);
				
				space.setMetadataNamespace(actionType.toUpperCase()+":");
			}		
		
			// generate the key for this space
			//space.setKey("config_"+count);
			count++;
			
			// set the server into this space
			//space.setServer(server);
		}
		
		// init the spaces into the server
		//server.initSpaces();
		
		servers.add(server);
	}
	
	
	
	
	
	

	/**
	 * return the pools list
	 * @return the pools list
	 */
	public Database getPool() throws PropertiesException {
		if (pool == null) {
			log.error("getPool :: there is no pool set");
			throw new PropertiesException();
		}
				
		return pool;
	}

	/**
	 * set the database pool
	 * @param pool the database pool
	 */
	public void setPool(Database pool) {
		pool.setName("CStockage");
		this.pool = pool;
	}
	

	
	
	/**
	 * @return Returns the directoriesList.
	 */
	public String getDirectoriesList() {
		return directoriesList;
	}
	/**
	 * @param directoriesList The directoriesList to set.
	 */
	public void setDirectoriesList(String directoriesList) {
		this.directoriesList = directoriesList;
	}
	
	
	
	/**
	 * @return Returns the spacesPersonalization.
	 */
	public boolean isSpacesPersonalization() {
		if (spacesPersonalization!=null)
			return spacesPersonalization.equals("true");
		else return false;
	}
	
	/**
	 * @param spacesPersonalization The spacesPersonalization to set.
	 */
	public void setSpacesPersonalization(String spacesPersonalization) {
		this.spacesPersonalization = spacesPersonalization;
	}
	
	
	
	
	

	/**
	 * return the server access list
	 * @return the server access list
	 */
	public Hashtable getServerAccess() throws PropertiesException {
		if (serverAccess.size()==0) {
			log.error("getServerAccess :: there is no server access set");
			throw new PropertiesException();
		}
				
		return serverAccess;
	}

	/**
	 * add a new server access to the list
	 * @param access the server access to add
	 */
	public void setServerAccess(ServerAccessClass access) {
		serverAccess.put(access.getServerType(), access.getAccessClass());
	}
	

	/**
	 * add a new server access to the list
	 * @param access the server access to add
	 */
	public void setSharingMapping(SharingMapping mapping) {
		sharingMapping.put(mapping.getUrl(), mapping.getMapping());
	}
	

	/**
	 * @return the sharingMapping
	 */
	public Hashtable getSharingMapping() {
		return sharingMapping;
	}



	/**
	 * add a new checked attribute to the list
	 * @param checkedAttribute the checked attribute to add
	 */
	public void setCheckedAttributes(CheckedAttribute checkedAttribute) {
		checkedAttributes.add(checkedAttribute.getName());
	}
	
	/**
	 * Return the list of checked attributes
	 * @return the list of checked attributes
	 */
	public ArrayList getCheckedAttributes() {
		return this.checkedAttributes;
	}
	


	


	/**
	 * return the channel actions list
	 * @return the channel actions list
	 */
	public Hashtable getChannelActions() throws PropertiesException {
		if (channelActions.size()==0) {
			log.error("getChannelActions :: there is no channel action set");
			throw new PropertiesException();
		}
				
		return channelActions;
	}

	/**
	 * add a new channel action to the list
	 * @param action the channel action to add
	 */
	public void setChannelActions(ChannelActionClass action) {
		channelActions.put(action.getActionType(), action.getActionClass());
	}
		
	
	
	
	
	/**
	 * @return Returns the ldapBindDn.
	 */
	public String getLdapBindDn() {
		return ldapBindDn;
	}
	/**
	 * @param ldapBindDn The ldapBindDn to set.
	 */
	public void setLdapBindDn(String ldapBindDn) {
		this.ldapBindDn = ldapBindDn;
	}
	/**
	 * @return Returns the ldapBindPassword.
	 */
	public String getLdapBindPassword() {
		return ldapBindPassword;
	}
	/**
	 * @param ldapBindPassword The ldapBindPassword to set.
	 */
	public void setLdapBindPassword(String ldapBindPassword) {
		this.ldapBindPassword = ldapBindPassword;
	}
	/**
	 * @return Returns the ldapPeople.
	 */
	public String getLdapPeople() {
		return ldapPeople;
	}
	/**
	 * @param ldapPeople The ldapPeople to set.
	 */
	public void setLdapPeople(String ldapPeople) {
		this.ldapPeople = ldapPeople;
	}
	/**
	 * @return Returns the ldapServerUrl.
	 */
	public String getLdapServerUrl() {
		return ldapServerUrl;
	}
	/**
	 * @param ldapServerUrl The ldapServerUrl to set.
	 */
	public void setLdapServerUrl(String ldapServerUrl) {
		this.ldapServerUrl = ldapServerUrl;
	}
	/**
	 * @return Returns the ldapUserDisplayNameAttribute.
	 */
	public String getLdapUserDisplayNameAttribute() {
		return ldapUserDisplayNameAttribute;
	}
	/**
	 * @param ldapUserDisplayNameAttribute The ldapUserDisplayNameAttribute to set.
	 */
	public void setLdapUserDisplayNameAttribute(
			String ldapUserDisplayNameAttribute) {
		this.ldapUserDisplayNameAttribute = ldapUserDisplayNameAttribute;
	}
	/**
	 * @return Returns the ldapUserKeyAttribute.
	 */
	public String getLdapUserKeyAttribute() {
		return ldapUserKeyAttribute;
	}
	/**
	 * @param ldapUserKeyAttribute The ldapUserKeyAttribute to set.
	 */
	public void setLdapUserKeyAttribute(String ldapUserKeyAttribute) {
		this.ldapUserKeyAttribute = ldapUserKeyAttribute;
	}
	
	
	
	
	
	
	/**
	 * @return Returns the allowDelNonEmptyFolder.
	 */
	public boolean getAllowDelNonEmptyFolder() {
		return allowDelNonEmptyFolder;
	}
	
	/**
	 * @param allowDelNonEmptyFolder The allowDelNonEmptyFolder to set.
	 */
	public void setAllowDelNonEmptyFolder(String allowDelNonEmptyFolder) {
		if (allowDelNonEmptyFolder!=null && allowDelNonEmptyFolder.equals("true"))
			this.allowDelNonEmptyFolder = true;
		else 
			this.allowDelNonEmptyFolder = false;
	}
	
	
	public boolean getConfirmDel() {
		return confirmDel;
	}
	
	/**
	 * @param confirmDel The confirmDel to set.
	 */
	public void setConfirmDel(String confirmDel) {
		if (confirmDel!=null && confirmDel.equals("true"))
			this.confirmDel = true;
		else 
			this.confirmDel = false;
	}
	
	
	/**
	 * @return Returns the usernameAttribute.
	 */
	public String getUsernameAttribute() throws PropertiesException {
		if (usernameAttribute==null) {
			log.error("getUsernameAttribute :: username attribute is not set");
			throw new PropertiesException();
		}
		return usernameAttribute;
	}
	
	/**
	 * @param usernameAttribute The usernameAttribute to set.
	 */
	public void setUsernameAttribute(String usernameAttribute) {
		this.usernameAttribute = usernameAttribute;
	}
	
	/**
	 * @return Returns the httpsRedirection.
	 */
	public boolean isHttpsRedirection() {
		return httpsRedirection;
	}
	/**
	 * @param httpsRedirection The httpsRedirection to set.
	 */
	public void setHttpsRedirection(String httpsRedirection) {
		if (httpsRedirection!=null && httpsRedirection.equals("true"))
			this.httpsRedirection = true;
		else 
			this.httpsRedirection = false;
	}
	
	/**
	 * @return Returns the invisibleRexexp.
	 */
	public Vector getInvisibleRegexp() throws PropertiesException {
		if (invisibleRegexp==null) {
			log.error("getInvisibleRegexp :: invisible regexp is not set");
			throw new PropertiesException();
		}
		return this.invisibleRegexp;
	}
	
	/**
	 * @param regexp The invisibleRexexp to set.
	 */
	public void addInvisibleRegexp(String regexp) {
		this.invisibleRegexp.add(regexp);
		
	}
	
	
	/**
	 * @return Returns the allowedRegexp.
	 */
	public String getAllowedRegexp() {
		return allowedRegexp;
	}
	/**
	 * @param allowedRegexp The allowedRegexp to set.
	 */
	public void setAllowedRegexp(String allowedRegexp) {
		this.allowedRegexp = allowedRegexp;
	}
}
