<?xml version='1.0' encoding='ISO-8859-1' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no"/>


<!--<xsl:variable name="baseActionURL"><xsl:value-of select="ROOT/baseActionURL" /></xsl:variable>-->
<xsl:param name="baseActionURL"/>


<xsl:template match="/ROOT">

		<script language="javascript">
		<![CDATA[

		
		function setPointer(theRow, theAction, thePointerStyle, theDefaultStyle) {
		    if (typeof(theRow.className) == 'undefined') {
				return false;
		    }

		    var newStyle = null;

			if(theAction == 'over') {
				newStyle = thePointerStyle;
			}
			if(theAction == 'out') {
				newStyle = theDefaultStyle;
			}

		    if (newStyle) {
		       theRow.className = newStyle;
			}
		    else {
				return false;
		    }
		    return true;
		}
		
		
		
		]]>
	</script>
	
	
	
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr>
		<td valign="top" align="center" width="50%">
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-light">
					<td class="uportal-channel-table-caption">Groupes disponibles</td>
				</tr>
				
				<tr>
					<td align="left" valign="top">
						<xsl:apply-templates select="group"/>
					</td>
				</tr>
				
			</table>
		</td>
		<td valign="top" align="center" width="50%">
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-light">
					<td class="uportal-channel-table-caption">Groupes slectionns</td>
				</tr>
				
				<tr>
					<td align="left" valign="top">
						<xsl:apply-templates select="selection"/>
					</td>
				</tr>
				
				<tr>
					<td align="left" valign="top">
						<form name="formgroup" action="{$baseActionURL}?modeDav=group_manager" method="post">
					
							<input type="hidden" name="exit_type" value=""/>
							
							<input class="uportal-button" type="button" value="Continuer avec la slection" onclick="document.formgroup.exit_type.value='ok';document.formgroup.submit();"/>
							<input class="uportal-button" type="button" value="Abandonner la slection" onclick="document.formgroup.exit_type.value='cancel';document.formgroup.submit();"/>
						</form>
					</td>
				</tr>
				
			</table>
		</td>
	</tr>	
</table>	
	
	<!-- table border="1" cellpadding="0" cellspacing="0" width="100%">
		
		<tr>
			<td valign="top">
				<span align="center">Groupes disponibles</span>
				<br/>
				
				<xsl:apply-templates select="group"/>
			</td>
			
			<td valign="top">
				<span align="center">Groupes slectionns</span>
				<br/>
				
				<xsl:apply-templates select="selection"/>
				
				<br/>
				<form name="formgroup" action="{$baseActionURL}?modeDav=group_manager" method="post">
					
					<input type="hidden" name="exit_type" value=""/>
					
					<input class="uportal-button" type="button" value="Continuer avec la slection" onclick="document.formgroup.exit_type.value='ok';document.formgroup.submit();"/>
					<input class="uportal-button" type="button" value="Abandonner la slection" onclick="document.formgroup.exit_type.value='cancel';document.formgroup.submit();"/>
				</form>
			</td>
		
		</tr>
		
	</table-->

</xsl:template>



<xsl:template match="group">
	
	<table border="0" cellpadding="0" cellspacing="0" width="100%">
		<tbody>
		
		<tr>
			<td colspan="2" width="100%">
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
				<tbody>
					<tr onmouseout="setPointer(this, 'out', 'uportal-background-highlight', 'BODY');" onmouseover="setPointer(this, 'over', 'uportal-background-highlight', 'BODY');">
						<td>
							<xsl:choose>
								<xsl:when test="@open='true'">
									<xsl:choose>
										<xsl:when test="@hasChild='true'">
											<a href="{$baseActionURL}?modeDav=group_manager&amp;close={@id}">
												<img title="Fermer groupe" alt="Fermer groupe" src="media/org/esupportail/portal/channels/CStockage/group_manager_expanded.gif" align="bottom" border="0" height="16" hspace="0" vspace="1" width="16"/>
											</a>
										</xsl:when>
										<xsl:otherwise>
											<img src="media/org/esupportail/portal/channels/CStockage/group_manager_empty.gif" align="bottom" border="0" height="16" hspace="0" vspace="1" width="16"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								
								<xsl:otherwise>
									<a href="{$baseActionURL}?modeDav=group_manager&amp;open={@id}">
										<img title="Ouvrir groupe" alt="Ouvrir groupe" src="media/org/esupportail/portal/channels/CStockage/group_manager_collapsed.gif" align="bottom" border="0" height="16" hspace="0" vspace="1" width="16"/>
									</a>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td>
							<img src="media/org/esupportail/portal/channels/CStockage/group_manager_transparent.gif" border="0" height="2" hspace="0" vspace="0" width="2"/>
						</td>
						<td width="100%">
							<xsl:choose>
								<xsl:when test="@open='true'">
									<xsl:choose>
										<xsl:when test="@hasChild='true'">
											<a href="{$baseActionURL}?modeDav=group_manager&amp;close={@id}">
												<span class="uportal-channel-table-row-even">
													<xsl:choose>
														<xsl:when test="@displayName!='root_entry'">
															<xsl:value-of select="@displayName" />
														</xsl:when>
														<xsl:otherwise>
															Les groupes
														</xsl:otherwise>
													</xsl:choose>
												</span>
											</a>
										</xsl:when>
										<xsl:otherwise>
											<span class="uportal-channel-table-row-even">
													<xsl:choose>
														<xsl:when test="@displayName!='root_entry'">
															<xsl:value-of select="@displayName" />
														</xsl:when>
														<xsl:otherwise>
															Les groupes
														</xsl:otherwise>
													</xsl:choose>
												</span>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								
								<xsl:otherwise>
									<a href="{$baseActionURL}?modeDav=group_manager&amp;open={@id}">
										<span class="uportal-channel-table-row-even">
											<xsl:choose>
												<xsl:when test="@displayName!='root_entry'">
													<xsl:value-of select="@displayName" />
												</xsl:when>
												<xsl:otherwise>
													Les groupes
												</xsl:otherwise>
											</xsl:choose>
										</span>
									</a>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td>
							<xsl:if test="@displayName!='root_entry' and @selected='false'">
								<a href="{$baseActionURL}?modeDav=group_manager&amp;add={@id}">
									<img title="Ajouter ce groupe" alt="Ajouter ce groupe" src="media/org/esupportail/portal/channels/CStockage/add_group.gif" border="0" height="15" hspace="0" vspace="0" width="19"/>
								</a>
							</xsl:if>
							<img src="media/org/esupportail/portal/channels/CStockage/group_manager_transparent.gif" border="0" height="2" hspace="0" vspace="0" width="20"/>
						</td>
					</tr>
				</tbody>
				</table>
			</td>
		</tr>
		
		<xsl:if test="@hasChild='true'">
			<tr>
				<td background="media/org/esupportail/portal/channels/CStockage/group_manager_dot.gif">
					<img src="media/org/esupportail/portal/channels/CStockage/group_manager_transparent.gif" height="5" width="16"/>
				</td>
				<td width="100%">
					<xsl:apply-templates/>
				</td>
			</tr>
		</xsl:if>
		
		</tbody>
	</table>
	
	
	
</xsl:template>







<xsl:template match="selection">
	
	<table border="0" cellpadding="0" cellspacing="0" width="100%">
		<tbody>
			<xsl:for-each select="selected_group">
				<tr onmouseout="setPointer(this, 'out', 'uportal-background-light', 'BODY');" onmouseover="setPointer(this, 'over', 'uportal-background-light', 'BODY');">
					<td width="100%">
						<img src="media/org/esupportail/portal/channels/CStockage/group_manager_transparent.gif" border="0" height="2" hspace="0" vspace="0" width="20"/>
						<span class="uportal-channel-table-row-even">
							<xsl:value-of select="@displayName" />
						</span>
					</td>
					<td>
						<a href="{$baseActionURL}?modeDav=group_manager&amp;delete={@id}">
							<img title="Retirer ce groupe" alt="Retirer ce groupe" src="media/org/esupportail/portal/channels/CStockage/delete_group_2.gif" border="0" height="20" hspace="0" vspace="0" width="13"/>
						</a>
						<img src="media/org/esupportail/portal/channels/CStockage/group_manager_transparent.gif" border="0" height="2" hspace="0" vspace="0" width="20"/>
					</td>
				</tr>
			</xsl:for-each>
			
		</tbody>
	</table>
	
	
	

</xsl:template>






</xsl:stylesheet>


   
   
   
   					
   
   
  

