/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.UnicodeString;
import jcifs.dcerpc.msrpc.LsaPolicyHandle;
import jcifs.dcerpc.msrpc.MsrpcLookupSids;
import jcifs.dcerpc.rpc;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbException;
import jcifs.util.Hexdump;

public class SID
extends rpc.sid_t {
    public static final int SID_TYPE_USE_NONE = 0;
    public static final int SID_TYPE_USER = 1;
    public static final int SID_TYPE_DOM_GRP = 2;
    public static final int SID_TYPE_DOMAIN = 3;
    public static final int SID_TYPE_ALIAS = 4;
    public static final int SID_TYPE_WKN_GRP = 5;
    public static final int SID_TYPE_DELETED = 6;
    public static final int SID_TYPE_INVALID = 7;
    public static final int SID_TYPE_UNKNOWN = 8;
    static final String[] SID_TYPE_NAMES = new String[]{"0", "User", "Domain group", "Domain", "Local group", "Builtin group", "Deleted", "Invalid", "Unknown"};
    static Map sid_cache = Collections.synchronizedMap(new HashMap());
    int type;
    String domainName = null;
    String acctName = null;
    String origin_server = null;
    NtlmPasswordAuthentication origin_auth = null;

    static void resolveSids(DcerpcHandle handle, LsaPolicyHandle policyHandle, SID[] sids) throws IOException {
        MsrpcLookupSids rpc2 = new MsrpcLookupSids(policyHandle, sids);
        handle.sendrecv(rpc2);
        switch (rpc2.retval) {
            case -1073741709: 
            case 0: 
            case 263: {
                break;
            }
            default: {
                throw new SmbException(rpc2.retval, false);
            }
        }
        for (int si = 0; si < sids.length; ++si) {
            sids[si].type = rpc2.names.names[si].sid_type;
            sids[si].domainName = null;
            switch (sids[si].type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int sid_index = rpc2.names.names[si].sid_index;
                    rpc.unicode_string ustr = rpc2.domains.domains[sid_index].name;
                    sids[si].domainName = new UnicodeString(ustr, false).toString();
                }
            }
            sids[si].acctName = new UnicodeString(rpc2.names.names[si].name, false).toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resolveSids0(String authorityServerName, NtlmPasswordAuthentication auth, SID[] sids) throws IOException {
        block4: {
            DcerpcHandle handle;
            block5: {
                handle = null;
                LsaPolicyHandle policyHandle = null;
                try {
                    handle = DcerpcHandle.getHandle("ncacn_np:" + authorityServerName + "[\\PIPE\\lsarpc]", auth);
                    policyHandle = new LsaPolicyHandle(handle, null, 2048);
                    SID.resolveSids(handle, policyHandle, sids);
                    Object var6_5 = null;
                    if (handle == null) break block4;
                    if (policyHandle == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (handle != null) {
                        if (policyHandle != null) {
                            policyHandle.close();
                        }
                        handle.close();
                    }
                    throw throwable;
                }
                policyHandle.close();
            }
            handle.close();
            {
            }
        }
    }

    public static void resolveSids(String authorityServerName, NtlmPasswordAuthentication auth, SID[] sids) throws IOException {
        int si;
        ArrayList<SID> list = new ArrayList<SID>(sids.length);
        for (si = 0; si < sids.length; ++si) {
            SID sid = (SID)sid_cache.get(sids[si]);
            if (sid != null) {
                sids[si].type = sid.type;
                sids[si].domainName = sid.domainName;
                sids[si].acctName = sid.acctName;
                continue;
            }
            list.add(sids[si]);
        }
        if (list.size() > 0) {
            sids = list.toArray(new SID[0]);
            SID.resolveSids0(authorityServerName, auth, sids);
            for (si = 0; si < sids.length; ++si) {
                sid_cache.put(sids[si], sids[si]);
            }
        }
    }

    public SID(byte[] src, int si) {
        this.revision = src[si++];
        this.sub_authority_count = src[si++];
        this.identifier_authority = new byte[6];
        System.arraycopy(src, si, this.identifier_authority, 0, 6);
        si += 6;
        if (this.sub_authority_count > 100) {
            throw new RuntimeException("Invalid SID");
        }
        this.sub_authority = new int[this.sub_authority_count];
        for (int i = 0; i < this.sub_authority_count; ++i) {
            this.sub_authority[i] = ServerMessageBlock.readInt4(src, si);
            si += 4;
        }
    }

    public SID(String textual) throws SmbException {
        StringTokenizer st = new StringTokenizer(textual, "-");
        if (st.countTokens() < 3 || !st.nextToken().equals("S")) {
            throw new SmbException("Bad textual SID format: " + textual);
        }
        this.revision = Byte.parseByte(st.nextToken());
        String tmp = st.nextToken();
        long id = 0L;
        id = tmp.startsWith("0x") ? Long.parseLong(tmp.substring(2), 16) : Long.parseLong(tmp);
        this.identifier_authority = new byte[6];
        int i = 5;
        while (id > 0L) {
            this.identifier_authority[i] = (byte)(id % 256L);
            id >>= 8;
            --i;
        }
        this.sub_authority_count = (byte)st.countTokens();
        if (this.sub_authority_count > 0) {
            this.sub_authority = new int[this.sub_authority_count];
            for (i = 0; i < this.sub_authority_count; ++i) {
                this.sub_authority[i] = (int)(Long.parseLong(st.nextToken()) & 0xFFFFFFFFL);
            }
        }
    }

    public SID(SID domsid, int rid) {
        this.revision = domsid.revision;
        this.identifier_authority = domsid.identifier_authority;
        this.sub_authority_count = (byte)(domsid.sub_authority_count + 1);
        this.sub_authority = new int[this.sub_authority_count];
        for (int i = 0; i < domsid.sub_authority_count; ++i) {
            this.sub_authority[i] = domsid.sub_authority[i];
        }
        this.sub_authority[i] = rid;
    }

    public int getType() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        return this.type;
    }

    public String getTypeText() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        return SID_TYPE_NAMES[this.type];
    }

    public String getDomainName() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        if (this.type == 8) {
            String full = this.toString();
            return full.substring(0, full.length() - this.getAccountName().length() - 1);
        }
        return this.domainName;
    }

    public String getAccountName() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        if (this.type == 8) {
            return "" + this.sub_authority[this.sub_authority_count - 1];
        }
        if (this.type == 3) {
            return "";
        }
        return this.acctName;
    }

    public int hashCode() {
        int hcode = this.identifier_authority[5];
        for (int i = 0; i < this.sub_authority_count; ++i) {
            hcode += 65599 * this.sub_authority[i];
        }
        return hcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SID) {
            SID sid = (SID)obj;
            if (sid == this) {
                return true;
            }
            if (sid.sub_authority_count == this.sub_authority_count) {
                int i = this.sub_authority_count;
                while (i-- > 0) {
                    if (sid.sub_authority[i] == this.sub_authority[i]) continue;
                    return false;
                }
                for (i = 0; i < 6; ++i) {
                    if (sid.identifier_authority[i] == this.identifier_authority[i]) continue;
                    return false;
                }
                return sid.revision == this.revision;
            }
        }
        return false;
    }

    public String toString() {
        String ret = "S-" + (this.revision & 0xFF) + "-";
        if (this.identifier_authority[0] != 0 || this.identifier_authority[1] != 0) {
            ret = ret + "0x";
            ret = ret + Hexdump.toHexString(this.identifier_authority, 0, 6);
        } else {
            long shift = 0L;
            long id = 0L;
            for (int i = 5; i > 1; --i) {
                id += ((long)this.identifier_authority[i] & 0xFFL) << (int)shift;
                shift += 8L;
            }
            ret = ret + id;
        }
        for (int i = 0; i < this.sub_authority_count; ++i) {
            ret = ret + "-" + ((long)this.sub_authority[i] & 0xFFFFFFFFL);
        }
        return ret;
    }

    public String toDisplayString() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        if (this.domainName != null) {
            String str = this.type == 3 ? this.domainName : (this.domainName == null || this.type == 5 || this.domainName.equals("BUILTIN") ? (this.type == 8 ? this.toString() : this.acctName) : this.domainName + "\\" + this.acctName);
            return str;
        }
        return this.toString();
    }

    void resolve(String authorityServerName, NtlmPasswordAuthentication auth) throws IOException {
        SID[] sids = new SID[]{this};
        SID.resolveSids(authorityServerName, auth, sids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveWeak() {
        if (this.origin_server != null) {
            try {
                this.resolve(this.origin_server, this.origin_auth);
            }
            catch (IOException iOException) {
            }
            finally {
                this.origin_server = null;
                this.origin_auth = null;
            }
        }
    }
}

