

import java.io.StringReader;
import java.util.ArrayList;

import org.apache.commons.digester.Digester;
import org.xml.sax.InputSource;

/**
 * Id: OldServerTool.java,v 1.0 5 janv. 2005
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: OldServerTool
 * Original Author: Yohan Colmant
 * Object used to manage a Space while the sharing of spaces by users
 */
public class OldServerTool {


	
	/**
	 * The Server we are using
	 */
	private OldServer server;
	
	
	
	

	/**
	 * Constructor
	 * @param stringToParse the String we want to parse
	 */
	public OldServerTool(String stringToParse) throws Exception {

		Digester digester = new Digester();
		digester.setValidating(false);
		digester.push(this);		
		
		/*
		 * The space
		 */
		

		// SERVER
		digester.addObjectCreate("SERVER",OldServer.class);		
		
		digester.addSetProperties("SERVER","url", "url");
		digester.addSetProperties("SERVER","unauthenticatedServerUrl", "unauthenticatedServerUrl");
		digester.addSetProperties("SERVER","injacPreviewUrl", "injacPreviewUrl");
		digester.addSetProperties("SERVER","injacFinalUrl", "injacFinalUrl");
		digester.addSetProperties("SERVER","serverType", "serverType");
		digester.addSetProperties("SERVER","authenticationMode", "authenticationMode");
		digester.addSetProperties("SERVER","login", "initialLoginFromTheConfigurationFile");
		digester.addSetProperties("SERVER","password", "password");
		
		digester.addSetProperties("SERVER","aclNamespace", "aclNamespace");
		digester.addSetProperties("SERVER","aclUserPrefix", "aclUserPrefix");
		digester.addSetProperties("SERVER","aclGroupPrefix", "aclGroupPrefix");
		digester.addSetProperties("SERVER","aclUportalGroup", "aclUportalGroup");
		
		digester.addSetProperties("SERVER","cifsDomain", "cifsDomain");
		digester.addSetProperties("SERVER","cifsResolveOrder", "cifsResolveOrder");
		digester.addSetProperties("SERVER","cifsDisablePlainTextPassword", "cifsDisablePlainTextPassword");
		digester.addSetProperties("SERVER","cifsUseUnicode", "cifsUseUnicode");
		digester.addSetProperties("SERVER","cifsEncoding", "cifsEncoding");
		
		digester.addSetProperties("SERVER","nfsUidNumber", "nfsUidNumber");
		digester.addSetProperties("SERVER","nfsGidNumber", "nfsGidNumber");

		// SPACE
		digester.addObjectCreate("SERVER/SPACE",OldSpace.class);		
		
		digester.addSetProperties("SERVER/SPACE","key", "key");
		digester.addSetProperties("SERVER/SPACE","label", "label");
		digester.addSetProperties("SERVER/SPACE","path", "path");
		digester.addSetProperties("SERVER/SPACE","pathRegexp", "pathRegexp");
		digester.addSetProperties("SERVER/SPACE","pathRegexpSeparator", "pathRegexpSeparator");
		digester.addSetProperties("SERVER/SPACE","actionType", "actionType");
		
		digester.addSetProperties("SERVER/SPACE","sharing", "sharing");
		digester.addSetProperties("SERVER/SPACE","aclSecurity", "aclSecurity");
		
		// ALLOWED
		digester.addObjectCreate("SERVER/SPACE/ALLOWED",OldAuthorizationSpaceParameter.class);
		digester.addSetProperties("SERVER/SPACE/ALLOWED");		
		
		
		digester.addSetNext("SERVER/SPACE/ALLOWED", "setAuthorization");
		digester.addSetNext("SERVER/SPACE", "addSpace");
		digester.addSetNext("SERVER", "addServer");
		
		
		
		StringReader sr = new StringReader(stringToParse);		
		InputSource inSource = new InputSource(sr);

		//parse config file
		digester.parse(inSource);							
	}
	
	
	

	/**
	 * return the server
	 * @return the server
	 */
	public OldServer getServer() throws Exception {	

		
			
		ArrayList spacesOfServer = server.getSpaces();
		
		// we return the result
		//if (spacesOfServer.size()==0) {
			//log.error("getServer :: there is no space set - spaces is empty");
			//throw new PropertiesException();
		//}
		//else {
			
			for (int j=0; j<spacesOfServer.size(); j++) {
				OldSpace space = (OldSpace)spacesOfServer.get(j);
				space.setServer(server);
			}
			//return spacesOfServer;
		//}
			
		
		return server;
	}

	

	
	/**
	 * return the spaces list
	 * @return the spaces list
	 */
	public ArrayList getSpaces() throws Exception {
		return getServer().getSpaces();
	}
	
	

	/**
	 * add a new server to the list
	 * @param server the server to add
	 */
	public void addServer(OldServer server) throws Exception {
		this.server = server;
	}
	
	
	
	
	
	
	
	
	
	
	
	
}
