

import java.util.ArrayList;
import java.util.Vector;


/**
 * Id: Space.java,v 1.0 9 juil. 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: Space<br/>
 * Original Author: Yohan Colmant<br/>
 * This represents a file space on the server<br/>
 */
public class OldSpace {


	
	/**
	 * The server object for this space
	 */
	private OldServer server;
	
	
	
	/**
	 * The space key
	 */
	private String key;
	
	/**
	 * The label of this space
	 */
	private String label;

	/**
	 * The path in the initial configuration file
	 */
	private String initialPathFromTheConfigurationFile;

	/**
	 * The regexp used to apply on the path
	 */
	private String pathRegexp;

	/**
	 * The separator used when the regexp is in few parts
	 */
	private String pathRegexpSeparator;

	/**
	 * The currentPath used
	 */
	private Vector currentPath = new Vector();
	
	/**
	 * The channel action type
	 */
	private String actionType;
	
	
	
		
	
	
	
	/**
	 * If the administrator allow users to share documents
	 */
	private String sharing;
	
	
	/**
	 * The authorization list for this space
	 */
	private ArrayList authorizations = new ArrayList();
	
	
	
	
	
	/**
	 * If this space is a personnal one
	 */
	private boolean personnalSpace = false;
	
	
	
	/**
	 * The group for the acl security
	 */
	private String aclSecurity;
	/**
	 * @param aclSecurity The aclSecurity to set.
	 */
	public void setAclSecurity(String aclSecurity) {
		this.aclSecurity = aclSecurity;
	}
	/**
	 * @return Returns the aclSecurity.
	 */
	public String getAclSecurity() {
		return aclSecurity;
	}
	
	
	
	
	
	/**
	 * @return Returns the server.
	 */
	public OldServer getServer() {
		return server;
	}
	/**
	 * @param server The server to set.
	 */
	public void setServer(OldServer server) {
		this.server = server;
	}
	


	
	/**
	 * return the authorization list
	 * @return the authorization list
	 */
	public ArrayList getAuthorization() {			
		return authorizations;
	}

	/**
	 * add a new authorization to the list
	 * @param authorization the authorization to add
	 */
	public void setAuthorization(OldAuthorizationSpaceParameter authorization) {		
		// add this authorization
		authorizations.add(authorization);
	}
	
	

	
	
	/**
	 * @return Returns the actionType.
	 */
	public String getActionType() {
		return actionType;
	}
	/**
	 * @param actionType The actionType to set.
	 */
	public void setActionType(String actionType) {
		this.actionType = actionType;
	}
	
	
	
	
	
	
	/**
	 * @return Returns the key.
	 */
	public String getKey() {
		return key;
	}
	
	/**
	 * @param key The key to set.
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * @return Returns the label.
	 */
	public String getLabel() {
		return label;
	}
	
	/**
	 * @param label The label to set.
	 */
	public void setLabel(String label) {
		this.label = label;
	}
	
	
	
	
	
	/**
	 * @return Returns the pathRegexp.
	 */
	public String getPathRegexp() {
		return pathRegexp;
	}
	/**
	 * @param pathRegexp The pathRegexp to set.
	 */
	public void setPathRegexp(String pathRegexp) {
		this.pathRegexp = pathRegexp;
	}
	/**
	 * @return Returns the pathRegexpSeparator.
	 */
	public String getPathRegexpSeparator() {
		return pathRegexpSeparator;
	}
	/**
	 * @param pathRegexpSeparator The pathRegexpSeparator to set.
	 */
	public void setPathRegexpSeparator(String pathRegexpSeparator) {
		this.pathRegexpSeparator = pathRegexpSeparator;
	}
	
	
	
	/**
	 * @param path The path to set.
	 */
	public void setPath(String path) {
		
		this.initialPathFromTheConfigurationFile = path;
		
		// set the vector
		currentPath = initPath(path);
	}

	
	
	/**
	 * @param path The path to set.
	 */
	private Vector initPath(String path) {
		
		// set the vector
		Vector currentPath = new Vector();		
		
		String initPath = new String(path);		
		if (initPath.startsWith("/"))
			initPath = initPath.substring(1, initPath.length());		
		if (initPath.endsWith("/"))
			initPath = initPath.substring(0, initPath.length()-1);
				
		// we add it to the currentPath
		currentPath.addElement(initPath);	
		
		return currentPath;
	}
	
	
	
	/**
	 * @return Returns the path.
	 */
	public String getCurrentPath() {	
		return getPath(currentPath);				
	}
	
	
	
	/**
	 * @return Returns the parent path until the space root
	 */
	public String getParentPathUntilSpaceRoot() {	
		int size = this.getPathSize();
		if (size == 1)
			return null;
		else
			return getParentPath(currentPath);				
	}
	
	/**
	 * @return Returns the space root path
	 */
	public String getSpaceRootPath() {	
		return (String)this.currentPath.elementAt(0);		
	}

	
	
	
	/**
	 * @return Returns the parent path.
	 */
	public String getParentPath() {	
		String path = getCurrentPath();
		String[] p = path.split("/");
		String s = "";
		
		// if we are at the root
		if (path.trim().equals("/")) {
			return null;
		}
		
		// if we are not at the root
		for (int i=0; i<p.length-1; i++) {
			s+=p[i]+"/";
		}
		
		return s;	
	}

	

	/**
	 * Get the path from an initial path, without first and last slashes
	 * @param path the path to transform
	 * @return the path without first and last slashes
	 */
	public static String getPathWithoutFirstAndLastSlash(String path) {
		String s = null;
		
		// if the path starts with "/"
		if (path.startsWith("/")) {
			s = path.substring(1);
		}
		else {
			s = path;
		}
		
		// if the path ends with "/"		
		if (s.endsWith("/")) {
			s = s.substring(0, s.length()-1);
		}
		
		return s;
	}
	
	
	
	/**
	 * @return Returns the path.
	 */
	public String getPath() {	
		return this.initialPathFromTheConfigurationFile;				
	}
	
	
	/**
	 * Return the path due to a current path vector
	 * @param currentPath
	 * @return the space current path
	 */
	private String getParentPath(Vector currentPath) {
		StringBuffer pathh = new StringBuffer("/"); 
		for (int i=0; i<currentPath.size()-1; i++) {
			String s = (String)currentPath.elementAt(i);
			if (!s.equals("")) {
				pathh.append(s);
				pathh.append("/");
			}			
		}
		
		return pathh.toString();	
	}
	
	/**
	 * Return the path due to a current path vector
	 * @param currentPath
	 * @return the space current path
	 */
	private String getPath(Vector currentPath) {
		StringBuffer pathh = new StringBuffer("/"); 
		for (int i=0; i<currentPath.size(); i++) {
			String s = (String)currentPath.elementAt(i);
			if (!s.equals("")) {
				pathh.append(s);
				pathh.append("/");
			}			
		}
		
		return pathh.toString();	
	}
	
	
	
	
	
	
	
	/**
	 * Add a path element to the current directory
	 * @param pathElement
	 */
	public void addPathElement(String pathElement) {
		this.currentPath.add(pathElement);
	}
	
	/**
	 * Remove an element from the current path
	 * @param index
	 */
	public void removePathElement(int index) {
		this.currentPath.remove(index);
	}
	
	/**
	 * Return the path size
	 * @return the size
	 */
	public int getPathSize() {
		return currentPath.size();
	}
	
	
	/**
	 * Check if we are at the root of the space
	 * @return true if we are at the root, else false
	 */
	public boolean isCurrentPathAtRoot() {
		return getPathSize()==1;
	}
	
		
	/**
	 * Return the current element path at the good index
	 * @param index the selected index
	 * @return a string
	 */
	public String getPathElementAt(int index) {
		if (index == 0)
			return this.label;
		else return (String)this.currentPath.elementAt(index);
	}
		
	
	

	
	

	/**
	 * @param sharing The allowsSharing to set.
	 */
	public void setSharing(String sharing) {
		this.sharing = sharing;
	}
	/**
	 * @return Returns the enableSharing.
	 */
	/*public String getEnableSharing() {
		return enableSharing;
	}*/
	
	
	
	
	/**
	 * Return a String representation of this space
	 */
	public String toString() {
		return 
		"key: "+key+"\n"+
		"label: "+label+"\n"+
		"path: "+getCurrentPath()+"\n";
	}
	
	
	
	
	/**
	 * Compare this to another object
	 * @param o object to compare
	 */
	public boolean equals(Object o) {
		
		OldSpace s = (OldSpace)o;
		/*
		boolean thisIsPersonal = this.isPersonnalSpace();
		boolean sIsPersonal = s.isPersonnalSpace();
		
		if(thisIsPersonal && sIsPersonal) {
			return this.getIdInDatabase().equals(s.getIdInDatabase());
		}
		else {		
			return this.key.equals(((Space)o).getKey());
		}*/
		if (this.key == null) {
			if (s.key==null) {
				return true;
			}
			else {
				return false;
			}
		}
		else {
			if (s.key==null) {
				return false;
			}
			else {
				return this.key.equals(s.getKey());
			}
		}
		
	}
	
	
	
	
	
	/**
	 * Clone this object
	 * @return a clone of this object
	 */
	public Object cloneWithoutServer() {
		OldSpace clone = new OldSpace();
		
		clone.key = this.key;
		clone.label = this.label;
	
		clone.actionType = this.actionType;
		
		clone.sharing = this.sharing;
		
		clone.initialPathFromTheConfigurationFile = this.initialPathFromTheConfigurationFile;
		clone.pathRegexp = this.pathRegexp;
		clone.pathRegexpSeparator = this.pathRegexpSeparator;
		
		clone.currentPath = (Vector)this.currentPath.clone();
		
		
		clone.authorizations = new ArrayList();
		for (int i=0; i<this.authorizations.size(); i++) {
			clone.authorizations.add(((OldAuthorizationSpaceParameter)this.authorizations.get(i)).clone());
		}
		
		clone.personnalSpace = this.personnalSpace;
		
		return clone;
	}
	

	
	/**
	 * Clone this object
	 * @return a clone of this object
	 */
	public Object clone() {
		OldServer originalServer = this.getServer();
		ArrayList originalSpaces = originalServer.getSpaces();
		
		int originalIndexOfThisInServer = -1;
		for (int i=0; originalIndexOfThisInServer==-1 && i<originalSpaces.size(); i++) {
			if (this==(OldSpace)originalSpaces.get(i)) {
				originalIndexOfThisInServer = i;
			}
		}
		
		if (originalIndexOfThisInServer != -1) {
			OldServer clonedServer = (OldServer)originalServer.clone();
			OldSpace clonedSpace = (OldSpace)clonedServer.getSpaces().get(originalIndexOfThisInServer);
			
			return clonedSpace;
		}
		else {
			OldServer clonedServer = (OldServer)originalServer.clone();
			OldSpace clonedSpace = (OldSpace)cloneWithoutServer();
			clonedSpace.setServer(clonedServer);
			
			return clonedSpace;
		}
	}
	
	
	
	
	/**
	 * Get the xml in the configuration file style
	 * @return the xml in the configuration file style
	 */
	public StringBuffer getLocalXml() {
		

		StringBuffer xmlSpace = new StringBuffer();		
		xmlSpace.append("<SPACE");
	
		// key
		if (key!=null && !key.trim().equals("")) {
			xmlSpace.append(" key=\""+key+"\"\n");
		}
		
		// label
		if (label!=null && !label.trim().equals("")) {
			xmlSpace.append(" label=\""+label+"\"\n");
		}
		
		// path
		String path = getCurrentPath();
		if (path!=null && !path.trim().equals(""))
			xmlSpace.append(" path=\""+path+"\"\n");

		// pathRegexp
		if (pathRegexp!=null && !pathRegexp.trim().equals(""))
			xmlSpace.append(" pathRegexp=\""+pathRegexp+"\"\n");

		// pathRegexpSeparator
		if (pathRegexpSeparator!=null && !pathRegexpSeparator.trim().equals(""))
			xmlSpace.append(" pathRegexpSeparator=\""+pathRegexpSeparator+"\"\n");

		// actionType
		if (actionType!=null && !actionType.trim().equals(""))
			xmlSpace.append(" actionType=\""+actionType+"\"\n");

		// sharing
		if (sharing!=null && !sharing.trim().equals("")) {
			if (sharing.equals("true"))
				xmlSpace.append(" sharing=\""+"complex"+"\"\n");
			if (sharing.equals("false"))
				xmlSpace.append(" sharing=\""+"none"+"\"\n");
		}

		xmlSpace.append(">\n");
		
		// ALLOWED
		xmlSpace.append("<AUTHORIZATION operator=\"or\">\n");
		for (int i=0; i<this.authorizations.size(); i++) {
			OldAuthorizationSpaceParameter auth = (OldAuthorizationSpaceParameter)this.authorizations.get(i);
			xmlSpace.append(auth.getXml()+"\n");
		}
		xmlSpace.append("</AUTHORIZATION>\n");
		
		xmlSpace.append("</SPACE>\n");
		
		return xmlSpace;
		
	}
	
	
	

	/**
	 * Get the xml in the configuration file style
	 * @return the xml in the configuration file style
	 */
	public String getXml() {
		
		StringBuffer xmlSpace = new StringBuffer();		
		
		xmlSpace.append(this.server.getLocalXmlBegin());
		
		xmlSpace.append(this.getLocalXml());
		
		xmlSpace.append(this.server.getLocalXmlEnd());
			
		return xmlSpace.toString();
		
	}
}
