<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no"/>

<!--<xsl:variable name="baseActionURL"><xsl:value-of select="ROOT/baseActionURL" /></xsl:variable>-->
<xsl:param name="baseActionURL"/>
<xsl:param name="downloadURL"/>  


<xsl:template name="_content">
	
	<script language="javascript">
		<![CDATA[

		function submitDirectory(directoryLink) {		
			document.goIntoDirectory.targetDirectory.value=directoryLink;
			document.goIntoDirectory.submit();
		}
		
		function submitFile(fileLink) {						
			document.downloadFile.downloadFile.value=fileLink;
			document.downloadFile.submit();
		}
		
		
		
		
		function setPointer(theRow, theAction, thePointerStyle, theDefaultStyle) {
		    if (typeof(theRow.className) == 'undefined') {
				return false;
		    }

		    var newStyle = null;

			if(theAction == 'over') {
				newStyle = thePointerStyle;
			}
			if(theAction == 'out') {
				newStyle = theDefaultStyle;
			}

		    if (newStyle) {
		       theRow.className = newStyle;
			}
		    else {
				return false;
		    }
		    return true;
		}
		
		
		
		]]>
	</script>
	
		
	<table width="100%" border="0" cellspacing="3" cellpadding="0">
		
		<!-- Title line -->
		<tr class="uportal-background-light"> 
			<td width="1">
				&#160;
			</td>
			<td width="1">
				<nobr>
					<span>&#160;</span>
					<xsl:choose>
						<xsl:when test="/ROOT/CONTENT/@sort='sort_type'">
							<a class="uportal-channel-table-header" href="{$baseActionURL}?sort=sort_type_reverse">
								Type
								<span>&#160;</span>
								<img src="media/org/esupportail/portal/channels/CStockage/file_sort.gif" border="0"/>
							</a>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="/ROOT/CONTENT/@sort='sort_type_reverse'">
									<a class="uportal-channel-table-header" href="{$baseActionURL}?sort=sort_type">
										Type
										<span>&#160;</span>
										<img src="media/org/esupportail/portal/channels/CStockage/file_sort_reverse.gif" border="0"/>
									</a>
								</xsl:when>
								<xsl:otherwise>
									<a class="uportal-channel-table-header" href="{$baseActionURL}?sort=sort_type">
										Type
									</a>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<span>&#160;</span>
				</nobr>	
			</td>
			
			<xsl:if test="/ROOT/PREVIEW/@link!=''">
			<td width="5%" align="center">
				<nobr>
					<span>&#160;</span>
					<text class="uportal-channel-table-header">
						Voir
					</text>
					<span>&#160;</span>
				</nobr>	
			</td>
			</xsl:if>
			
			
			<td width="75%">
				<nobr>
					<span>&#160;</span>
					<xsl:choose>
						<xsl:when test="/ROOT/CONTENT/@sort='sort_name'">
							<a class="uportal-channel-table-header" href="{$baseActionURL}?sort=sort_name_reverse">
								Nom du fichier
								<span>&#160;</span>
								<img src="media/org/esupportail/portal/channels/CStockage/file_sort.gif" border="0"/>
							</a>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="/ROOT/CONTENT/@sort='sort_name_reverse'">
									<a class="uportal-channel-table-header" href="{$baseActionURL}?sort=sort_name">
										Nom du fichier
										<span>&#160;</span>
										<img src="media/org/esupportail/portal/channels/CStockage/file_sort_reverse.gif" border="0"/>
									</a>
								</xsl:when>
								<xsl:otherwise>
									<a class="uportal-channel-table-header" href="{$baseActionURL}?sort=sort_name">
										Nom du fichier
									</a>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<span>&#160;</span>
				</nobr>					
			</td>
			

			<td width="10%">
				<nobr>
					<span>&#160;</span>
					<xsl:choose>
						<xsl:when test="/ROOT/CONTENT/@sort='sort_weight'">
							<a class="uportal-channel-table-header" href="{$baseActionURL}?sort=sort_weight_reverse">
								Taille
								<span>&#160;</span>
								<img src="media/org/esupportail/portal/channels/CStockage/file_sort.gif" border="0"/>
							</a>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="/ROOT/CONTENT/@sort='sort_weight_reverse'">
									<a class="uportal-channel-table-header" href="{$baseActionURL}?sort=sort_weight">
										Taille
										<span>&#160;</span>
										<img src="media/org/esupportail/portal/channels/CStockage/file_sort_reverse.gif" border="0"/>
									</a>
								</xsl:when>
								<xsl:otherwise>
									<a class="uportal-channel-table-header" href="{$baseActionURL}?sort=sort_weight">
										Taille
									</a>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<span>&#160;</span>
				</nobr>	
			</td>
			<td width="15%">					
				<nobr>
					<span>&#160;</span>
					<xsl:choose>
						<xsl:when test="/ROOT/CONTENT/@sort='sort_date'">
							<a class="uportal-channel-table-header" href="{$baseActionURL}?sort=sort_date_reverse">
								<!-- Dernire Modif. -->Date de cration
								<span>&#160;</span>
								<img src="media/org/esupportail/portal/channels/CStockage/file_sort.gif" border="0"/>
							</a>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="/ROOT/CONTENT/@sort='sort_date_reverse'">
									<a class="uportal-channel-table-header" href="{$baseActionURL}?sort=sort_date">
										<!-- Dernire Modif. -->Date de cration
										<span>&#160;</span>
										<img src="media/org/esupportail/portal/channels/CStockage/file_sort_reverse.gif" border="0"/>
									</a>
								</xsl:when>
								<xsl:otherwise>
									<a class="uportal-channel-table-header" href="{$baseActionURL}?sort=sort_date">
										<!-- Dernire Modif. -->Date de cration
									</a>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<span>&#160;</span>
				</nobr>	
			</td>
		</tr>
		
		
		<!-- Resource line -->
		<xsl:for-each select="/ROOT/CONTENT/RESOURCE">							
			<!-- tr bgColor="#F8F8F8" class="BODY" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');" onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" --> 
			<tr bgColor="#F8F8F8" onmouseout="setPointer(this, 'out', 'uportal-background-highlight', 'BODY');" onmouseover="setPointer(this, 'over', 'uportal-background-highlight', 'BODY');"> 
				
				<!-- The checkbox -->
				<td width="1">			
					<input type="checkbox" name="listeFic" value="{@link}"/>
				</td>
				
				<!-- The type -->
				<td align="center">
					<center>					
					<xsl:choose>
					
						<xsl:when test="@type!='directory'">
							<a class="uportal-navigation-channel" href="javascript:submitFile('{@link}');">
								<img src="media/org/esupportail/portal/channels/CStockage/file2_24px.gif" border="0"/>					
							</a>
						</xsl:when>
						
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="@state='published'">							
									<xsl:choose>
										<xsl:when test="@default='true'">
											<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CStockage/injac/folder_green_default_24px.gif" border="0"/></a>
										</xsl:when>
										<xsl:otherwise>
											<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CStockage/injac/folder_green_24px.gif" border="0"/></a>
										</xsl:otherwise>
									</xsl:choose>							
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@state='rejected'">							
											<xsl:choose>
												<xsl:when test="@default='true'">
													<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CStockage/injac/folder_red_default_24px.gif" border="0"/></a>
												</xsl:when>
												<xsl:otherwise>
													<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CStockage/injac/folder_red_24px.gif" border="0"/></a>
												</xsl:otherwise>
											</xsl:choose>									
										</xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="@state='waiting'">							
													<xsl:choose>
														<xsl:when test="@default='true'">
															<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CStockage/injac/folder_orange_default_24px.gif" border="0"/></a>
														</xsl:when>
														<xsl:otherwise>
															<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CStockage/injac/folder_orange_24px.gif" border="0"/></a>
														</xsl:otherwise>
													</xsl:choose>												
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="@state='expired'">
															<xsl:choose>
																<xsl:when test="@default='true'">
																	<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CStockage/injac/folder_gray_default_24px.gif" border="0"/></a>
																</xsl:when>
																<xsl:otherwise>
																	<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CStockage/injac/folder_gray_24px.gif" border="0"/></a>
																</xsl:otherwise>
															</xsl:choose>																				
														</xsl:when>
														<xsl:otherwise>
																<xsl:choose>
																	<xsl:when test="@state='space'">							
																		<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CStockage/injac/folder_blue_24px.gif" border="0"/></a>
																	</xsl:when>
																	<xsl:otherwise>
																		<a href="javascript:submitDirectory('{@link}');"><img src="media/org/esupportail/portal/channels/CStockage/folder_yellow_24px.gif" border="0"/></a>						
																	</xsl:otherwise>
																</xsl:choose>
														</xsl:otherwise>
													</xsl:choose>							
												</xsl:otherwise>
											</xsl:choose>							
										</xsl:otherwise>
									</xsl:choose>									
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
						
					</xsl:choose>
					</center>					
				</td>
				
				<!-- The preview -->
				<xsl:if test="/ROOT/PREVIEW/@link!=''">
					<td align="center">
						<xsl:choose>
							<xsl:when test="(@state='published') or (@state='rejected') or (@state='waiting') or (@state='expired')">
								<a target="_blank" href="{/ROOT/PREVIEW/@link}{@link}">
									<img src="media/org/esupportail/portal/channels/CStockage/injac/preview_24px.gif" border="0"/>
								</a>
							</xsl:when>
							<xsl:otherwise>	
								&#160;
							</xsl:otherwise>
						</xsl:choose>	
					</td>
				</xsl:if>
				
				<!-- The name -->
				<td>					
					<xsl:choose>
										
						<xsl:when test="@type!='directory'">
							&#160;<a class="uportal-navigation-channel" href="javascript:submitFile('{@link}');"><xsl:value-of select="@label"/></a>
						</xsl:when>
						
						<xsl:otherwise>
							&#160;<a class="uportal-navigation-channel" href="javascript:submitDirectory('{@link}');"><xsl:value-of select="@label"/></a>
						</xsl:otherwise>
					
					</xsl:choose>					
				</td>
				
				
			
				<!-- The weight -->
				<td align="right" class="uportal-crumbtrail">
					<xsl:choose>
										
						<xsl:when test="@type!='directory'">
							&#160;<xsl:value-of select="@weight"/>
						</xsl:when>
						
						<xsl:otherwise>
							&#160;
						</xsl:otherwise>
					
					</xsl:choose>
				</td>
				
				<!-- The date -->
				<td align="right" class="uportal-crumbtrail">
					&#160;<xsl:value-of select="@dateLastUpdate"/>-<xsl:value-of select="@monthLastUpdate"/>-<xsl:value-of select="@yearLastUpdate"/>&#160;<xsl:value-of select="@hourLastUpdate"/>:<xsl:value-of select="@minuteLastUpdate"/>
				</td>
			</tr>		
		</xsl:for-each>
		
		
		
		</table>
	
</xsl:template>
</xsl:stylesheet>