/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.channelAction.classic.sharing;


import org.esupportail.portal.channels.CStockage.spacesPersonalization.target.UserForPersonalization;

/**
 * Id: SharedSpaceProperties.java,v 1.0 15 avr. 2005
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: SharedSpaceProperties
 * Original Author: Yohan Colmant
 * 
 */
public class SharedSpaceProperties {

	
	/**
	 * The person who shared
	 */
	private String fromKey;
	
	/**
	 * The display name of the target
	 */
	//private String targetDisplayName;
	
	/**
	 * The user if shared for a user
	 */
	private UserForPersonalization user;
	
	/**
	 * The space root path
	 */
	private String spaceRootPath;
	

	/**
	 * If this space is used in the personalization
	 */
	private boolean used;
	
	/**
	 * The user's temp label
	 */
	private String labelTemp;
	
	
	/**
	 * CONSTRUCTOR
	 *
	 */
	public SharedSpaceProperties() {
		
	}
	
	
	
	
	/**
	 * @return Returns the spaceRootPath.
	 */
	public String getSpaceRootPath() {
		return spaceRootPath;
	}
	/**
	 * @param spaceRootPath The spaceRootPath to set.
	 */
	public void setSpaceRootPath(String spaceRootPath) {
		this.spaceRootPath = spaceRootPath;
	}
	/**
	 * @param spaceRootPath The spaceRootPath to set.
	 */
	/*public void initSpaceRootPath() {
		this.spaceRootPath = spaceRootPath;
		boolean isRoot = false;
		if (!currentSpace.isPersonnalSpace()) {
			this.spaceRootPath = currentSpace.getSpaceRootPath();
		}
		else {
			
		}
	}*/
	
	/**
	 * @return Returns the fromKey.
	 */
	public String getFromKey() {
		return fromKey;
	}
	/**
	 * @param fromKey The fromKey to set.
	 */
	public void setFromKey(String fromKey) {
		this.fromKey = fromKey;
	}
	
	/**
	 * @return Returns the user.
	 */
	public UserForPersonalization getUser() {
		return user;
	}
	/**
	 * @param user The user to set.
	 */
	public void setUser(UserForPersonalization user) {
		this.user = user;
	}
	
	

	
	
	/**
	 * @return Returns the targetDisplayName.
	 */
	/*public String getTargetDisplayName() {
		return targetDisplayName;
	}*/
	/**
	 * @param targetDisplayName The targetDisplayName to set.
	 */
	/*public void setTargetDisplayName(String targetDisplayName) {
		this.targetDisplayName = targetDisplayName;
	}*/
	
	
	


	/**
	 * @return the used
	 */
	public boolean isUsed() {
		return used;
	}

	/**
	 * @param used the used to set
	 */
	public void setUsed(boolean used) {
		this.used = used;
	}
	
	
	
	
	

	/**
	 * @return the labelTemp
	 */
	public String getLabelTemp() {
		return labelTemp;
	}

	/**
	 * @param labelTemp the labelTemp to set
	 */
	public void setLabelTemp(String labelTemp) {
		this.labelTemp = labelTemp;
	}



	/**
	 * Clone this object to another similary one
	 * @return this cloned object
	 */
	public Object clone() {
		SharedSpaceProperties clone = new SharedSpaceProperties();
		clone.setFromKey(this.fromKey);
		//clone.setTargetDisplayName(this.targetDisplayName);
		if (this.getUser()!=null) {
			clone.setUser((UserForPersonalization)this.getUser().clone());
		}
		clone.setSpaceRootPath(this.getSpaceRootPath());
		
		clone.setLabelTemp(this.getLabelTemp());
		clone.used = this.used;
		
		return clone;
	}
	
	
}
