/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.channelAction.injac.actions;

import java.util.ArrayList;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.channelAction.BufferAction;
import org.esupportail.portal.channels.CStockage.channelAction.injac.DirectoryProperties;
import org.esupportail.portal.channels.CStockage.channelAction.injac.ChannelAction;
import org.esupportail.portal.channels.CStockage.channelAction.injac.DefaultRenderXml;
import org.esupportail.portal.channels.CStockage.channelAction.injac.metadata.MetaDataConstants;
import org.esupportail.portal.channels.CStockage.channelAction.injac.metadata.MetaDataManager;
import org.esupportail.portal.channels.CStockage.config.Space;
import org.esupportail.portal.channels.CStockage.exception.CancelException;
import org.esupportail.portal.channels.CStockage.exception.InjacDocumentException;
import org.esupportail.portal.channels.CStockage.exception.NoneSelectedResourceException;
import org.esupportail.portal.channels.CStockage.exception.NotAuthorizedModifyMetadataException;
import org.esupportail.portal.channels.CStockage.exception.UnpublishException;
import org.esupportail.portal.channels.CStockage.exception.ChannelException;
import org.jasig.portal.ChannelRuntimeData;

/**
 * Id: DocumentUnpublicationAction.java,v 1.0 27 oct. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: DocumentUnpublicationAction
 * Original Author: Yohan Colmant
 * Action for the document unpublication
 */
public class DocumentUnpublicationAction {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(DocumentUnpublicationAction.class);
	
	


	/**
	 * Generate the XML when we ask an unpublication confirmation
	 * @param runtimeData the channel runtimedata object
	 * @param buffer the buffer used for the clipboard
	 * @param stylesheet the channel stylesheet we are going to use
	 * @param metadataToSet the metatada list we want to set
	 * @param userPortalLogin the user portal login
	 * @param userGroups the user portal groups
	 * @param currentSpace the current space
	 * @param directoryProperties the current directory properties
	 * @return the XML String for this mod
	 * @throws ChannelException
	 */
	public static StringBuffer renderXmlConfirmUnpublish(ChannelRuntimeData runtimeData, BufferAction buffer, StringBuffer stylesheet, Vector metadatasToSet, String userPortalLogin, Vector userGroups, Space currentSpace, DirectoryProperties directoryProperties) throws ChannelException {
		
		String[] files = runtimeData.getParameterValues("listeFic");

		// Xml generated
		StringBuffer xml = new StringBuffer();
		
		// if not selected
		if (files == null || files.length==0) {						
			NoneSelectedResourceException e = new NoneSelectedResourceException();

			// log
			if (log.isDebugEnabled()){
				log.debug("renderXmlConfirmUnpublish"+" :: NoneSelectedResourceException");
			}
			
			throw e;			
		}
		
		// if too much selected
		/*if (files.length>1) {			
			TooMuchSelectedException e = new TooMuchSelectedException();

			// log
			if (log.isDebugEnabled()){
				log.debug("renderXmlConfirmUnpublish"+" :: TooMuchSelectedException");
			}
			
			throw e;			
		}*/
		
		for (int i=0; i<files.length; i++) {
			
			// if one resource selected
			String selectionName = files[i];
			String selectionPath = currentSpace.getCurrentPath();
			String selectionFullPath = selectionPath+selectionName;
			
			// check if the resource is an injac document
			String documentType = MetaDataManager.getDirectoryType(currentSpace, selectionFullPath);
			if (documentType.equals(MetaDataConstants.INJAC_TYPE_DOCUMENT)) {
						
				
				// check if the resource state is "published"
				String documentState = MetaDataManager.getDocumentState(currentSpace, selectionFullPath);
				if (documentState.equals(MetaDataConstants.DOCUMENT_PUBLISHED_STATE)) {
					
					// check if we are editor in space, or we are the document owner
					boolean isEditor = directoryProperties.isUserEditor();
					if (isEditor) {
						selectionName = selectionName.replaceAll("&","&amp;");
						selectionName = selectionName.replaceAll("\"","&#148;");
						selectionPath = selectionPath.replaceAll("&","&amp;");
						selectionPath = selectionPath.replaceAll("\"","&#148;");
						
						xml.append("<DOCUMENT name=\""+selectionName+"\" path=\""+selectionPath+"\"  />");
					}
					else {
						boolean isOwner = ChannelAction.isUserDocumentOwner(selectionFullPath, currentSpace, userPortalLogin);
						if (isOwner) {
							selectionName = selectionName.replaceAll("&","&amp;");
							selectionName = selectionName.replaceAll("\"","&#148;");
							selectionPath = selectionPath.replaceAll("&","&amp;");
							selectionPath = selectionPath.replaceAll("\"","&#148;");
							
							xml.append("<DOCUMENT name=\""+selectionName+"\" path=\""+selectionPath+"\"  />");
						}
						else {
							NotAuthorizedModifyMetadataException e = new NotAuthorizedModifyMetadataException();
	
							// log
							if (log.isDebugEnabled()){
								log.debug("renderXmlConfirmUnpublish"+" :: NotAuthorizedModifyMetadataException");
							}
							
							throw e;
						}					
					}
					
					/*selectionName = selectionName.replaceAll("&","&amp;");
					selectionName = selectionName.replaceAll("\"","&#148;");
					selectionPath = selectionPath.replaceAll("&","&amp;");
					selectionPath = selectionPath.replaceAll("\"","&#148;");
					
					xml.append("<DOCUMENT name=\""+selectionName+"\" path=\""+selectionPath+"\"  />");*/
				}
				
				else {			
					InjacDocumentException e = new InjacDocumentException();
	
					// log
					if (log.isDebugEnabled()){
						log.debug("renderXmlConfirmUnpublish"+" :: InjacDocumentException");
					}
					
					throw e;				
				}						
				
			}
			
			else {
				InjacDocumentException e = new InjacDocumentException();
	
				// log
				if (log.isDebugEnabled()){
					log.debug("renderXmlConfirmUnpublish"+" :: InjacDocumentException");
				}
				
				throw e;			
			}		
		}
	
		return xml;		
	
	}
	
	
	
	
	/**
	 * Generate the XML String and unpublish the document
	 * @param runtimeData the runtime data channel object
	 * @param stylesheet the stylesheet we are about to use
	 * @param spaces the default spaces
	 * @param metadataToSet the metadata list we want to set
	 * @param userPortalLogin the user portal login
	 * @param userGroups the user portal groups
	 * @param currentSpace the current space
	 * @param directoryProperties the current directory properties
	 * @param currentSortType The current and default sort type for the resources
	 * @return the XML String for this mod
	 * @throws ChannelException
	 */
	public static StringBuffer unpublish(ChannelRuntimeData runtimeData, StringBuffer stylesheet, ArrayList spaces, Vector metadatasToSet, String userPortalLogin, Vector userGroups, Space currentSpace, DirectoryProperties directoryProperties, String currentSortType) throws ChannelException {
		String submit = runtimeData.getParameter("Submit_un");
		
		// if submit
		if (submit != null) {					
			String[] selectionName = runtimeData.getParameterValues("documentName");
			String[] selectionPath = runtimeData.getParameterValues("documentPath");
			
			boolean wellDone = true;
			for (int i=0; i<selectionName.length; i++) {
				String selectionFullPath = selectionPath[i]+selectionName[i];
				
				wellDone = wellDone && MetaDataManager.setDirectoryAsWaitingDocument(currentSpace, selectionFullPath);
			}
			if (wellDone)
				return DefaultRenderXml.getXml(spaces, currentSpace, null, "2013", userPortalLogin, userGroups, directoryProperties, currentSortType);
			else {
				UnpublishException e = new UnpublishException();

				// log
				if (log.isDebugEnabled()){
					log.debug("unpublish"+" :: UnpublishException");
				}
				
				throw e;
			}
		}
		
		// if cancel
		else {			
			CancelException e = new CancelException();

			// log
			if (log.isDebugEnabled()){
				log.debug("unpublish"+" :: CancelException");
			}
			
			throw e;
		}				
				
	}
	
	
	
	
}
