/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.spacesPersonalization.target;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.Personne;
import org.esupportail.portal.channels.CStockage.exception.PropertiesException;
import org.esupportail.portal.channels.CStockage.userManagement.User;

/**
 * Id: UserForPersonalization.java,v 1.0 7 oct. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: UserForPersonalization
 * Original Author: Yohan Colmant
 * Represents a user for the management during the personalization
 */
public class UserForPersonalization extends User {
 

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(UserForPersonalization.class);
	
	/**
	 * Object used for the personalization
	 */
	private Personalization personalization;

	private boolean localUser = true;
	
	
	
	/**
	 * Default constructor
	 */
	public UserForPersonalization() {
		personalization = new Personalization();
	}
	
	
	/**
	 * Constructor
	 * @param key The key
	 * @param displayName The displayed user name
	 */
	public UserForPersonalization(String key, String displayName) {
		super(key, displayName);
		personalization = new Personalization();
	}
	
	

	/**
	 * Constructor
	 * @param key The key
	 */
	public UserForPersonalization(String key) throws PropertiesException {
		super(key);
		personalization = new Personalization();
	}
	
	
	/**
	 * Constructor
	 * @param pers The retrieved people
	 */
	public UserForPersonalization(Personne pers) throws PropertiesException {
		super(pers);
		personalization = new Personalization();
	}
	
	
	
	
	
	/**
	 * @return Returns the personalization.
	 */
	public Personalization getPersonalization() {
		return personalization;
	}
	
	
	
	
	
	/**
	 * @return the localUser
	 */
	public boolean isLocalUser() {
		return localUser;
	}


	/**
	 * @param localUser the localUser to set
	 */
	public void setLocalUser(boolean localUser) {
		this.localUser = localUser;
	}


	/**
	 * Clone this object to another similary one
	 * @return this cloned object
	 */
	public Object clone() {
		UserForPersonalization clone = new UserForPersonalization();
		clone.setKey(this.getKey());
		clone.setDisplayName(this.getDisplayName());
		clone.personalization = (Personalization)this.personalization.clone();
		clone.localUser = this.localUser;
		return clone;
	}
	
	
	/**
	 * Compare this object to another one
	 */
	public boolean equals(Object o) {
		UserForPersonalization comp = (UserForPersonalization)o;
		
		return comp.key.equals(this.key) && comp.getPersonalization().equals(this.getPersonalization());
	}
	
	
	
	

	/**
	 * Return a String from this user
	 * @return a String from this user
	 */
	public String toString() {
		return super.toString()+" "+personalization.toString();
	}
}
