/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.portal.utils.webdav.acl;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.properties.AclProperty;
import org.esupportail.portal.utils.webdav.acl.EsupPermission;
import org.esupportail.portal.utils.webdav.acl.EsupPermissions;
import org.esupportail.portal.utils.webdav.acl.exception.ReadAclException;
import org.esupportail.portal.utils.webdav.acl.exception.WriteAclException;

public class ACLManager {
    protected static final Log log = LogFactory.getLog(ACLManager.class);
    public static final String DEFAULT_SLIDE_USER_PREFIX = "/slide/users/";
    public static final String DEFAULT_SLIDE_GROUP_PREFIX = "/slide/roles/";
    public static final String DEFAULT_SLIDE_NAMESPACE = "DAV:";
    private WebdavResource webDavResource;
    private String namespace;
    private String userPrefix;
    private String groupPrefix;
    private String securityGroup;
    private Hashtable tempPermissions;

    public ACLManager(WebdavResource webDavResource, String userPrefix, String groupPrefix, String securityGroup) {
        this(webDavResource, DEFAULT_SLIDE_NAMESPACE, userPrefix, groupPrefix, securityGroup);
    }

    public ACLManager(WebdavResource webDavResource, String namespace, String userPrefix, String groupPrefix, String securityGroup) {
        this.webDavResource = webDavResource;
        this.namespace = namespace;
        this.userPrefix = userPrefix;
        this.groupPrefix = groupPrefix;
        this.securityGroup = securityGroup;
        this.tempPermissions = new Hashtable();
    }

    public EsupPermissions getPermissions(String path) throws IOException, ReadAclException {
        AclProperty acl = this.webDavResource.aclfindMethod(path);
        Ace[] aces = null;
        if (acl == null) {
            log.error((Object)"tools::webdav::acl --> can't get the permissions, Ace[] is null");
            throw new ReadAclException();
        }
        aces = acl.getAces();
        return new EsupPermissions(aces, this.userPrefix, this.groupPrefix, this.securityGroup);
    }

    public EsupPermissions getPermissionsTemp(String path) throws IOException, ReadAclException {
        EsupPermissions perms = (EsupPermissions)this.tempPermissions.get(path);
        if (perms == null) {
            perms = this.getPermissions(path);
            this.tempPermissions.put(path, perms);
        }
        return perms;
    }

    public EsupPermissions getPermissions(String path, String permissionType) throws IOException, ReadAclException {
        AclProperty acl = this.webDavResource.aclfindMethod(path);
        Ace[] aces = null;
        if (acl == null) {
            log.error((Object)"tools::webdav::acl --> can't get the permissions, Ace[] is null");
            throw new ReadAclException();
        }
        aces = acl.getAces();
        return new EsupPermissions(aces, permissionType, this.userPrefix, this.groupPrefix, this.securityGroup);
    }

    private void setPermissions(String path, EsupPermissions perms) throws IOException, WriteAclException {
        Ace[] aces = perms.getSortedAceArray();
        boolean success = this.webDavResource.aclMethod(path, aces);
        if (!success) {
            log.error((Object)"tools::webdav::acl --> can't set the permissions");
            throw new WriteAclException();
        }
    }

    public void initTemporaryWorkingPermissions(String path, EsupPermissions perms) {
        if (perms == null) {
            this.tempPermissions.remove(path);
        } else {
            this.tempPermissions.put(path, perms);
        }
    }

    public void fixPermissions(String path) throws IOException, WriteAclException, ReadAclException {
        EsupPermissions perms = this.getPermissionsTemp(path);
        if (perms != null) {
            this.setPermissions(path, perms);
        }
        this.initTemporaryWorkingPermissions(path, null);
    }

    public void revoke(String path, String principal, String permissionType, boolean fixNow) throws IOException, ReadAclException, WriteAclException {
        if (fixNow) {
            EsupPermissions perms = this.getPermissions(path);
            boolean found = perms.remove(false, principal, permissionType);
            boolean bl = found = found || perms.remove(true, principal, permissionType);
            if (!found && log.isErrorEnabled()) {
                log.debug((Object)"tools::webdav::acl --> can't revoke the permissions, permission not found");
            }
            this.setPermissions(path, perms);
        } else {
            EsupPermissions perms = this.getPermissionsTemp(path);
            boolean found = perms.remove(false, principal, permissionType);
            boolean bl = found = found || perms.remove(true, principal, permissionType);
            if (!found && log.isErrorEnabled()) {
                log.debug((Object)"tools::webdav::acl --> can't revoke the permissions, permission not found");
            }
        }
    }

    public void revokeAllPermissons(String path, boolean fixNow) throws IOException, ReadAclException, WriteAclException {
        if (fixNow) {
            EsupPermissions perms = new EsupPermissions();
            this.setPermissions(path, perms);
        } else {
            EsupPermissions perms = new EsupPermissions();
            this.initTemporaryWorkingPermissions(path, perms);
        }
    }

    private void addACL(String path, String principal, String permissionType, boolean negative, boolean fixNow) throws IOException, ReadAclException, WriteAclException {
        EsupPermission permToAdd = new EsupPermission(negative, principal, permissionType, false, null, false, this.namespace, this.userPrefix, this.groupPrefix, this.securityGroup);
        if (fixNow) {
            this.revoke(path, principal, permissionType, true);
            EsupPermissions perms = this.getPermissions(path);
            perms.add(permToAdd);
            this.setPermissions(path, perms);
        } else {
            EsupPermissions perms = this.getPermissionsTemp(path);
            this.revoke(path, principal, permissionType, false);
            perms.add(permToAdd);
        }
    }

    public void grant(String path, String principal, String permissionType, boolean fixNow) throws IOException, ReadAclException, WriteAclException {
        this.addACL(path, principal, permissionType, false, fixNow);
    }

    public void deny(String path, String principal, String permissionType, boolean fixNow) throws IOException, ReadAclException, WriteAclException {
        this.addACL(path, principal, permissionType, true, fixNow);
    }

    public Vector hasInheritedPermission(String path, String principal, String permissionType, boolean negative) throws IOException, ReadAclException {
        EsupPermissions perms = this.getPermissions(path);
        EsupPermission perm = new EsupPermission(negative, principal, permissionType, true, null, false, this.namespace, this.userPrefix, this.groupPrefix, this.securityGroup);
        return perms.contains(perm);
    }

    public boolean hasNotInheritedPermission(String path, String principal, String permissionType, boolean negative) throws IOException, ReadAclException {
        EsupPermission perm;
        EsupPermissions perms = this.getPermissions(path);
        return perms.contains(perm = new EsupPermission(negative, principal, permissionType, false, null, false, this.namespace, this.userPrefix, this.groupPrefix, this.securityGroup)) != null;
    }

    public void listPermissions(EsupPermissions perms) {
        System.out.println("Liste des ACL");
        System.out.println(perms);
        System.out.println();
    }

    public void listNotInheritedPermissions(EsupPermissions perms) {
        System.out.println("Liste des ACL");
        Iterator iter = perms.iterator();
        while (iter.hasNext()) {
            EsupPermission perm = (EsupPermission)iter.next();
            if (perm.isInherited()) continue;
            System.out.println(" *** " + perm);
        }
        System.out.println();
    }

    public void listPermissions(String path) throws HttpException, IOException, Exception {
        System.out.println("ACL sur " + path);
        EsupPermissions perms = this.getPermissions(path);
        System.out.println(perms);
        System.out.println();
    }

    public void listPermissions(String path, String permissionType) throws HttpException, IOException, Exception {
        System.out.println("ACL sur " + path);
        EsupPermissions perms = this.getPermissions(path, permissionType);
        System.out.println(perms);
        System.out.println();
    }

    public void listNotInheritedPermissions(String path) throws IOException, Exception {
        System.out.println("ACL sur " + path);
        EsupPermissions perms = this.getPermissions(path);
        Iterator iter = perms.iterator();
        while (iter.hasNext()) {
            EsupPermission perm = (EsupPermission)iter.next();
            if (perm.isInherited()) continue;
            System.out.println(" *** " + perm);
        }
        System.out.println();
    }
}

