/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.ArrayList;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.cache.AbstractMetaCache;
import org.apache.ojb.broker.cache.CacheFilter;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.RuntimeCacheException;

public class CacheFilterRegistry
extends AbstractMetaCache {
    private ArrayList filterList = new ArrayList();
    private ObjectCache realCache;

    public CacheFilterRegistry(ObjectCache realCache) {
        this.realCache = realCache;
    }

    protected void addCacheFilter(CacheFilter filter) {
        this.filterList.add(filter);
    }

    public ObjectCache getCache(Identity oid, Object obj, int callingMethod) {
        return this.checkFilterList(callingMethod, oid, obj) ? this.realCache : null;
    }

    public void clear() {
        this.realCache.clear();
    }

    private boolean checkFilterList(int callingMethod, Identity oid, Object obj) {
        boolean result = true;
        if (callingMethod == 1) {
            for (int i = this.filterList.size() - 1; i >= 0; --i) {
                boolean bl = result = result && ((CacheFilter)this.filterList.get(i)).beforeCache(oid, obj);
                if (result) continue;
                return false;
            }
        } else if (callingMethod == 2) {
            for (int i = this.filterList.size() - 1; i >= 0; --i) {
                boolean bl = result = result && ((CacheFilter)this.filterList.get(i)).beforeLookup(oid);
                if (result) continue;
                return false;
            }
        } else if (callingMethod == 3) {
            for (int i = this.filterList.size() - 1; i >= 0; --i) {
                boolean bl = result = result && ((CacheFilter)this.filterList.get(i)).beforeRemove(oid);
                if (result) continue;
                return false;
            }
        } else {
            throw new RuntimeCacheException("Unkown filter method id: " + callingMethod);
        }
        return result;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        buf.append(" - used filters", (Object)this.filterList).append(" - underlying ObjectCache", (Object)this.realCache);
        return buf.toString();
    }
}

