/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.IdentityFactory;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;

public class IdentityFactoryImpl
implements IdentityFactory {
    private PersistenceBroker broker;

    public IdentityFactoryImpl(PersistenceBroker broker) {
        this.broker = broker;
    }

    public Identity buildIdentity(Object obj) {
        return new Identity(obj, this.broker);
    }

    public Identity buildIdentity(ClassDescriptor cld, Object obj) {
        return new Identity(obj, this.broker, cld);
    }

    public Identity buildIdentity(Class realClass, Class topLevelClass, String[] pkFieldNames, Object[] pkValues) {
        FieldDescriptor[] flds;
        Object[] orderedPKValues = pkValues;
        if (pkValues == null) {
            throw new NullPointerException("Given primary key value array can't be null");
        }
        if ((pkValues.length != 1 || pkFieldNames != null && pkFieldNames.length != 1) && !this.isOrdered(flds = this.broker.getClassDescriptor(realClass).getPkFields(), pkFieldNames)) {
            orderedPKValues = this.reorderPKValues(flds, pkFieldNames, pkValues);
        }
        return new Identity(realClass, topLevelClass, orderedPKValues);
    }

    private Object[] reorderPKValues(FieldDescriptor[] flds, String[] pkFieldNames, Object[] pkValues) {
        String fieldName = null;
        Object[] orderedPKValues = new Object[flds.length];
        for (int i = 0; i < flds.length; ++i) {
            fieldName = flds[i].getPersistentField().getName();
            int realPosition = this.findFieldName(pkFieldNames, fieldName);
            orderedPKValues[i] = pkValues[realPosition];
        }
        return orderedPKValues;
    }

    private int findFieldName(String[] fieldNames, String searchName) {
        for (int i = 0; i < fieldNames.length; ++i) {
            if (!searchName.equals(fieldNames[i])) continue;
            return i;
        }
        throw new PersistenceBrokerException("Can't find field name '" + searchName + "' in given array of field names");
    }

    private boolean isOrdered(FieldDescriptor[] flds, String[] pkFieldNames) {
        if (flds.length > 1 && pkFieldNames == null || flds.length != pkFieldNames.length) {
            throw new PersistenceBrokerException("pkFieldName length does not match number of defined PK fields. Expected number of PK fields is " + flds.length + ", given number was " + (pkFieldNames != null ? pkFieldNames.length : 0));
        }
        boolean result = true;
        for (int i = 0; i < flds.length; ++i) {
            FieldDescriptor fld = flds[i];
            result = result && fld.getPersistentField().getName().equals(pkFieldNames[i]);
        }
        return result;
    }

    public Identity buildIdentity(Class realClass, String[] pkFieldNames, Object[] pkValues) {
        return this.buildIdentity(realClass, this.broker.getTopLevelClass(realClass), pkFieldNames, pkValues);
    }

    public Identity buildIdentity(Class realClass, Object pkValue) {
        return this.buildIdentity(realClass, null, new Object[]{pkValue});
    }
}

