/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.OutputStream;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.TransCallNamedPipe;
import jcifs.smb.TransCallNamedPipeResponse;
import jcifs.smb.TransTransactNamedPipe;
import jcifs.smb.TransTransactNamedPipeResponse;
import jcifs.smb.TransWaitNamedPipe;
import jcifs.smb.TransWaitNamedPipeResponse;

class TransactNamedPipeOutputStream
extends OutputStream {
    private String path;
    private SmbNamedPipe pipe;
    private byte[] tmp = new byte[1];
    private boolean dcePipe;

    TransactNamedPipeOutputStream(SmbNamedPipe pipe) throws IOException {
        this.pipe = pipe;
        this.dcePipe = (pipe.pipeType & 0x600) == 1536;
        this.path = pipe.unc;
    }

    public void close() throws IOException {
        this.pipe.close();
    }

    public void write(int b) throws IOException {
        this.tmp[0] = (byte)b;
        this.write(this.tmp, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            len = 0;
        }
        if ((this.pipe.pipeType & 0x100) == 256) {
            this.pipe.send(new TransWaitNamedPipe(this.path), new TransWaitNamedPipeResponse());
            this.pipe.send(new TransCallNamedPipe(this.path, b, off, len), new TransCallNamedPipeResponse(this.pipe));
        } else if ((this.pipe.pipeType & 0x200) == 512) {
            this.pipe.open(this.pipe.pipeType & 0xFF | 0x20, this.pipe.pipeType >>> 16, 128, 0);
            TransTransactNamedPipe req = new TransTransactNamedPipe(this.pipe.fid, b, off, len);
            if (this.dcePipe) {
                req.maxDataCount = 1024;
            }
            this.pipe.send(req, new TransTransactNamedPipeResponse(this.pipe));
        }
    }
}

