/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/ 
package org.esupportail.portal.channels.CStockage.spacesPersonalization;

import java.util.Enumeration;
import java.util.Vector;

import org.esupportail.portal.channels.CStockage.config.ServerConstants;
import org.esupportail.portal.channels.CStockage.config.Space;
import org.esupportail.portal.channels.CStockage.spacesPersonalization.target.GroupForPersonalization;
import org.esupportail.portal.channels.CStockage.spacesPersonalization.target.OtherPrincipalForPersonalization;
import org.esupportail.portal.channels.CStockage.spacesPersonalization.target.UserForPersonalization;

 

/**
 * Id: DirectorySharingProperties,v 1.0 6 janv. 2005
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: DirectorySharingProperties
 * Original Author: Yohan Colmant
 * This object represents the sharing properties of a directory
 */
public class DirectorySharingProperties {

	/**
	 * The directory full name
	 */
	private String directoryName;

	/**
	 * The label for the sharing
	 */
	//private String label;
	
	/**
	 * The users to who we share the directory
	 */
	private Vector<UserForPersonalization> users;

	/**
	 * The groups to who we share the directory
	 */
	private Vector<GroupForPersonalization> groups;

	/**
	 * The others principals to who we share the directory
	 */
	private Vector others;

	/**
	 * The others inherited to who we share the directory
	 */
	private Vector inherited;
	
	/**
	 * If there is a deny all all in the sharing
	 */
	private boolean useInheritedPrivileges;
	

	/**
	 * If there is a grant all read in the sharing
	 */
	private boolean isPublicDirectory;
	
	
	/**
	 * Constructor
	 * @param directoryName the current directory name
	 */
	public DirectorySharingProperties(String directoryName) {
		this.directoryName = directoryName;
		
		//this.sharedSpace = new Space();
		
		this.users = new Vector<UserForPersonalization>();
		this.groups = new Vector<GroupForPersonalization>();
		this.others = new Vector();
		this.inherited = new Vector();
		
		this.useInheritedPrivileges = true;
		this.useInheritedPrivileges = false;
	}
	
	
	
	/**
	 * Clone this object to another similary one
	 * @return this cloned object
	 */
	public Object clone() {
		DirectorySharingProperties clone = new DirectorySharingProperties(this.directoryName);
		
		// clone the space
		//Server originalServer = this.getSharedSpace().getServer();
		//Server cloneServer = (Server)originalServer.clone();
		//Space originalSpace = this.getSharedSpace();
		//Space cloneSpace = (Space)originalSpace.clone();
		//ArrayList cloneSpacesList = new ArrayList(1);
		//cloneSpacesList.add(cloneSpace);
		//cloneServer.setSpaces(cloneSpacesList);
		//cloneSpace.setServer(cloneServer);
		//clone.setSharedSpace(cloneSpace);
		
		Vector newUsers = new Vector();		
		Enumeration iter = this.getUsers().elements();
		while (iter.hasMoreElements()) {
			UserForPersonalization element = (UserForPersonalization)iter.nextElement();
			newUsers.addElement(element.clone());			
		}
		clone.setUsers(newUsers);
		
		Vector newGroups = new Vector();		
		iter = this.getGroups().elements();
		while (iter.hasMoreElements()) {
			GroupForPersonalization element = (GroupForPersonalization)iter.nextElement();
			newGroups.addElement(element.clone());			
		}
		clone.setGroups(newGroups);
		
		Vector newOthers = new Vector();		
		iter = this.getOthers().elements();
		while (iter.hasMoreElements()) {
			OtherPrincipalForPersonalization element = (OtherPrincipalForPersonalization)iter.nextElement();
			newOthers.addElement(element.clone());			
		}
		clone.setOthers(newOthers);
		
		Vector newInherited = new Vector();		
		iter = this.getInherited().elements();
		while (iter.hasMoreElements()) {
			Object o = iter.nextElement();
			if (o instanceof UserForPersonalization) {
				UserForPersonalization element = (UserForPersonalization)o;
				newInherited.addElement(element.clone());
			}
			else if (o instanceof GroupForPersonalization) {
				GroupForPersonalization element = (GroupForPersonalization)o;
				newInherited.addElement(element.clone());
			}
			else {
				OtherPrincipalForPersonalization element = (OtherPrincipalForPersonalization)o;
				newInherited.addElement(element.clone());
			}
		}
		clone.setInherited(newInherited);
		
		clone.setUseInheritedPrivileges((this.useInheritedPrivileges));
		clone.setPublicDirectory((this.isPublicDirectory));
		
		return clone;
	}
	
	
	
	
	/**
	 * @return Returns the label.
	 */
	/*public String getLabel() {
		return label;
	}*/
	/**
	 * @param label The label to set.
	 */
	/*public void setLabel(String label) {
		this.label = label;
	}*/
	/**
	 * @param directoryName The directoryName to set.
	 */
	
	
	public void setDirectoryName(String directoryName) {
		this.directoryName = directoryName;
	}
	
	
	
	
	/**
	 * @return Returns the isShared.
	 */
	public boolean isSharingActive() {		
		return true;
		//return !(users.isEmpty() && groups.isEmpty());
	}
	
	
	
	
	/**
	 * @return Returns the groups.
	 */
	public Vector<GroupForPersonalization> getGroups() {
		return groups;
	}
	/**
	 * @param groups The groups to set.
	 */
	public void setGroups(Vector groups) {
		this.groups = groups;
	}
	
	
	
	/**
	 * @return Returns the users.
	 */
	public Vector<UserForPersonalization> getUsers() {
		return users;
	}
	/**
	 * @param users The users to set.
	 */
	public void setUsers(Vector users) {
		this.users = users;
	}
	
	
	
	
	/**
	 * @return Returns the others.
	 */
	public Vector getOthers() {
		return others;
	}
	/**
	 * @param others The others to set.
	 */
	public void setOthers(Vector others) {
		this.others = others;
	}
	
	
	
	/**
	 * @return Returns the inherited.
	 */
	public Vector getInherited() {
		return inherited;
	}
	/**
	 * @param inherited The inherited to set.
	 */
	public void setInherited(Vector inherited) {
		this.inherited = inherited;
	}
	
	
	
	/**
	 * @return Returns the useInheritedPrivileges.
	 */
	public boolean useInheritedPrivileges() {
		return useInheritedPrivileges;
	}
	/**
	 * @param useInheritedPrivileges The useInheritedPrivileges to set.
	 */
	public void setUseInheritedPrivileges(boolean useInheritedPrivileges) {
		this.useInheritedPrivileges = useInheritedPrivileges;
	}
	/**
	 * @param useInheritedPrivileges The useInheritedPrivileges to set.
	 */
	public void setUseInheritedPrivileges(String useInheritedPrivileges) {
		if (useInheritedPrivileges.equals("true"))
				this.useInheritedPrivileges = true;
		else this.useInheritedPrivileges = false;
	}
	
	
	
	/**
	 * @return Returns the isPublicDirectory.
	 */
	public boolean isPublicDirectory() {
		return isPublicDirectory;
	}
	/**
	 * @param isPublicDirectory The isPublicDirectory to set.
	 */
	public void setPublicDirectory(boolean isPublicDirectory) {
		this.isPublicDirectory = isPublicDirectory;
	}
	/**
	 * @param isPublicDirectory The isPublicDirectory to set.
	 */
	public void setPublicDirectory(String isPublicDirectory) {
		if (isPublicDirectory.equals("true"))
			this.isPublicDirectory = true;
		else this.isPublicDirectory = false;
	}
	
	
	/**
	 * Get an xml form from a user
	 * @return an xml form a user
	 */
	private String getXmlForUser(UserForPersonalization user) {
		String displayName = user.getDisplayName();
		displayName = displayName.replace("&","&amp;");
		displayName = displayName.replace("\"","&quot;");
		displayName = displayName.replace(">","&gt;");
		displayName = displayName.replace("<","&lt;");
		return "<user key=\""+user.getKey()+"\" name=\""+displayName+"\" local=\""+user.isLocalUser()+"\" read=\""+user.getPersonalization().getReading()+"\" write=\""+user.getPersonalization().getWriting()+"\" manage=\""+user.getPersonalization().getSharing()+"\" obliged=\""+user.getPersonalization().isObliged()+"\" modifiable=\""+user.getPersonalization().isModifiable()+"\" visible=\""+user.getPersonalization().isVisible()+"\" inheritedFrom=\""+user.getPersonalization().getInheritedFrom()+"\" inherited=\""+user.getPersonalization().isInheritedAcl()+"\"/>\n";
	}
	
	/**
	 * Get an xml form from a group
	 * @return an xml form a group
	 */
	private String getXmlForGroup(GroupForPersonalization group) {
		String displayName = group.getDisplayName();
		displayName = displayName.replace("&","&amp;");
		displayName = displayName.replace("\"","&quot;");
		displayName = displayName.replace(">","&gt;");
		displayName = displayName.replace("<","&lt;");
		return "<group key=\""+group.getKey()+"\" name=\""+displayName+"\" read=\""+group.getPersonalization().getReading()+"\" write=\""+group.getPersonalization().getWriting()+"\" manage=\""+group.getPersonalization().getSharing()+"\" obliged=\""+group.getPersonalization().isObliged()+"\" modifiable=\""+group.getPersonalization().isModifiable()+"\" visible=\""+group.getPersonalization().isVisible()+"\" inheritedFrom=\""+group.getPersonalization().getInheritedFrom()+"\" inherited=\""+group.getPersonalization().isInheritedAcl()+"\"/>\n";
	}
	
	/**
	 * Get an xml form from an other principal
	 * @return an xml form an other principal
	 */
	private String getXmlForOther(Object o) {
		OtherPrincipalForPersonalization other = (OtherPrincipalForPersonalization)o;
		String displayName = other.getDisplayName();
		displayName = displayName.replace("&","&amp;");
		displayName = displayName.replace("\"","&quot;");
		displayName = displayName.replace(">","&gt;");
		displayName = displayName.replace("<","&lt;");
		return "<other key=\""+other.getKey()+"\" name=\""+displayName+"\" read=\""+other.getPersonalization().getReading()+"\" write=\""+other.getPersonalization().getWriting()+"\" manage=\""+other.getPersonalization().getSharing()+"\" obliged=\""+other.getPersonalization().isObliged()+"\" modifiable=\""+"false"+"\" visible=\""+other.getPersonalization().isVisible()+"\" inheritedFrom=\""+other.getPersonalization().getInheritedFrom()+"\"/>\n";
	}
	
	
	/**
	 * Get an xml form from this sharing properties
	 * @return an xml form from this sharing properties
	 */
	public StringBuffer getXml(String label, Space currentSpace) {

		//TODO s'occuper de sharingType
		
		StringBuffer xml = new StringBuffer();
		
		boolean isRoot = false;
		if (currentSpace!=null) {
			if (currentSpace.getCurrentPath()!=null) {
				String currentPath = Space.getPathWithoutFirstAndLastSlash(currentSpace.getCurrentPath());
				if (currentSpace.getCurrentViewer()!=null) {
					String rootPath = currentSpace.getCurrentViewer().getSpaceRootPath();
					if (rootPath!=null) {
						rootPath = Space.getPathWithoutFirstAndLastSlash(rootPath);
						if (currentPath.equals(rootPath)) {
							isRoot = true;
						}
					}
					else {
						if (currentSpace.getPathSize()==1)
							isRoot = true;
						else isRoot = false;
					}
				}
			}
		}
		xml.append("<space_root value=\""+isRoot+"\" />\n");
		
		xml.append("<directory name=\""+directoryName+"\" />\n");
		
		label = label.replace("&","&amp;");
		label = label.replace("\"","&quot;");
		label = label.replace(">","&gt;");
		label = label.replace("<","&lt;");
		xml.append("<label>"+label+"</label>\n");
		
		//String aclSecurity = currentSpace.getServer().getAclSecurity();
		
		StringBuffer xmlUsers = new StringBuffer();
		boolean manageShib = currentSpace.isManageShibUsers();
		xmlUsers.append("<users manageShib=\""+manageShib+"\">\n");		
		Enumeration u = users.elements();
		while (u.hasMoreElements()) {			
			UserForPersonalization user = (UserForPersonalization)u.nextElement();
			//if (aclSecurity!=null && !aclSecurity.equals(user.getKey()))
				xmlUsers.append(getXmlForUser(user));
		}				
		xmlUsers.append("</users>\n");
		
		StringBuffer xmlGroups = new StringBuffer();
		xmlGroups.append("<groups>\n");
		Enumeration g = groups.elements();
		while (g.hasMoreElements()) {
			GroupForPersonalization group = (GroupForPersonalization)g.nextElement();
			//if (aclSecurity!=null && !aclSecurity.equals(group.getGroupHierarchyasString()))
				xmlGroups.append(getXmlForGroup(group));
		}				
		xmlGroups.append("</groups>\n");				
		
		StringBuffer xmlOthers = new StringBuffer();
		xmlOthers.append("<others available=\""+currentSpace.isEditOthersAcl()+"\">\n");		
		u = others.elements();
		while (u.hasMoreElements()) {			
			xmlOthers.append(getXmlForOther(u.nextElement()));
		}				
		xmlOthers.append("</others>\n");
		
		// inheritance
		StringBuffer xmlInherited = new StringBuffer();
		if (currentSpace!=null) {
			xmlInherited.append("<inheritance type=\""+currentSpace.getSharing()+"\">\n");	
			
			xmlInherited.append("<inherited>\n");	
			u = inherited.elements();
			while (u.hasMoreElements()) {			
				String x = null;
				Object o = u.nextElement();
				if (o instanceof UserForPersonalization) {
					UserForPersonalization user = (UserForPersonalization)o;
					x = getXmlForUser(user);
				}
				else if (o instanceof GroupForPersonalization) {
					GroupForPersonalization group = (GroupForPersonalization)o;
					x = getXmlForGroup(group);
				}
				else {
					x = getXmlForOther(o);
				}
				xmlInherited.append(x);
			}
			xmlInherited.append("</inherited>\n");
			
			xmlInherited.append("<useInherited value=\"");		
			xmlInherited.append(useInheritedPrivileges);
			xmlInherited.append("\"/>\n");
			
			xmlInherited.append("</inheritance>\n");
		}
		
		xml.append(xmlUsers);
		xml.append(xmlGroups);
		xml.append(xmlOthers);
		xml.append(xmlInherited);
		
		
		
		// public
		xml.append("<isPublic value=\""+isPublicDirectory+"\" canEdit=\""+currentSpace.allowPublicSharing()+"\"/>");
		
		// browser url
		String browserAccessUrl = null;
		if (currentSpace!=null) {
			browserAccessUrl = currentSpace.getServer().getParameterValue(ServerConstants.BROWSER_ACCESS_URL);
			if (browserAccessUrl!=null && !browserAccessUrl.trim().equals("")) {
				browserAccessUrl += currentSpace.getCurrentPath();
			}
			else {
				browserAccessUrl=null;
			}
		}
		if (browserAccessUrl!=null) {
			browserAccessUrl = browserAccessUrl.replace("&","&amp;");
			browserAccessUrl = browserAccessUrl.replace("\"","&quot;");
			browserAccessUrl = browserAccessUrl.replace(">","&gt;");
			browserAccessUrl = browserAccessUrl.replace("<","&lt;");
		}
		xml.append("<browserUrl access=\""+currentSpace.getBrowserAccessUrlVisibility()+"\" url=\""+browserAccessUrl+"\"/>");
		
		//System.out.println(xml);
		
		return xml;
		
	}
	
	
	/**
	 * Compare this object to another one
	 */
	public boolean equals(Object o) {
		DirectorySharingProperties comp = (DirectorySharingProperties)o;
		
		return comp.users.equals(this.users) && comp.groups.equals(this.groups) && comp.others.equals(this.others) && comp.inherited.equals(this.inherited) && comp.useInheritedPrivileges==this.useInheritedPrivileges;
		
	}
	
}
