/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.spacesPersonalization;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.config.ChannelConfiguration;
import org.esupportail.portal.channels.CStockage.config.Server;
import org.esupportail.portal.channels.CStockage.config.Space;
import org.esupportail.portal.channels.CStockage.exception.PropertiesException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Id: SpaceTool.java,v 1.0 5 janv. 2005
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: SpaceTool
 * Original Author: Yohan Colmant
 * Object used to manage a Space while the sharing of spaces by users
 */
public class ServerTool {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(ServerTool.class);
	
	
	
	/**
	 * The Server we are using
	 */
	private Server server;
	
	
	
	

	/**
	 * Constructor
	 * @param stringToParse the String we want to parse
	 */
	public ServerTool(String stringToParse) {

		Digester digester = new Digester();
		digester.setValidating(false);
		digester.push(this);		
		
		/*
		 * The space
		 */
		

		// SERVER
		ChannelConfiguration.setDigesterConfigurationForServer(digester);
		
		
		StringReader sr = new StringReader(stringToParse);		
		InputSource inSource = new InputSource(sr);

		try {
			//parse config file
			digester.parse(inSource);							
		}
		catch (IOException e) {				
			log.error("SpaceTool :: "+ e.toString(), e);
		}
		catch (SAXException e) {				
			log.error("SpaceTool :: " + e.toString(), e);
		}
	}
	
	
	

	/**
	 * return the server
	 * @return the server
	 */
	public Server getServer() throws PropertiesException {	

		if (server == null) {
			log.error("getServer :: there is no space set - servers is null");
			throw new PropertiesException();
		}
		else {
			ArrayList spacesOfServer = server.getSpaces();
			
			// we return the result
			//if (spacesOfServer.size()==0) {
				//log.error("getServer :: there is no space set - spaces is empty");
				//throw new PropertiesException();
			//}
			//else {
				
				for (int j=0; j<spacesOfServer.size(); j++) {
					Space space = (Space)spacesOfServer.get(j);
					space.setServer(server);
				}
				//return spacesOfServer;
			//}
			
		}	
		
		
		return server;
	}

	

	
	/**
	 * return the spaces list
	 * @return the spaces list
	 */
	public ArrayList getSpaces() throws PropertiesException {
		return getServer().getSpaces();
	}
	
	

	/**
	 * add a new server to the list
	 * @param server the server to add
	 */
	public void addServer(Server server) throws PropertiesException {
		
		// the server access class
		String serverType = server.getServerType();
		String serverClass = null;
		
		if (serverType!=null) {
			serverClass = (String)ChannelConfiguration.getInstance().getServerAccess().get(serverType);
			server.setServerAccessClass(serverClass);
		}
		
		// for each space
		ArrayList spaces = server.getSpaces();
		for (int i=0; spaces!=null && i<spaces.size(); i++) {
			
			Space space = (Space)spaces.get(i);
			
			// the channel action type
			String actionType = space.getActionType();
			String actionClass = null;
		
			if (actionType!=null) {
				actionClass = (String)ChannelConfiguration.getInstance().getChannelActions().get(actionType);
				space.setChannelActionClass(actionClass);
				
				space.setMetadataNamespace(actionType.toUpperCase()+":");
			}		
		
			
			// set the server into this space
			//space.setServer(server);
		}
		
		// init the spaces into the server
		//server.initSpaces();
		
		this.server = server;
	}
	
	
	
	
	
	
	
	
	
	
	
	
}
