/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
 
package org.esupportail.portal.channels.CWebdav;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.esupportail.portal.channels.CWebdav.channelAction.Constants;
import org.esupportail.portal.channels.CWebdav.config.Config;
import org.esupportail.portal.channels.CWebdav.config.Space;
import org.esupportail.portal.channels.CWebdav.exception.ApplicationException;
import org.esupportail.portal.channels.CWebdav.exception.DownloadException;
import org.esupportail.portal.channels.CWebdav.exception.PropertiesException;
import org.esupportail.portal.channels.CWebdav.exception.ServerException;
import org.esupportail.portal.channels.CWebdav.exception.WebdavException;
import org.esupportail.portal.channels.CWebdav.provider.ChannelWebdavResource;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IMimeResponse;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;

/**
 * Id: CWebdav.java,v 1.0 7 avr. 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: CWebdav<br/>
 * Original Author: Yohan Colmant<br/>
 * Channel used to manage personal files on a webdav server through the portal<br/>
 */




public class CWebdav extends BaseChannel implements IMimeResponse,ICacheable  {

  private ChannelStaticData staticData;
  
  private String fileId;
  private PortalControlStructures pcs;


  	/**
  	 * The config object
  	 */
  	private Config config;
  
  
	/**
	 * The actual mod in which is the channel
	 */
	private String currentMode;

	
	/**
	 * The spaces availables
	 */
	private ArrayList spaces;
	
	/**
	 * The current used space
	 */
	private Space currentSpace;
	
	
	
	
	
	/**
	 * Error at the beginning of the channel
	 */
	private WebdavException setStaticDataException;		
	
	/**
	 * User login
	 */
	private String login;
	

	/**
	 * Object used to keep the objects used between 2 actions, for example, the clipboard
	 */
	private BufferAction buffer;
	
	
	
	

	
	
	
	/**
	 * Constructor
	 */
	public CWebdav() {				
		
		//System.out.println("\n\n\n\n\n\n");
		
		// we begin in this mode
		this.currentMode = Constants.SHOW_CURRENT_DIR_MODE;
		
		// init the buffer
		this.buffer = new BufferAction();
	}	

	
	/**
	 * Receive static channel data from the portal. Satisfies implementation of IChannel Interface.
	 * 
	 * @param sd <b>ChannelStaticData</b> static channel data
	 */
	public void setStaticData(ChannelStaticData sd) {		
		
		this.staticData = sd;	
		
		try {
			
			config = new Config();
			
			IPerson person = sd.getPerson();
			
			// if there is a trusted login
			String trustedLogin = config.getTrustedLogin();
			
			// the usernameAttribute
			String userNameAttribute = config.getUsernameAttribute();
						
			if (trustedLogin==null || trustedLogin.equals("")) {												
				
				//Set the user login			
				login = (String)person.getAttribute(userNameAttribute);			
			}
			else login = trustedLogin;
						
			// the password
			String password = config.getTrustedPassword();
			
			
			// the uri used for the connexion with webdav
			String uri = config.getUrl();		
			
			// Check the class name
			String davAccessClass = config.getClassAccess();
			
			// the spaces availables
			spaces = config.getSpaces();
			
			
			
			// for each Space, we check if the path is in the {...} form. Is yes, we replace {...} by the real value
			// after that, we try to obtain the redirected url. for example, if the path is /server/~bidon, we try to have the real path: for example /slide/files/storage/users/n/no/bidon			
			for (int i=0; i<spaces.size(); i++) {
				
				Space space = (Space)spaces.get(i);
				
				// check the {...}
				if (trustedLogin==null || trustedLogin.equals("")) {					
					space.checkPath(person, null, null);
				}
				else {					
					space.checkPath(person, userNameAttribute, trustedLogin);
				}				
				
				// we configure the object used by the space to acces the server
				boolean validAccess = space.setWebdavAccessObject(davAccessClass, uri, login, password);
				
				// we check if this space if valid or not
				if (!validAccess) {
					spaces.remove(i);
					i--;
				}
				
				else {				
					// set for the space, the channel action object used
					boolean wellDone = space.setChannelActionObject(spaces, config, buffer);
					
					if (!wellDone) {
						spaces.remove(i);
						i--;
					}
				}
			}				
			
			// the current space
			this.currentSpace = (Space)spaces.get(0);									
			
			// if we don't have any space
			if (this.currentSpace == null)
				throw new ServerException();
		}
		catch(ServerException e) {			
			//this.currentSpace.setWebdavAccessObject(null);
			setStaticDataException = e;
			LogService.log(LogService.ERROR, "CWebdav::CWebdav::setStaticData : "+ e);
		}
		catch(ApplicationException e) {			
			//this.currentSpace.setWebdavAccessObject(null);			
			setStaticDataException = e;
			LogService.log(LogService.ERROR, "CWebdav::CWebdav::setStaticData : "+ e);
		}
		catch(PropertiesException e) {			
			//this.currentSpace.setWebdavAccessObject(null);		
			setStaticDataException = e;
			LogService.log(LogService.ERROR, "CWebdav::CWebdav::setStaticData : "+ e);
		}
		catch(ClassNotFoundException e) {			
			//this.currentSpace.setWebdavAccessObject(null);		
			setStaticDataException = new PropertiesException();
			LogService.log(LogService.ERROR, "CWebdav::CWebdav::setStaticData : "+ e);
		}
		catch(IllegalAccessException e) {			
			//this.currentSpace.setWebdavAccessObject(null);		
			setStaticDataException = new PropertiesException();
			LogService.log(LogService.ERROR, "CWebdav::CWebdav::setStaticData : "+ e);
		}
		catch(InstantiationException e) {			
			//this.currentSpace.setWebdavAccessObject(null);		
			setStaticDataException = new PropertiesException();
			LogService.log(LogService.ERROR, "CWebdav::CWebdav::setStaticData : "+ e);
		}
		catch(MalformedURLException e) {			
			//this.currentSpace.setWebdavAccessObject(null);	
			setStaticDataException = new PropertiesException();
			LogService.log(LogService.ERROR, "CWebdav::CWebdav::setStaticData : "+ e);
		}		
	}
	
	
	
	
		
	
	/**
	 * Output channel content to the portal
	 * 
	 * @param out a sax document handler
	 */
	public void renderXML(ContentHandler out) throws PortalException {	

		
				
		// if we change the space
		String[] spaceChanges = runtimeData.getParameterValues("space");
		if (spaceChanges != null){
			String oldSpaceKey = this.currentSpace.getKey();
			String newSpaceKey = null;
			boolean findChangement = false;
			for (int i = 0; i<spaceChanges.length && !findChangement;i++){
				newSpaceKey = spaceChanges[i];
				if (!newSpaceKey.equals(oldSpaceKey))
					findChangement = true;
			}
			
			// if found, we look for the good space into the ArrayList
			if (findChangement) {
				
				boolean findGoodSpace = false;
				for (int i=0; i<spaces.size() && !findGoodSpace; i++) {
					Space s = (Space)spaces.get(i);
					if (s.getKey().equals(newSpaceKey)) {
						findGoodSpace = true;
						this.currentSpace = s;
					}
						
				}
				
			}
		}
		
		
		// Create a new XSLT styling engine		
		XSLT xslt = new XSLT(this);
						
		// generate the xml for in function of the current space type 
		this.currentSpace.getChannelActionObject().checkCalledAction(runtimeData, xslt, setStaticDataException);
		
		// set the output Handler for the output.
		xslt.setTarget(out);
	
		// do the deed
		xslt.transform();			
	}
	
	
	


/***************************************************************************/
/*********************START OF DOWNLOAD FUNCTIONS***************************/
/***************************************************************************/

	/**
	 * The resource to download
	 */
	private ChannelWebdavResource downloadResource = null;
	
	
  	/**
	 * Return the content type of the seleted file
	 * @see org.jasig.portal.IMimeResponse#getContentType()
	 */
	public String getContentType() {
		return downloadResource.getContentType();
	}


	/**
	 * Send HTTP header
	 * @see org.jasig.portal.IMimeResponse#getHeaders()
	 */
	public Map getHeaders() {
		Map map = new HashMap();
      
		fileId = runtimeData.getParameter("file");
		try {
			fileId = URLDecoder.decode(fileId,"UTF-8");
		}
		catch (UnsupportedEncodingException e) {
			LogService.log(LogService.ERROR,"CWebdav::getHeaders: UnsupportedEncodingException"+e);
		}
    
		// we check if it is a directory
		String path = currentSpace.getPath();
		
		try {
			downloadResource = this.currentSpace.getDavAccessObject().dowload(fileId,path);
				
			fileId = fileId.replaceAll(" ", "_");
			fileId = fileId.replaceAll("[]", "a");
			fileId = fileId.replaceAll("[]", "e");
			fileId = fileId.replaceAll("[]", "i");
			fileId = fileId.replaceAll("[]", "o");
			fileId = fileId.replaceAll("[]", "u");
			fileId = fileId.replaceAll("", "c");
			fileId = fileId.replaceAll("", "n");
			fileId = fileId.replaceAll("[]", "A");
			fileId = fileId.replaceAll("[]", "E");
			fileId = fileId.replaceAll("[]", "I");
			fileId = fileId.replaceAll("[]", "O");
			fileId = fileId.replaceAll("[]", "U");
			fileId = fileId.replaceAll("", "C");
			fileId = fileId.replaceAll("", "N");		
			
			// open in new window : inline  -- ||
			// download : attachment  -- -- -- ||
			//                                 \/
			map.put("Content-disposition", "attachment; filename="+fileId  );

			return map;
		}
		catch(DownloadException e) {
			map.put("Location", runtimeData.getBaseActionURL());
			return map;
		}
	}
	
	
	/**
	 *	Get the strem for the file to dowload
	 * @see org.jasig.portal.IMimeResponse#getInputStream()
	 */
	public InputStream getInputStream() throws IOException {	
		return downloadResource.getInputStream();
	}


	/**
	 * Function unused here
	 * @see org.jasig.portal.IMimeResponse#downloadData(java.io.OutputStream)
	 */
	public void downloadData(OutputStream arg0) throws IOException {
	}


	/**
	 * Function unused here
	 * @see org.jasig.portal.IMimeResponse#getName()
	 */
	public String getName() {
		return null;
	}


	/**
	 * Print the error generated by the download
	 * @see org.jasig.portal.IMimeResponse#reportDownloadError(java.lang.Exception)
	 */
	public void reportDownloadError(Exception arg0) {
		arg0.printStackTrace();
	}

	

	/***************************************************************************/
	/*********************END OF DOWNLOAD FUNCTIONS*****************************/
	/***************************************************************************/



	/***************************************************************************/
	/**********************START OF CACHE FUNCTIONS*****************************/
	/***************************************************************************/

	/* (non-Javadoc)
	 * @see org.jasig.portal.ICacheable#generateKey()
	 */
	public ChannelCacheKey generateKey() {

	    ChannelCacheKey k = new ChannelCacheKey();
	    StringBuffer sbKey = new StringBuffer(1024);
	    sbKey.append(this.getClass().getName() + " : ");
	    sbKey.append("login : "+login+";");
	    sbKey.append("SubscribeId:"+this.staticData.getChannelSubscribeId());
	    k.setKeyScope(ChannelCacheKey.INSTANCE_KEY_SCOPE);

	    k.setKey(sbKey.toString());
	    k.setKeyValidity(new Long(System.currentTimeMillis()));
	    /*LogService.log(LogService.DEBUG,
	                              "CWebdav::generateKey() (id : " +
	                              this.staticData.getChannelSubscribeId() +
	                              ") : generateKey :  -> Cle de cache:" + k.getKey());
	    */
		return k;
	}

	/* (non-Javadoc)
	 * @see org.jasig.portal.ICacheable#isCacheValid(java.lang.Object)
	 */
	public boolean isCacheValid(Object validity) {

	    boolean cacheValid = false;

	  if(runtimeData.getParameters().size()==0)
	  		cacheValid=true;

	  /*if (cacheValid) {
        LogService.log(LogService.DEBUG,
                                  "CWebdav::isCacheValid (" +
                                  this.staticData.getChannelSubscribeId() +
                                  ") : isCacheValid -> YES");
      }
      else {
        LogService.log(LogService.DEBUG,
                                  "CWebdav::isCacheValid (" +
                                  this.staticData.getChannelSubscribeId() +
                                  ") : isCacheValid -> NO");
      }*/
	    return cacheValid;
	}
	/***************************************************************************/
	/************************END OF CACHE FUNCTIONS*****************************/
	/***************************************************************************/
}
