/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

package org.esupportail.portal.channels.CWebdav.channelAction;

import java.util.ArrayList;

import org.esupportail.portal.channels.CWebdav.BufferAction;
import org.esupportail.portal.channels.CWebdav.config.Config;
import org.esupportail.portal.channels.CWebdav.config.Space;
import org.esupportail.portal.channels.CWebdav.exception.ApplicationException;
import org.esupportail.portal.channels.CWebdav.exception.BadFormatException;
import org.esupportail.portal.channels.CWebdav.exception.CancelException;
import org.esupportail.portal.channels.CWebdav.exception.CreateDirectoryException;
import org.esupportail.portal.channels.CWebdav.exception.NoneSelectedResourceException;
import org.esupportail.portal.channels.CWebdav.exception.NotAuthorizedException;
import org.esupportail.portal.channels.CWebdav.exception.NotAuthorizedNewDirException;
import org.esupportail.portal.channels.CWebdav.exception.NotEmptyDirectoryException;
import org.esupportail.portal.channels.CWebdav.exception.NotExistsResourceException;
import org.esupportail.portal.channels.CWebdav.exception.StillExistsException;
import org.esupportail.portal.channels.CWebdav.exception.TooMuchSelectedException;
import org.esupportail.portal.channels.CWebdav.exception.WebdavException;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.XSLT;

/**
 * Id: AbstractChannelAction.java,v 1.0 24 sept. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: AbstractChannelAction
 * Original Author: Yohan Colmant
 * 
 */
public abstract class AbstractChannelAction {
	
	/**
	 * the space containing this channel action
	 */
	protected Space currentSpace;
	
	/**
  	 * The config object
  	 */
	protected Config config;
  	
  	/**
	 * The spaces availables
	 */
	protected ArrayList spaces;
	
	/**
	 * The stylesheet used
	 */
	protected String stylesheet;
	
	/**
	 * Object used to keep the objects used between 2 actions, for example, the clipboard
	 */
	protected BufferAction buffer;
	
	
	
	
	
	
	/**
	 * Init the object used to manage the actions of the channel
	 * @param currentSpace the current space used
	 * @param spaces all the spaces used
	 * @param config the config class
	 * @param buffer the buffer used to get for example the clipboard
	 */
	public void init(Space currentSpace, ArrayList spaces, Config config, BufferAction buffer) {
		this.currentSpace = currentSpace;
		this.config = config;
		this.spaces = spaces;
		this.buffer = buffer;
	}
	
	
	/**
	 * Manage the actions when refreshing the channel
	 * @param runtimeData the runtime data channel object
	 * @param xslt the xslt motor object
	 * @param setStaticDataException the excpetion throwed in the setStaticData method
	 * @throws PortalException
	 */
	public abstract void checkCalledAction(ChannelRuntimeData runtimeData, XSLT xslt, WebdavException setStaticDataException) throws PortalException;
	
	
	
	
	
	
	

	/**
	 * Generate the XML String for this mod
	 * @param runtimeData the runtime data channel object
	 * @return the XML String for this mod
	 */
	protected void createDir(ChannelRuntimeData runtimeData) throws CancelException, ApplicationException, CreateDirectoryException, StillExistsException, BadFormatException, NotAuthorizedException, NotAuthorizedNewDirException, NotExistsResourceException{
		String submit = runtimeData.getParameter("Submit");
		String cancel = runtimeData.getParameter("Cancel");
		
		if (submit == null) {
			throw new CancelException();
		} else {
			String information = null;
			String error = null;
				
			String path = currentSpace.getPath();
			int errorCode = 0;

			String newDirName = runtimeData.getParameter("new_dir");
			this.currentSpace.getDavAccessObject().createDir(newDirName, path);
        	
			LogService.log(LogService.DEBUG, "CWebdav::createDir: newDir = "+newDirName+"******* path = "+path);
			
		}
	}

	
	
	
	
	
	
	
	
	/**
	 * Generate the XML String for this mod
	 * @param runtimeData the runtime data channel object
	 * @return the XML String for this mod
	 * @throws WebdavException
	 */
	protected StringBuffer renderXmlSetNameForRename(ChannelRuntimeData runtimeData) throws WebdavException {
		// we get the files we want to rename
		String[] files = runtimeData.getParameterValues("listeFic");
		
		if (files == null) {
			stylesheet = "CWebdav";
			throw new NoneSelectedResourceException();
			//return WebdavRenderXml.getXml(spaces, currentSpace, new NoneSelectedResourceException(), null, config);
		}		
		else {						
			// if there is more than one file
			if (files.length > 1) {
				stylesheet = "CWebdav";
				throw new TooMuchSelectedException();
				//return WebdavRenderXml.getXml(spaces, currentSpace, new TooMuchSelectedException(), null, config);
			}
			else {			
				String fileToRename = files[0];
				buffer.setFileToRename(fileToRename);
				StringBuffer sb = new StringBuffer();
				sb.append("<OLD>");
				sb.append(fileToRename);
				sb.append("</OLD>");
				return sb;
			}					
		}
	}
	
	
	/**
	 * Generate the XML String for this mod
	 * @param runtimeData the runtime data channel object
	 * @return the XML String for this mod
	 */
	protected void rename(ChannelRuntimeData runtimeData) throws WebdavException{
		String submit = runtimeData.getParameter("Submit");
		String cancel = runtimeData.getParameter("Cancel");
		
		if (submit == null) {
			buffer.setFileToRename(null);
			throw new CancelException();
		}
		else {
			String information = null;
			String error = null;
				
			// we clicked on the validate button: we rename 
			String path = currentSpace.getPath();		
						
			String newName = runtimeData.getParameter("new_name");
			this.currentSpace.getDavAccessObject().rename(buffer.getFileToRename(), newName, path);
			
			buffer.setFileToRename(null);						
		}
	}
		
	
	
	
	
	
	/**
	 * Generate the XML String for this mod
	 * @param runtimeData the runtime data channel object
	 * @return le XML pour ce mode
	 * @throws WebdavException
	 */
	protected StringBuffer renderXmlConfirmDelete(ChannelRuntimeData runtimeData) throws WebdavException {
		// Xml generated
		StringBuffer xml = new StringBuffer();
		
		String[] filesToDelete = runtimeData.getParameterValues("listeFic");
		buffer.setFilesToDelete(filesToDelete);	
		if (filesToDelete == null) {
			throw new NoneSelectedResourceException();			
		}
		
		else {
			//check if it is allowed to delete non empty directory
			boolean authorise = config.getAllowDelNonEmptyFolder();		

			//For each piece of the selection
			for (int j=0;j<filesToDelete.length;j++){
				String fileName = filesToDelete[j];				

				String path = currentSpace.getPath();			
				
				//check if it is a directory or a file
				boolean isDirectory = this.currentSpace.getDavAccessObject().isDirectory(fileName, path);																
				if (isDirectory) {	
					
					//check if non empty
					boolean empty = this.currentSpace.getDavAccessObject().isEmpty(fileName, path);														
										
					if (!empty && !authorise) {
						//Delete forbidden for this directory
						buffer.setFilesToDelete(null);						
						throw new NotEmptyDirectoryException();
					}
					else if (!empty && authorise)
						xml.append("<DIR name=\""+fileName+"\" empty=\""+false+"\"/>");
					else if (empty)											
						xml.append("<DIR name=\""+fileName+"\" empty=\""+true+"\"/>");
				}
				
				else if (!isDirectory)					
					xml.append("<FILE name=\""+fileName+"\"/>");								
			}			
			return xml;					
		}
	}
	
		
	
	
	
	/**
	 * Generate the XML String for this mod
	 * @param runtimeData the runtime data channel object
	 * @throws WebdavException
	 */
	protected void delete(ChannelRuntimeData runtimeData) throws WebdavException  {
		String submit = runtimeData.getParameter("Submit");
		String cancel = runtimeData.getParameter("Cancel");
		
		if (submit == null) {
			throw new CancelException();
		}
		
		String information = null;
		String error = null;
			
		String path = currentSpace.getPath();	
		
		String[] filesToDelete = buffer.getFilesToDelete();
		
		for (int i=0; i<filesToDelete.length; i++) {
			String file = (String)filesToDelete[i];
			this.currentSpace.getDavAccessObject().delete(file, path);				
		}
			
		buffer.setFilesToDelete(null);								
	} 
	
	
	/**
	 * Generate the XML String for this mod
	 * @throws WebdavException
	 */
	protected void deleteWithoutConfirm() throws WebdavException {		
		
		String information = null;
		String error = null;
			
		String path = currentSpace.getPath();		
		
		String[] filesToDelete = buffer.getFilesToDelete();
		
		for (int i=0; i<filesToDelete.length; i++) {
			String file = (String)filesToDelete[i];
			this.currentSpace.getDavAccessObject().delete(file, path);				
		}
			
		buffer.setFilesToDelete(null);									
	}
	
	
	
	
	
	
}
