/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CWebdav.channelAction;

import java.util.ArrayList;

import org.esupportail.portal.channels.CWebdav.config.Space;
import org.esupportail.portal.channels.CWebdav.exception.WebdavException;

/**
 * Id: AbstractRenderXml.java,v 1.0 24 sept. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: AbstractRenderXml
 * Original Author: Yohan Colmant
 * 
 */
public abstract class AbstractRenderXml {
	
	
	
	
	/**
	 * Get the XML for the navigation bar
	 * @param spaces the visibles spaces
	 * @param currentSpace the current space used
	 * @return the XML as a StringBuffer
	 */
	protected static StringBuffer getXmlNavigation(ArrayList spaces, Space currentSpace) {
		StringBuffer xmlTemp = new StringBuffer();
		
		// the space choice
		if (spaces.size()>1) {
			xmlTemp.append("<SPACES>\n");
			for (int i=0; i<spaces.size(); i++) {
				Space space = (Space)spaces.get(i);
				String key = space.getKey();
				if (key.equals(currentSpace.getKey()))			
					xmlTemp.append("   <SPACE label=\""+space.getLabel().replaceAll("&","&amp;")+"\" key=\""+key+"\" current=\"true\" />\n");
				else xmlTemp.append("   <SPACE label=\""+space.getLabel().replaceAll("&","&amp;")+"\" key=\""+key+"\" />\n");
			}
			xmlTemp.append("</SPACES>\n");
		}
		
		// the navigation
		xmlTemp.append("<NAVIGATION>\n");
		for (int i=0; i<currentSpace.getPathSize(); i++) {			
			xmlTemp.append("   <DIR label=\""+currentSpace.getPathElementAt(i).replaceAll("&","&amp;")+"\" link=\""+i+"\" />\n");
		}
		xmlTemp.append("</NAVIGATION>\n");
		
		return xmlTemp;		
	}
	
	
	
	
	

	
	/**
	 * Get the XML for the error bar
	 * @param error the error
	 * @param internalError if there is an internal error
	 * @return the XML as a StringBuffer
	 */
	protected static StringBuffer getXmlError(WebdavException error, int internalError) {
		StringBuffer xml = new StringBuffer();
		
		xml.append("<ERRORS>");
		if ( error!=null )
			xml.append("<ERROR httpCode=\""+error.getHttpErrorCode()+"\" channelCode=\""+error.getErrorCode()+"\" />");
		else {
			if (internalError!=-1)
				xml.append("<ERROR channelCode=\""+internalError+"\" />");
		}
		xml.append("</ERRORS>");
		return xml;
	}	
	
	
	
	/**
	 * Get the XML for the info bar
	 * @param information the information message code
	 * @return the XML as a StringBuffer
	 */
	protected static StringBuffer getXmlInformation(String information) {
		StringBuffer xml = new StringBuffer();
		
		if (information!=null)
			xml.append("<INFORMATION>"+information+"</INFORMATION>");
		
		return xml;
	}
		
	
	
	/**
	 * Return the good length format to print
	 * @param contentLength the content length
	 * @return the string to show
	 */
	protected static String getLengthFormat(long contentLength) {		
   		
   		// length format
   		long intLength = contentLength;	                   		      			
		float floatLength = intLength;				
		long divInt = (intLength /1024)/1024;		
		
		String length = "";
		if (divInt > 0) {			
			length = ""+(floatLength/1024)/1024;
			int index = length.indexOf(".");					
			if (length.length() > index+3) {
				length = length.substring(0, index+3);
			}						
			length += " MB";
		}
		else {
			divInt = (intLength /1024);			
			if (divInt > 0) {			
				length = ""+(floatLength/1024);
				int index = length.indexOf(".");					
				if (length.length() > index+3) {
					length = length.substring(0, index+3);
				}						
				length += " KB";
			}
			else {			
				length = ""+(floatLength);				
				int index = length.indexOf(".");			
				if (length.length() > index+3) {
					length = length.substring(0, index+3);
				}
				length += " B";
				}
			}
		return length;
	}
	
	

}
