/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

package org.esupportail.portal.channels.CWebdav.channelAction.webdav;


import java.util.Vector;

import org.esupportail.portal.channels.CWebdav.exception.ApplicationException;
import org.esupportail.portal.channels.CWebdav.exception.CancelException;
import org.esupportail.portal.channels.CWebdav.exception.NoneSelectedResourceException;
import org.esupportail.portal.channels.CWebdav.exception.NotAuthorizedException;
import org.esupportail.portal.channels.CWebdav.exception.NotExistsResourceException;
import org.esupportail.portal.channels.CWebdav.exception.PasteDeletedResourceException;
import org.esupportail.portal.channels.CWebdav.exception.ServerException;
import org.esupportail.portal.channels.CWebdav.exception.WebdavException;
import org.esupportail.portal.channels.CWebdav.channelAction.AbstractChannelAction;
import org.esupportail.portal.channels.CWebdav.channelAction.Constants;
import org.esupportail.portal.channels.CWebdav.channelAction.webdav.WebdavRenderXml;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.MultipartDataSource;
import org.jasig.portal.PortalException;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.XSLT;

/**
 * Id: WebdavChannelAction.java,v 1.0 24 sept. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: WebdavChannelAction
 * Original Author: Yohan Colmant
 * Class used to manage the actions when we are in a webdav space context
 */
public class WebdavChannelAction extends AbstractChannelAction {

	
	
	
	/**
	 * Default constructor
	 */
	public WebdavChannelAction() {
		
	}
	
	
	
	
	/**
	 * Manage the actions when refreshing the channel
	 * @param runtimeData the runtime data channel object
	 * @param xslt the xslt motor object
	 * @param setStaticDataException the excpetion throwed in the setStaticData method
	 * @throws PortalException
	 */
	public void checkCalledAction(ChannelRuntimeData runtimeData, XSLT xslt, WebdavException setStaticDataException) throws PortalException {		
		
		//this.runtimeData = runtimeData;
		
		// the string we will return
		StringBuffer xml = new StringBuffer();
		xml.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");		
		xml.append("<ROOT>");
		
		// set the mod
		// in the channel, there are 2 action menus. 
		// those menus have the same name modeDav. 
		// To differentiate the menu that we have selected, we check the value of the both. 
		// the menu with a not null value is the one we have selected.  
		String currentMode = null;
		String[] mod=runtimeData.getParameterValues("modeDav");
		if (mod != null){
			for (int i = 0; i<mod.length;i++){
				if (!mod[i].equals("")) {
					currentMode = mod[i];
				}
			}
		}
				
		// the stylesheet we are going to use
		stylesheet = "";

		// Xml string generated by the diferents methods
		StringBuffer xmlTemp = new StringBuffer();
		
		try {
			
			// connect to the dav
			if (setStaticDataException==null) {
				try {					
					this.currentSpace.getDavAccessObject().connect();
				}
				catch(Exception e) {
					setStaticDataException= new ServerException();
				}
			}
			
			// check the setStaticDataException
			if (setStaticDataException!=null)
				throw setStaticDataException;
			
			
			// set the default mod
			if (currentMode == null) {			
				currentMode = Constants.SHOW_CURRENT_DIR_MODE;
			}

			//////////////////////////////////////////////////////
			// D I R E C T O R Y
			//Display the current directory
			if (currentMode.equals(Constants.SHOW_CURRENT_DIR_MODE)) {	
				xmlTemp = renderXmlShowCurrentDir(runtimeData);			
				stylesheet = "CWebdav";
			}
			//Go to the parent directory
			else if (currentMode.equals(Constants.DIRECTORY_BACK)) {	
				directoryBack();
				xmlTemp = renderXmlShowCurrentDir(runtimeData);			
				stylesheet = "CWebdav";
			}
			//prepare create
			else if (currentMode.equals(Constants.SET_NAME_FOR_CREATE_DIR_MODE)) {		
				stylesheet = "setNewDirectory";						
			}
			//Real create
			else if (currentMode.equals(Constants.CREATE_DIR_MODE)) {		
				stylesheet = "CWebdav";
				createDir(runtimeData);		
				xmlTemp = WebdavRenderXml.getXml(spaces, currentSpace, null, "2004", config);
			}

			//////////////////////////////////////////////////////
			// U P L O A D
			//prepare
			else if (currentMode.equals(Constants.SET_FILE_TO_UPLOAD_MODE)) {										
				stylesheet = "setUpload";
			} 
			//Real upload
			else if (currentMode.equals(Constants.UPLOAD_MODE)) {
				upload(runtimeData);
				stylesheet = "CWebdav";
				xmlTemp = WebdavRenderXml.getXml(spaces, currentSpace, null, "2001", config);
			} 


			//////////////////////////////////////////////////////
			//D E L E T E
			//confirm
			else if (currentMode.equals(Constants.CONFIRM_DELETE_MODE)) {					
				StringBuffer x = renderXmlConfirmDelete(runtimeData);
				//
				if (config.getConfirmDel()) {
					stylesheet = "confirmDelete";
					xmlTemp = x;
				}
				
				// sinon, on passe directement au mode supprimer
				else {
					deleteWithoutConfirm();
					stylesheet = "CWebdav";
					xmlTemp = WebdavRenderXml.getXml(spaces, currentSpace, null, "2002", config);
				}													
			}
			//Real delete
			else if (currentMode.equals(Constants.DELETE_MODE)) {										
				delete(runtimeData);
				stylesheet = "CWebdav";			
				xmlTemp = WebdavRenderXml.getXml(spaces, currentSpace, null, "2002", config);
			}

			//////////////////////////////////////////////////////  
			//C O P Y
			//set clipboard
			else if (currentMode.equals(Constants.SET_CLIPBOARD_FOR_COPY_MODE)) {			
				stylesheet = "CWebdav";				
				setClipboard(Constants.COPY_MODE, runtimeData);
				xmlTemp = WebdavRenderXml.getXml(spaces, currentSpace, null, "2007", config);
			}
			
			// ask if we paste really
			else if (currentMode.equals(Constants.CONFIRM_PASTE_MODE)) {			
				stylesheet = "confirmPaste";								
				xmlTemp = renderXmlConfirmPaste();
			}
			
			//Real paste
			else if (currentMode.equals(Constants.PASTE_MODE)) {
				stylesheet = "CWebdav";
				xmlTemp = paste(runtimeData);						
			}

			//////////////////////////////////////////////////////
			//M O V E
			//set clipboard
			else if (currentMode.equals(Constants.SET_CLIPBOARD_FOR_MOVE_MODE)) {			
				stylesheet = "CWebdav";
				setClipboard(Constants.MOVE_MODE, runtimeData);
				xmlTemp = WebdavRenderXml.getXml(spaces, currentSpace, null, "2007", config);
			}			

			//////////////////////////////////////////////////////
			//R E N A M E
			//prepare
			else if (currentMode.equals(Constants.SET_NAME_FOR_RENAME_MODE)) {
				stylesheet = "setRename";
				xmlTemp = renderXmlSetNameForRename(runtimeData);		
			}
			//Real rename
			else if (currentMode.equals(Constants.RENAME_MODE)) {				
				rename(runtimeData);
				stylesheet = "CWebdav";	
				xmlTemp = WebdavRenderXml.getXml(spaces, currentSpace, null, "2003", config);
			} 
			
			xml.append(xmlTemp);			
				
		}		
		catch(WebdavException e) {
			stylesheet = "CWebdav";
			xml.append(WebdavRenderXml.getXml(spaces, currentSpace, e, null, config));
		}
		
		try {
			// discconnect from the dav
			this.currentSpace.getDavAccessObject().disconnect();
		}
		catch (Exception e) {
			LogService.log(LogService.ERROR, "CWebdav::WebdavChannelAction::checkCalledAction "+e);
		}
				
		
		// set the stylesheet and the parameters

		//specify the stylesheet selector		
		xslt.setXSL("CWebdav.ssl", stylesheet, runtimeData.getBrowserInfo());
		
		
		//url to the channel
		xslt.setStylesheetParameter("baseActionURL",runtimeData.getBaseActionURL());
		//url to the download worker
		xslt.setStylesheetParameter( "downloadURL",runtimeData.getBaseWorkerURL( org.jasig.portal.UPFileSpec.FILE_DOWNLOAD_WORKER,true).replaceAll("%2F","/"));				
		
		
		// the parameter to know if there is a resource in the clipboard
		if (buffer.getClipboard() != null)
			xslt.setStylesheetParameter("isClipboardEmpty","false");			      
		
		// the parameter used in the copy/move mode. tell if the mode is copy or move
		String clipboardParameter = buffer.getClipboardParameter();
		if (clipboardParameter != null) {
			xslt.setStylesheetParameter("clipboardParameter",clipboardParameter);			

		}
		
		// the final balise
		xml.append("</ROOT>");
		
		//pass the result XML to the styling engine.
		xslt.setXML(xml.toString());	
	}
	
	
	

	
	/**
	 * Generate the XML String for this mod
	 * @param runtimeData the runtime data channel object
	 * @return le XML pour ce mode
	 */
	private StringBuffer renderXmlShowCurrentDir(ChannelRuntimeData runtimeData) {	
				
		//startException = null;
		//informationMessage = null;
		
		//When we enter in a sub directory ...
		String directoryCible = runtimeData.getParameter("directory");
		if (directoryCible != null) {			
			/*try {								
				directoryCible = URLDecoder.decode(directoryCible,"ISO-8859-1");				
			} catch (UnsupportedEncodingException e1) {				
				e1.printStackTrace();
			}*/
			return WebdavRenderXml.getXml(spaces, currentSpace, directoryCible, null , null, config);
		}
		else {
			//... by naviguation tool
			String dir = runtimeData.getParameter("link");
			if (dir != null) {
				int index = Integer.parseInt(dir);
				int curentDirLength = currentSpace.getPathSize();
				if (index < curentDirLength) {					
					for (int i=0; i< (curentDirLength-(index+1)); i++) {						
						currentSpace.removePathElement(currentSpace.getPathSize()-1);
					}			
				}
				return WebdavRenderXml.getXml(spaces, currentSpace, null , null, config);
			}
		}
					
		// all others cases
		return WebdavRenderXml.getXml(spaces, currentSpace, null , null, config);
	}
	
	
	/**
	 * Go to the parent directory
	 */
	private void directoryBack() {
		if (currentSpace.getPathSize()>1)
			currentSpace.removePathElement(currentSpace.getPathSize()-1);		
	}
	
	
	
	/**
	 * Start the upload
	 * @param runtimeData the runtime data channel object
	 */
	private void upload(ChannelRuntimeData runtimeData) throws WebdavException {
	       
		String submit = runtimeData.getParameter("Submit");
		String cancel = runtimeData.getParameter("Cancel");
		Object inputFile = runtimeData.getObjectParameter("input_file");        
	
		if (submit == null) {		
			throw new CancelException();		       		       	
		}
		else {			
			// if file is null
			if (inputFile == null) {				
				throw new NotExistsResourceException();
			}			
			
			String information = null;
			String error = null;
			
			// get a reference to the file
			MultipartDataSource mps = (MultipartDataSource)inputFile;   	        	
			
	        String path = currentSpace.getPath();			
	        this.currentSpace.getDavAccessObject().upload(mps, path);
		}
	}


	
	
	/**
	 * Generate the XML String for this mod
	 * @param the mode used: copy or move
	 * @param runtimeData the runtime data channel object
	 * @return the XML String for this mod
	 */
	private void setClipboard(String mode, ChannelRuntimeData runtimeData) throws NoneSelectedResourceException, ApplicationException, NotAuthorizedException {			
		
		//check the files/directories from parameters
		String[] files = runtimeData.getParameterValues("listeFic");
		if (files == null) {			
			throw new NoneSelectedResourceException();
		}		
		else {
			
			// we check if we are authorized to copy all selected resources			
			String tempPath = currentSpace.getPath();
			for (int j=0;j<files.length;j++){
				String fileName = files[j];
				if (!this.currentSpace.getDavAccessObject().canRead(fileName, tempPath)) {
					// we erase the clipboard					
					buffer.setClipboard(null);
					buffer.setClipboardParameter(null);
					buffer.setClipboardPath(null);
					
					// we throw an exception
					throw new NotAuthorizedException();
				}
			}
			
			// if none NotAuthorizedException throwed
			
			// files/directories to copy			
			buffer.setClipboard(new Vector());
			buffer.setClipboardPath(currentSpace.getPath());
			
			for (int j=0;j<files.length;j++){
				String fileName = files[j];
				buffer.getClipboard().addElement(fileName);				
			}			
		}
				
		buffer.setClipboardParameter(mode);
	}
	
	
	/**
	 * Generate the XML String for this mod
	 * @return the XML String for this mod
	 */
	private StringBuffer renderXmlConfirmPaste() throws WebdavException {
		
		// we check if we can paste here
		try {			
			this.currentSpace.getDavAccessObject().canPaste(buffer.getClipboardPath(), buffer.getClipboard(), currentSpace.getPath());
		}
		catch (PasteDeletedResourceException e) {
			buffer.setClipboard(null);
			buffer.setClipboardParameter(null);
			buffer.setClipboardPath(null);						
			
			throw new PasteDeletedResourceException();
		}
		
		// Xml generated
		StringBuffer xml = new StringBuffer();
		
		//For each piece of the selection
		Vector clipboard = buffer.getClipboard();
		for (int j=0;j<clipboard.size();j++){
			String fileName = (String)clipboard.elementAt(j);				
			
			//check if it is a directory or a file
			boolean isDirectory = this.currentSpace.getDavAccessObject().isDirectory(fileName, buffer.getClipboardPath());								
						
			if (isDirectory) {	
					
				//check if non empty
				boolean empty = this.currentSpace.getDavAccessObject().isEmpty(fileName, buffer.getClipboardPath());														
				
				if (!empty)
					xml.append("<DIR name=\""+fileName+"\" empty=\""+false+"\"/>");
				else if (empty)											
					xml.append("<DIR name=\""+fileName+"\" empty=\""+true+"\"/>");
			}				
			else if (!isDirectory)					
				xml.append("<FILE name=\""+fileName+"\"/>");								
		}
			
		return xml;							
	}
	
	
	/**
	 * Generate the XML String for this mod
	 * @param runtimeData the runtime data channel object
	 * @return the XML String for this mod
	 */
	private StringBuffer paste(ChannelRuntimeData runtimeData) throws WebdavException {
		String submit = runtimeData.getParameter("Submit");
		String cancel = runtimeData.getParameter("Cancel");
		
		Vector clipboard = buffer.getClipboard();
		String clipboardPath = buffer.getClipboardPath();
		String clipboardParameter = buffer.getClipboardParameter();
		
		if (cancel == null) {			
			for (int i=0; i<clipboard.size(); i++) {								
				if (clipboardParameter.equals(Constants.COPY_MODE)) {			
					this.currentSpace.getDavAccessObject().copy(((String)clipboard.elementAt(i)), clipboardPath, currentSpace.getPath());
				}
				else {					
					this.currentSpace.getDavAccessObject().move(((String)clipboard.elementAt(i)), clipboardPath, currentSpace.getPath());
				}						
			}			
		} 		
		else {
			throw new CancelException();
		}				
		
		// if well done
		if (clipboardParameter.equals(Constants.COPY_MODE)) {			
			/*
			// if we want to set empty the clipboard
			clipboard = null;
			clipboardParameter = null;
			clipboardPath = null;
			*/
			return WebdavRenderXml.getXml(spaces, currentSpace, null, "2005", config);	
		}
		else {
			buffer.setClipboard(null);
			buffer.setClipboardParameter(null);
			buffer.setClipboardPath(null);
			return WebdavRenderXml.getXml(spaces, currentSpace, null, "2006", config);	
		}
	}
	
	
	/**
	 * Generate the XML String for this mod
	 * @param runtimeData the runtime data channel object
	 * @return the XML String for this mod
	 */
	private void move(ChannelRuntimeData runtimeData) throws WebdavException {
		String submit = runtimeData.getParameter("Submit");
		String cancel = runtimeData.getParameter("Cancel");
		
		String target = "/"+runtimeData.getParameter("target");
				
		if (cancel == null) {
			String fromPath = currentSpace.getPath();
			
			Vector clipboard = buffer.getClipboard();
			
			for (int i=0; i<clipboard.size(); i++) {								
				this.currentSpace.getDavAccessObject().move(((String)clipboard.elementAt(i)), fromPath, target);			
			}
		} 
		
		else {
			throw new CancelException();
		}				
	}
	
	
	
	

	
	
	
	
	
}
