/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

package org.esupportail.portal.channels.CWebdav.config;


/**
 * Id: Config.java,v 1.0<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: Config<br/>
 * Original Author: Sbastien GAUDIN<br/>
 * This class parse the CWebdav.xml config file to return all parameters<br/>
 */



import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;

import org.jasig.portal.services.LogService;
import org.apache.commons.digester.Digester;
import org.esupportail.portal.channels.CWebdav.exception.PropertiesException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;



public class Config { 
	
	
	/*spaces*/
	private String url;
	private ArrayList spaces = new ArrayList();
		
	/*Authentication*/
	private String usernameAttribute;
	private String trustedLogin;
	private String trustedPassword;	
	
	/*classAccess*/
	private String classAccess;
	
	/*Interface options*/
	private boolean confirmDel = true;
	private boolean allowDelNonEmptyFolder = true;
		
	/*Regular expression for "invisibles" files*/
	private Vector invisibleRegexp = new Vector();
	


	/*path of the config file*/
	private String configFilePath ="/properties/channels/org_esup/CWebdav/CWebDav.xml";
	
	
	
	/**
	 * Constructor
	 */
	public Config() throws PropertiesException {

		Digester digester = new Digester();
		digester.setValidating(false);
		digester.push(this);
		
		/*
		 * The authentication
		 * Add username_attribute,trusted_password and classAuth
		 */		
		digester.addSetProperties("WEBDAV/AUTH");
		digester.addCallMethod("WEBDAV/AUTH", "setClassAuth", 1);
		digester.addCallParam("WEBDAV/AUTH", 0, "class");			
		
		/*
		 * The server
		 */
		digester.addCallMethod("WEBDAV/SPACES", "setUrl", 1);
		digester.addCallParam("WEBDAV/SPACES", 0, "url");		
		
		/*
		 * The spaces
		 */
		digester.addObjectCreate("WEBDAV/SPACES/SPACE","org.esupportail.portal.channels.CWebdav.config.Space");		
		
		digester.addSetProperties( "WEBDAV/SPACES/SPACE","key","key");		
		digester.addSetProperties("WEBDAV/SPACES/SPACE","label", "label");		
		digester.addSetProperties("WEBDAV/SPACES/SPACE","path", "path");
		digester.addSetProperties("WEBDAV/SPACES/SPACE","class", "accessClass");
		
		digester.addSetNext("WEBDAV/SPACES/SPACE", "setSpaces");
		
		/*
		 * Add classAccess
		 */		
		digester.addCallMethod("WEBDAV/DAV_ACCESS", "setClassAccess", 1);
		digester.addCallParam("WEBDAV/DAV_ACCESS", 0, "class");
		
		/*
		 * Interface options
		 * Add confirmDel and allowDelNonEmptyFolder
		 */		
		digester.addCallMethod("WEBDAV/DEFAULT_OPTIONS_INTERFACE", "setConfirmDel", 1);
		digester.addCallParam("WEBDAV/DEFAULT_OPTIONS_INTERFACE", 0, "confirmDel");
		digester.addCallMethod("WEBDAV/DEFAULT_OPTIONS_INTERFACE", "setAllowDelNonEmptyFolder", 1);
		digester.addCallParam("WEBDAV/DEFAULT_OPTIONS_INTERFACE", 0, "allowDelNonEmptyFolder");
		  
		/*
		 * Invisibles files
		 * Add every  regular Expression
		 */		
		digester.addCallMethod("WEBDAV/INVISIBLE_FILES/REG_EXP", "addInvisibleRegexp", 1);
		digester.addCallParam("WEBDAV/INVISIBLE_FILES/REG_EXP", 0, "pattern");

		digester.addSetProperties( "WEBDAV/TEXT_ACTION");
		
		
		
		URL url = Config.class.getResource(configFilePath);		
		
		if (url != null) {

			InputSource inSource = new InputSource(url.toExternalForm());

			try {
				//parse config file
				digester.parse(inSource);							
			}
			catch (IOException e) {				
				LogService.log(LogService.ERROR, "CWebdav::config::config() : Unable to open config file" + configFilePath	+ "\n" + e.toString());
				throw new PropertiesException();
			}
			catch (SAXException e) {				
				LogService.log(LogService.ERROR, "CWebdav::config::config() : SAXException" + e.toString());
				throw new PropertiesException();
			}
		}
		else { 
			LogService.log(LogService.ERROR, "CWebdav::config::config() : "	+ configFilePath + " does not exist.\n");
			throw new PropertiesException();
		}
	}
	
	
	/**
	 * return the spaces list
	 * @return the spaces list
	 */
	public ArrayList getSpaces() throws PropertiesException {
		if (spaces.size()==0)
			throw new PropertiesException();
				
		return spaces;
	}

	/**
	 * add a new space to the list
	 * @param space the space to add
	 */
	public void setSpaces(Space space) {
		spaces.add(space);
	}
		
	
	/**
	 * @return Returns the url.
	 */
	public String getUrl() throws PropertiesException {
		if (url==null)
			throw new PropertiesException();
		return url;
	}
	
	/**
	 * @param url The url to set.
	 */
	public void setUrl(String url) {
		this.url = url; 
	}
	
	/**
	 * @return Returns the allowDelNonEmptyFolder.
	 */
	public boolean getAllowDelNonEmptyFolder() {
		return allowDelNonEmptyFolder;
	}
	
	/**
	 * @param allowDelNonEmptyFolder The allowDelNonEmptyFolder to set.
	 */
	public void setAllowDelNonEmptyFolder(String allowDelNonEmptyFolder) {
		if (allowDelNonEmptyFolder.equals("true"))
			this.allowDelNonEmptyFolder = true;
		else 
			this.allowDelNonEmptyFolder = false;
	}
	
	/**
	 * @return Returns the classAccess.
	 */
	public String getClassAccess() throws PropertiesException {
		if (classAccess==null)
			throw new PropertiesException();
		return classAccess;
	}
	
	/**
	 * @param classAccess The classAccess to set.
	 */
	public void setClassAccess(String classAccess) {
		this.classAccess = classAccess;
	}
	
	public boolean getConfirmDel() {
		return confirmDel;
	}
	
	/**
	 * @param confirmDel The confirmDel to set.
	 */
	public void setConfirmDel(String confirmDel) {
		if (confirmDel.equals("true"))
			this.confirmDel = true;
		else 
			this.confirmDel = false;
	}
	
	/**
	 * @return Returns the trustedLogin.
	 */
	public String getTrustedLogin() {
		return trustedLogin;
	}
	
	/**
	 * @param trustedLogin The trustedLogin to set.
	 */
	public void setTrustedLogin(String trustedLogin) {
		this.trustedLogin = trustedLogin;
	}
	
	/**
	 * @return Returns the trustedPassword.
	 */
	public String getTrustedPassword() throws PropertiesException {
		if (trustedPassword==null)
			throw new PropertiesException();
		return trustedPassword;
	}
	
	/**
	 * @param trustedPassword The trustedPassword to set.
	 */
	public void setTrustedPassword(String trustedPassword) {
		this.trustedPassword = trustedPassword;
	}
	
	/**
	 * @return Returns the usernameAttribute.
	 */
	public String getUsernameAttribute() throws PropertiesException {
		if (usernameAttribute==null)
			throw new PropertiesException();
		return usernameAttribute;
	}
	
	/**
	 * @param usernameAttribute The usernameAttribute to set.
	 */
	public void setUsernameAttribute(String usernameAttribute) {
		this.usernameAttribute = usernameAttribute;
	}
	
	/**
	 * @return Returns the invisibleRexexp.
	 */
	public Vector getInvisibleRegexp() throws PropertiesException {
		if (invisibleRegexp==null)
			throw new PropertiesException();
		return this.invisibleRegexp;
	}
	
	/**
	 * @param regexp The invisibleRexexp to set.
	 */
	public void addInvisibleRegexp(String regexp) {
		this.invisibleRegexp.add(regexp);
		
	}
	
	
}
