/*
 * Created on 9 juil. 2004
 */
package org.esupportail.portal.channels.CWebdav.config;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Vector;

import org.esupportail.portal.channels.CWebdav.BufferAction;
import org.esupportail.portal.channels.CWebdav.channelAction.AbstractChannelAction;
import org.esupportail.portal.channels.CWebdav.exception.ApplicationException;
import org.esupportail.portal.channels.CWebdav.exception.ServerException;
import org.esupportail.portal.channels.CWebdav.provider.DavAccess;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.LogService;

/**
 * Id: Space.java,v 1.0 9 juil. 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: Space<br/>
 * Original Author: Yohan Colmant<br/>
 * This represents a file space on the webdav<br/>
 */
public class Space {

	/**
	 * The space key
	 */
	private String key;
	
	/**
	 * The label of this space
	 */
	private String label;
	
	/**
	 * The class name used to manage the actions
	 */
	private String accessClass;
	
	/**
	 * The path of this space given in the properties file
	 */
	//private String path;
	
	/**
	 * The currentPath used
	 */
	private Vector currentPath = new Vector();
	
	/**
	 * The attribute used to access the webdav
	 */
	private DavAccess access;
	
	/**
	 * To manage the actions in funtion of the access class
	 */
	private AbstractChannelAction channelAction;
	
	
	
	
	
	
	
	
	/**
	 * @return Returns the accessClass.
	 */
	public String getAccessClass() {
		return accessClass;
	}
	/**
	 * @param accessClass The accessClass to set.
	 */
	public void setAccessClass(String accessClass) {
		this.accessClass = accessClass;
	}
	
	/**
	 * @return Returns the key.
	 */
	public String getKey() {
		return key;
	}
	
	/**
	 * @param key The key to set.
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * @return Returns the label.
	 */
	public String getLabel() {
		return label;
	}
	
	/**
	 * @param label The label to set.
	 */
	public void setLabel(String label) {
		this.label = label;
	}
	
	
	/**
	 * @param path The path to set.
	 */
	public void setPath(String path) {
		//this.path = path;
		
		currentPath = new Vector();		
		
		String initPath = new String(path);		
		if (initPath.startsWith("/"))
			initPath = initPath.substring(1, initPath.length());		
		if (initPath.endsWith("/"))
			initPath = initPath.substring(0, initPath.length()-1);
				
		// we add it to the currentPath
		currentPath.addElement(initPath);	
	}
		
	
	/**
	 * @return Returns the path.
	 */
	public String getPath() {	
		return getPath(currentPath);				
	}
	
	
	/**
	 * Return the path due to a current path vector
	 * @param currentPath
	 * @return
	 */
	private String getPath(Vector currentPath) {
		StringBuffer pathh = new StringBuffer("/"); 
		for (int i=0; i<currentPath.size(); i++) {
			String s = (String)currentPath.elementAt(i);
			if (!s.equals("")) {
				pathh.append(s);
				pathh.append("/");
			}			
		}
		
		return pathh.toString();	
	}
	
		
	/**
	 * We check if the is a {...} form in the path. If yes, we replace by the real value
	 * @param person the connected person
	 * @param currentHierPath the hierarchy path oh the server. for example, if the server's url is http://URL:PORT/slide, the currentHierPath is "/slide"
	 * @param trustedAttributeName if there is a trusted attribute, this is the name of this one
	 * @param trustedAttributeValue if there is a trusted attribute, this is the value of this one
	 */
	public void checkPath(IPerson person, String trustedAttributeName, String trustedAttributeValue) {
		
		// we fix the currentPath
		
		for (int i=0; i<currentPath.size(); i++) {
			String s = (String)currentPath.elementAt(i);
			
			int firstIndex = s.indexOf("{");
			int lastIndex = s.indexOf("}");
			
			if (firstIndex!=-1 && lastIndex!=-1) {
			
				String begin = s.substring(0, firstIndex);
				String med = s.substring(firstIndex+1, lastIndex);
				String end = s.substring(lastIndex+1, s.length());
				
				String realMedValue = "";
				// if we have a trusted attribute
				if (med.equals(trustedAttributeName))
					realMedValue = trustedAttributeValue;
				else realMedValue = (String)person.getAttribute(med);
				
				String newString = begin+realMedValue+end;								
				
				currentPath.setElementAt(newString, i);
			}			
		}
		
	}
	
	/**
	 * Add a path element to the current directory
	 * @param pathElement
	 */
	public void addPathElement(String pathElement) {
		this.currentPath.add(pathElement);
	}
	
	/**
	 * Remove an element from the current path
	 * @param index
	 */
	public void removePathElement(int index) {
		this.currentPath.remove(index);
	}
	
	/**
	 * Return the path size
	 * @return the size
	 */
	public int getPathSize() {
		return currentPath.size();
	}
		
	/**
	 * Return the current element path at the good index
	 * @param index the selected index
	 * @return a string
	 */
	public String getPathElementAt(int index) {
		if (index == 0)
			return this.label;
		else return (String)this.currentPath.elementAt(index);
	}
		
	
	/**
	 * Check if we are authorized to read this space
	 * @param access the object used to access the webdav
	 * @return true if authorized else false
	 * @throws ApplicationException
	 */
	public boolean canRead(DavAccess access) throws ApplicationException {
		
		if (access.canRead(this.getPath()))
			return true;
		else return false;
		
	}		
	
	
	/**
	 * Set the webdav access object for this space
	 * @param davAccessClass the class used to access the webdav
	 * @param uri the server uri
	 * @param login login used to connect
	 * @param password password udes to connect
	 * @return true if we can access this space, else false
	 * @throws ClassNotFoundException
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws MalformedURLException
	 * @throws ApplicationException
	 */
	public boolean setWebdavAccessObject(String davAccessClass, String uri, String login, String password) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException, ApplicationException{
		
		// construct the object
		Class c = Class.forName(davAccessClass);
		access = (DavAccess)c.newInstance();
				
		access.init(uri, getPath(), login, password);
		
		// try to connect
		try {
			access.connect();			
		}
		catch(ServerException e) {			
			return false;
		}
		
		// add the current server hierarchy path
		String serverCurrentHierPath = access.getServerCurrentHierPath();		
		setPath(serverCurrentHierPath);
		
		// if it is valid
		boolean valid = access.canRead(getPath());
		
		// disconnect
		try {
			access.disconnect();			
		}
		catch(ServerException e) {
			LogService.log(LogService.DEBUG, "CWebdav::Space::setWebdavAccessObject : "+ e);
		}
		
		return valid;
	}
	
	
	
	/**
	 * Return the object used to access the DAV
	 * @return
	 */
	public DavAccess getDavAccessObject() {
		return this.access;
	}
	
	
	/**
	 * Set the dav access object
	 * @param access
	 */
	public void setWebdavAccessObject(DavAccess access) {
		this.access = access;
	}
	
	
	/**
	 * Set the object used to manage the actions of the channel
	 * @param runtimeData the runtime data channel object
	 * @param spaces the spaces used
	 * @param config the config class
	 * @param buffer the buffer used to get for example the clipboard
	 */
	public boolean setChannelActionObject(ArrayList spaces, Config config, BufferAction buffer)  {
		
		try {
			
			if (this.accessClass==null)
				this.accessClass = "org.esupportail.portal.channels.CWebdav.channelAction.webdav.WebdavChannelAction";				
			
			Class classe = Class.forName(this.accessClass);
			Object obj = classe.newInstance();
			
			this.channelAction = (AbstractChannelAction)obj;
			this.channelAction.init(this, spaces, config, buffer);
			
		}
		catch(ClassNotFoundException e) {
			return false;
		}
		catch(IllegalAccessException e) {
			return false;
		}
		catch(InstantiationException e) {
			return false;
		}
		return true;
	}
	
	
	
	/**
	 * Get the channel action object
	 * @return the channel action object
	 */
	public AbstractChannelAction getChannelActionObject() {
		return this.channelAction;
	}
	
	
	
	
	/**
	 * Return a String representation of this space
	 */
	public String toString() {
		return 
		"key: "+key+"\n"+
		"label: "+label+"\n"+
		"path: "+getPath()+"\n";
	}
	
	
}
