/**
 * Cre le 21 Avril 2004
 * Par Sbastien Gougeon
 * Centre de Ressources Informatiques
 * Universit de Rennes 1 - France
 * sebastien.gougeon@univ-rennes1.fr
 * 
 */    
/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

 
package org.esupportail.portal.channels.CWebdav.tests;
//import java.io.IOException;

//import org.apache.commons.httpclient.HttpException;
import org.esupportail.portal.channels.CWebdav.exception.WebdavException;
import org.esupportail.portal.channels.CWebdav.provider.*;

import junit.framework.TestCase;

public class DavControlTest extends TestCase {

	
	//private Resource res; 
	//private Resource res2; 
	private DavAccess dav;
	
	private int i;
	private int i2;
	public static void main(String[] args) {
		junit.swingui.TestRunner.run(DavControlTest.class);			
	}

	protected void setUp() throws Exception {
		super.setUp();
		i = 1003;
		i2 = 0;
		/*Object[]o = new Object[4];
		o[0]="fichier.txt";
		o[1]="15";
		o[2]="text/plain";
		o[3]="15 avr. 2004 12:30:50";
		res = new Resource(o);		
		Object[]o2 = new Object[4];
		o2[0]="titi.txt";
		o2[1]="20";
		o2[2]="text/plain";
		o2[3]="8 avr. 2004 18:58:02";
		res2 = new Resource(o2);*/
		
		dav = new DavAccessImpl();		
		dav.init("http://chene.univ-rennes1.fr:8080/slide","bidon","xpcwd");
		dav.connect();
	}
	 
	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
		//res = null;
		//res2 = null;		
		i=0;
		dav.disconnect();
	}
	 
	public void testIsExist(){
		try {
			assertTrue("verifie si le fichier fichier.txt existe deja", dav.exists("fichier.txt","/slide/files/esup/storage/users/n/no/bidon/testLs/"));
		} catch (WebdavException e) {
			// 
			e.printStackTrace();
		}
	}
	public void testIsNotExist(){
		try {
			assertFalse("verifie si le fichier titi.txt existe deja", dav.exists("titi.txt","/slide/files/esup/storage/users/n/no/bidon/testLs/"));
		} catch (WebdavException e) {
			// 
			e.printStackTrace();
		}
	}
	public void testIsWellFormed(){
		assertTrue("verifie la fonction isWellFormed de DavControl",DavControl.isWellFormed("_azerty345_tr-ert.654ftgh.txt"));
	}
	public void testIsNotWellFormed(){
		assertFalse("verifie la fonction isWellFormed de DavControl",DavControl.isWellFormed(".azerty345_tr-ert.654ftgh.txt"));
	}
	public void testIsNotWellFormed2(){
		assertFalse("verifie la fonction isWellFormed de DavControl",DavControl.isWellFormed("_azer'ty345_tr-ert.654ftgh.txt"));
	}
}
