/*
 * Created on 15 avr. 2004
 */
package org.esupportail.portal.channels.CWebdav.tests;

 
import org.esupportail.portal.channels.CWebdav.provider.ChannelWebdavResource;
import org.esupportail.portal.channels.CWebdav.provider.DavAccess;
import org.esupportail.portal.channels.CWebdav.provider.DavAccessImpl;
 
import junit.framework.TestCase;

/**
 * Id: LsTest.java,v 1.0 15 avr. 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: LsTest<br/>
 * Original Author: Yohan Colmant<br/>
 *
 */
public class LsTest extends TestCase {
	    
	private DavAccess dav;
	private ChannelWebdavResource[] v;
	
	public static void main(String[] args) {
		junit.swingui.TestRunner.run(LsTest.class);
	}
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		
		dav = new DavAccessImpl();
		dav.init("http://chene.univ-rennes1.fr:8080/slide","bidon","xpcwd");
		dav.connect();		
		
		v = dav.ls("/slide/files/esup/storage/users/n/no/bidon/testLs");
	}
	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
		
		dav.disconnect();
	}
	/**
	 * Constructor for LsTest.
	 * @param arg0
	 */
	public LsTest(String arg0) {
		super(arg0);
	}
	
	
	
	
	public void testLsCollection() {				
			assertEquals(v[0].isCollection(),true);
	}
	public void testLsDisplayName() {				
		assertEquals("test DisplayName : ",v[0].getDisplayName(), "repertoire");
	}
	public void testLsContentLength() {				
		assertEquals("test contentLenght : ",v[0].getContentLength(), 0);
	}
	public void testLsContentType() {				
		assertEquals("test contentType",v[0].getContentType(), "");
	}
	
	
	public void testLsDisplayName2() {				
		assertEquals("test displayName 2 : ",v[1].getDisplayName(), "fichier.txt");
	}
	public void testLsContentLength2() {				
		assertEquals("test contentLenght 2 : ",v[1].getContentLength(), 15);
	}
	public void testLsContentType2() {				
		assertEquals("test contentType 2 : ",v[1].getContentType(), "text/plain");
	}
}
